/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.license;

import com.sybase.connector.repra.BaseConst;
import com.sybase.connector.repra.Version;
import com.sybase.connector.repra.license.RepraSySamTimerTask;
import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.util.RepraControlUtil;
import com.sybase.connector.repra.util.RepraPropertyUtil;
import com.sybase.sylapi.SyLAPI;
import com.sybase.sylapi.SyLAPIConstants;
import com.sybase.sylapi.SyLAPIException;
import com.sybase.sylapi.SyLAPILicense;
import com.sybase.sylapi.SyLAPIListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class RepraSySamClient
implements SyLAPIListener,
SyLAPIConstants {
    private static RaLogger _log = null;
    private static SyLAPI _sylapi = null;
    private static SyLAPILicense _license = null;
    private static boolean _licenseOut = false;
    private static Timer _heartBeatTimer = null;
    private static int _interval = -1;

    public RepraSySamClient() {
        Locale.setDefault(Locale.US);
        if (_log == null) {
            _log = new RaLogger(0);
        }
        _log.debug("RepraSySamClient.m0");
        if (_sylapi == null) {
            _sylapi = SyLAPI.getSyLAPI();
        }
    }

    public static boolean getRepraLicense() {
        return _licenseOut;
    }

    private void setRepraLicense(boolean replic) {
        _licenseOut = replic;
    }

    public void setLogger(RaLogger log) {
        _log = log;
    }

    public boolean checkOutRepConnector() {
        if (!_licenseOut) {
            _log.info("RepraSySamClient.m1");
            Runtime.getRuntime().addShutdownHook(new Thread("SySamClientShutdownHook"){

                public void run() {
                    _log.info("RepraSySamClient.m2");
                    try {
                        _interval = -1;
                        RepraSySamClient.this.startHeartBeat();
                        RepraSySamClient.this.checkInRepConnector();
                    }
                    catch (Exception e) {
                        _log.error("RepraSySamClient.e1", (Throwable)e);
                    }
                }
            });
            this.repraCheckOut();
        }
        if (_licenseOut) {
            _log.info("RepraSySamClient.m3");
            this.startHeartBeat();
        } else {
            _log.info("RepraSySamClient.m4");
        }
        return _licenseOut;
    }

    public boolean checkInRepConnector() {
        _log.debug("RepraSySamClient.m5");
        if (_licenseOut) {
            this.repraCheckIn();
            if (!_licenseOut) {
                _log.info("RepraSySamClient.m6");
            } else {
                _log.info("RepraSySamClient.m7");
            }
        }
        return _licenseOut;
    }

    private void repraCheckOut() {
        try {
            int prop_qty;
            int policyID = 1;
            if (_log.getTestPolicy()) {
                policyID = 3;
                _log.debug("RepraSySamClient.m16");
            }
            String templateFile = "";
            String product = "Sybase RepConnector";
            String instance = "RepConnector Server";
            String propFile = RepraPropertyUtil.getRepraDir() + File.separator + "bin" + File.separator + "sysam.properties";
            File ftpr = new File(propFile);
            if (!ftpr.isFile()) {
                _log.debug("RepraSySamClient.m8", propFile);
                propFile = null;
            } else {
                _log.debug("RepraSySamClient.m17", propFile);
            }
            String licenseDir = RepraPropertyUtil.getRepraDir() + File.separator + "SYSAM-2_0" + File.separator + "licenses";
            Locale loc = Locale.getDefault();
            String localeMsgDir = ".";
            Object[] params = new String[]{product, instance, propFile, licenseDir};
            _log.debug("RepraSySamClient.m9", params);
            _sylapi.init(policyID, product, instance, licenseDir, (SyLAPIListener)this, null, propFile, Locale.US, null);
            if (_log.getSySamTrace()) {
                _log.debug("RepraSySamClient.m22");
                _sylapi.enableTracing(true);
            }
            _interval = _sylapi.getHeartbeatInterval();
            _log.debug("RepraSySamClient.m18", "" + _interval);
            String feature = "REP_CONNECTOR";
            String version = Version.getLicenseVersion();
            String filter = BaseConst.REPRA_SYSAM_FILTER;
            String dupGroup = BaseConst.REPRA_SYSAM_DUPGROUP;
            int logical_qty = _sylapi.getLogicalCPUs();
            int phys_qty = _sylapi.getPhysicalCPUs();
            Object[] quantities = new String[]{Integer.toString(logical_qty), Integer.toString(phys_qty)};
            _log.debug("RepraSySamClient.m19", quantities);
            try {
                prop_qty = Integer.parseInt(_sylapi.retrieveProperty("bound.cpus", false));
            }
            catch (Exception e) {
                prop_qty = -1;
            }
            int qty = prop_qty > 0 ? prop_qty : (logical_qty < phys_qty ? logical_qty : phys_qty);
            int flags = 0;
            Object[] checkoutParams = new String[]{feature, version, filter, dupGroup, Integer.toString(qty), Integer.toString(flags)};
            _log.debug("RepraSySamClient.m10", checkoutParams);
            _license = _sylapi.checkout(feature, version, filter, dupGroup, qty, flags);
            ArrayList report = _sylapi.getReport();
            _log.debug("RepraSySamClient.m11", Integer.toString(report.size()));
            for (int i = 0; i < report.size(); ++i) {
                _license = (SyLAPILicense)report.get(i);
                Object[] licenseParams = new String[]{Integer.toString(i + 1), _license.toString()};
                _log.debug("RepraSySamClient.m12", licenseParams);
            }
            this.setRepraLicense(true);
        }
        catch (SyLAPIException ex) {
            _log.error("RepraSySamClient.e2", (Throwable)ex);
            ex.printStackTrace();
            this.setRepraLicense(false);
        }
        catch (Throwable t) {
            _log.error("RepraSySamClient.e3", t);
            t.printStackTrace();
            this.setRepraLicense(false);
        }
    }

    private void startHeartBeat() {
        if (_heartBeatTimer == null) {
            _heartBeatTimer = new Timer();
        }
        if (_interval < 0) {
            _log.debug("RepraSySamClient.m13");
            _heartBeatTimer.cancel();
        } else {
            _log.info("RepraSySamClient.m14", Integer.toString(_interval / 60));
            RepraSySamTimerTask heartBeat = new RepraSySamTimerTask(_log, _sylapi);
            _heartBeatTimer.scheduleAtFixedRate((TimerTask)heartBeat, 5000L, (long)(_interval * 1000));
        }
    }

    private void repraCheckIn() {
        try {
            _sylapi.checkin(_license);
            _sylapi.close();
            this.setRepraLicense(false);
        }
        catch (SyLAPIException ex) {
            _log.error("RepraSySamClient.e1", (Throwable)ex);
            ex.printStackTrace();
            this.setRepraLicense(true);
        }
        catch (Throwable t) {
            _log.error("RepraSySamClient.e1", t);
            t.printStackTrace();
            this.setRepraLicense(true);
        }
    }

    public void expiryHandler(String feature, String version, String filter, String dup_group, int reason) {
        Object[] expireParams = new String[]{feature, version, filter, dup_group, Integer.toString(reason)};
        _log.info("RepraSySamClient.m20", expireParams);
        Vector raStatusVector = null;
        RepraControlUtil controlUtil = new RepraControlUtil();
        try {
            raStatusVector = controlUtil.stopConnection();
            _log.debug("RepraSySamClient.m21", raStatusVector);
        }
        catch (Throwable t) {
            _log.error("RepraSySamClient.e4", t);
            t.printStackTrace();
        }
        _interval = -1;
        this.startHeartBeat();
        this.setRepraLicense(false);
    }

    public void displayMsg(int severity, int id, String s) {
        if (severity == 40) {
            Object[] msgParams = new String[]{"LOG", Integer.toString(id), s};
            _log.info("RepraSySamClient.m15", msgParams);
        } else if (severity == 60) {
            Object[] msgParams = new String[]{"INFORMATIONAL", Integer.toString(id), s};
            _log.info("RepraSySamClient.m15", msgParams);
        } else if (severity == 80) {
            Object[] msgParams = new String[]{"WARNING", Integer.toString(id), s};
            _log.info("RepraSySamClient.m15", msgParams);
        } else if (severity == 100) {
            Object[] msgParams = new String[]{"ERROR", Integer.toString(id), s};
            _log.error("RepraSySamClient.m15", msgParams);
        } else {
            Object[] msgParams = new String[]{"DEBUG", Integer.toString(id), s};
            _log.info("RepraSySamClient.m15", msgParams);
        }
    }
}

