/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.logging;

import com.sybase.connector.repra.logging.RJPatternLayout;
import com.sybase.connector.repra.logging.RaLoggerFactory;
import com.sybase.connector.repra.util.RepraPropertyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.LoggerFactory;

public class RaLogger
extends Logger {
    private static RaLoggerFactory _raFactory = new RaLoggerFactory();
    public static final int NUMBER_TYPES = 3;
    public static final int RUNTIME = 0;
    public static final int COMMAND = 1;
    public static final int CONSOLE = 2;
    public static final String REPRA_HOME = "repra.home";
    public static final String[] MODULE_NAMES = new String[]{"RUNTIME", "COMMAND", "CONSOLE"};
    private static final String[] RESOURCE_BUNDLES = new String[]{"com.sybase.connector.repra.RepraBundle", "com.sybase.connector.repra.ratool.ToolBundle", "com.sybase.connector.repra.RepraBundle"};
    private String _name = "repra";
    private int _type = 0;
    private String _logLevel = null;
    private String _custResourceBundle = null;
    private String _defaultAppenderName = null;
    private String _consoleTarget = "System.out";
    private String _filepath = null;
    String _language = "en";
    String _country = "US";
    private boolean _useTestPolicy = false;
    private boolean _remoteRepServer = false;
    private boolean _sysamTrace = false;
    private boolean _useRealChars = false;
    public static String RUNTIME_LOGFILE = RepraPropertyUtil.getRepraDir() + File.separator + "logs" + File.separator + "repra.log";
    private static Properties _props = null;

    public RaLogger(String name) {
        super(name);
        this._type = 0;
        this._name = name;
        this._filepath = this._defaultAppenderName = RUNTIME_LOGFILE;
        this.buildLogger();
    }

    public RaLogger(int type) {
        super(MODULE_NAMES[type]);
        RaLogger.getRootLogger();
        Logger.getLogger((String)MODULE_NAMES[type], (LoggerFactory)_raFactory);
        this._type = type;
        this._name = MODULE_NAMES[this._type];
        if (type == 0) {
            this._filepath = this._defaultAppenderName = RUNTIME_LOGFILE;
        }
        if (type == 1) {
            this._logLevel = "INFO";
        }
        this.buildLogger();
    }

    public RaLogger(int type, String logLevel) {
        super(MODULE_NAMES[type]);
        RaLogger.getRootLogger();
        Logger.getLogger((String)MODULE_NAMES[type], (LoggerFactory)_raFactory);
        this._type = type;
        this._name = MODULE_NAMES[this._type];
        this._logLevel = logLevel;
        if (type == 0) {
            this._filepath = this._defaultAppenderName = RUNTIME_LOGFILE;
        }
        this.buildLogger();
    }

    public RaLogger(String name, int type, String logLevel) {
        super(name);
        RaLogger.getRootLogger();
        Logger.getLogger((String)name, (LoggerFactory)_raFactory);
        this._type = type;
        this._name = name;
        if (this._type == 0) {
            this._defaultAppenderName = RUNTIME_LOGFILE;
        }
        this._filepath = this._defaultAppenderName;
        this._logLevel = logLevel;
        this.buildLogger();
    }

    public RaLogger(int type, String logLevel, String filepath, String custResourceBundle) {
        super(MODULE_NAMES[type]);
        RaLogger.getRootLogger();
        Logger.getLogger((String)MODULE_NAMES[type], (LoggerFactory)_raFactory);
        this._type = type;
        this._name = MODULE_NAMES[this._type];
        if (this._type == 0) {
            this._defaultAppenderName = RUNTIME_LOGFILE;
        }
        this._filepath = filepath;
        this._logLevel = logLevel;
        this._custResourceBundle = custResourceBundle;
        this.buildLogger();
    }

    public RaLogger(int type, String logLevel, String filepath) {
        super(MODULE_NAMES[type]);
        RaLogger.getRootLogger();
        Logger.getLogger((String)MODULE_NAMES[type], (LoggerFactory)_raFactory);
        this._type = type;
        if (this._type == 0) {
            this._defaultAppenderName = RUNTIME_LOGFILE;
        }
        this._name = MODULE_NAMES[this._type];
        this._filepath = filepath;
        this._logLevel = logLevel;
        this.buildLogger();
    }

    private void setTestPolicy(boolean testPolicy) {
        this._useTestPolicy = testPolicy;
    }

    public boolean getTestPolicy() {
        return this._useTestPolicy;
    }

    private void setRemoteRepServer(boolean remoteRepServer) {
        this._remoteRepServer = remoteRepServer;
    }

    public boolean getRemoteRepServer() {
        return this._remoteRepServer;
    }

    private void setSySamTrace(boolean sysamTrace) {
        this._sysamTrace = sysamTrace;
    }

    public boolean getSySamTrace() {
        return this._sysamTrace;
    }

    private void setCharPolicy(boolean charPolicy) {
        this._useRealChars = charPolicy;
    }

    public boolean getCharPolicy() {
        return this._useRealChars;
    }

    public static Category getInstance(String name) {
        return Logger.getLogger((String)name, (LoggerFactory)_raFactory);
    }

    public static Logger getLogger(String name) {
        return Logger.getLogger((String)name, (LoggerFactory)_raFactory);
    }

    public void buildLogger() {
        try {
            this.setAdditivity(false);
            this.loadConfig();
            this.setLevel();
            this.setModuleResourceBundle();
            this.getFilepath();
            this.setAppender();
            this.setAdditivity(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadConfig() {
        try {
            String configFile = RepraPropertyUtil.getRepraDir() + File.separator + "bin" + File.separator + "repra.properties";
            _props = new Properties();
            FileInputStream fin = null;
            File ftpr = new File(configFile);
            if (!ftpr.isFile()) {
                String repraHome = System.getProperty(REPRA_HOME, "..");
                ftpr = new File(repraHome + File.separator + "bin" + File.separator + "repra.properties");
                if (!ftpr.isFile()) {
                    this._type = 2;
                    return;
                }
                this._type = 1;
            }
            fin = new FileInputStream(ftpr);
            _props.load(fin);
            this._language = _props.getProperty("logging.language", "en");
            this._country = _props.getProperty("logging.country", "US");
            if (_props.getProperty("SYLAPI_TEST_POLICY", "false").equalsIgnoreCase("true")) {
                this.setTestPolicy(true);
            }
            if (_props.getProperty("REMOTE_REPSERVER_OPTION", "false").equalsIgnoreCase("true")) {
                this.setRemoteRepServer(true);
            }
            if (_props.getProperty("SYSAM_TRACE_FLAG", "false").equalsIgnoreCase("true")) {
                this.setSySamTrace(true);
            }
            if (this._type == 0 && (this._logLevel == null || this._logLevel.equals(""))) {
                this._logLevel = _props.getProperty("LogLevel", "INFO");
            }
            if (_props.getProperty("REAL_CHARACTER_OPTION", "false").equalsIgnoreCase("true")) {
                this.setCharPolicy(true);
            }
            if (this._name.equals("RUNTIME")) {
                this._logLevel = _props.getProperty("RuntimeLogLevel", "ERROR");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setModuleResourceBundle() throws Exception {
        if (this._type == 0 && RaLogger.getRootLogger().getResourceBundle() != null && RaLogger.getRootLogger().getResourceBundle().getString("Sybase.Repra.Bundle") != null) {
            return;
        }
        if (this._custResourceBundle != null) {
            RaLogger.getRootLogger().setResourceBundle(ResourceBundle.getBundle(this._custResourceBundle, new Locale(this._language, this._country)));
        } else {
            RaLogger.getRootLogger().setResourceBundle(ResourceBundle.getBundle(RESOURCE_BUNDLES[this._type], new Locale(this._language, this._country)));
        }
    }

    public void getFilepath() throws Exception {
        File pf;
        if (this._type == 0) {
            this._filepath = RUNTIME_LOGFILE;
        } else if (this._type == 2) {
            this._filepath = null;
        }
        if (this._filepath == null || this._filepath.equals("") || this._filepath.startsWith("/logs") || this._filepath.startsWith("\\logs")) {
            this._filepath = null;
            return;
        }
        File logFile = new File(this._filepath);
        String parent = logFile.getParent();
        if (parent != null && !(pf = new File(parent)).isDirectory()) {
            pf.mkdirs();
        }
    }

    private void setLevel() {
        if (this._logLevel == null) {
            Logger.getLogger((String)this._name).setLevel(Level.DEBUG);
        } else if (this._logLevel.equalsIgnoreCase("DEBUG")) {
            Logger.getLogger((String)this._name).setLevel(Level.DEBUG);
        } else if (this._logLevel.equalsIgnoreCase("INFO")) {
            Logger.getLogger((String)this._name).setLevel(Level.INFO);
        } else if (this._logLevel.equalsIgnoreCase("WARNING")) {
            Logger.getLogger((String)this._name).setLevel(Level.WARN);
        } else if (this._logLevel.equalsIgnoreCase("ERROR")) {
            Logger.getLogger((String)this._name).setLevel(Level.ERROR);
        } else if (this._logLevel.equalsIgnoreCase("FATAL")) {
            Logger.getLogger((String)this._name).setLevel(Level.FATAL);
        } else {
            Logger.getLogger((String)this._name).setLevel(Level.ERROR);
        }
    }

    private void setAppender() throws Exception {
        String appenderName = null;
        if (this._type == 0) {
            if (RaLogger.getRootLogger().getAppender(this._defaultAppenderName) != null) {
                return;
            }
            appenderName = this._defaultAppenderName;
        } else if (this._type == 1 && this._filepath != null && !this._filepath.equals("")) {
            appenderName = this._filepath;
        }
        ConsoleAppender logAppender = null;
        RJPatternLayout layout = null;
        String rollover = "yyyy-MM-dd'.txt'";
        if (appenderName != null && !appenderName.equals("")) {
            layout = new RJPatternLayout();
            layout = this._type == 0 ? new RJPatternLayout() : new RJPatternLayout("%m%n");
            if (_props != null && _props.getProperty("appender.mode", "date").equalsIgnoreCase("size")) {
                logAppender = new RollingFileAppender((Layout)layout, appenderName, true);
                ((RollingFileAppender)logAppender).setMaxFileSize(_props.getProperty("appender.size", "1MB"));
                ((RollingFileAppender)logAppender).setMaxBackupIndex(Integer.parseInt(_props.getProperty("appender.index", "10")));
                logAppender.setName(appenderName);
            } else {
                logAppender = new DailyRollingFileAppender((Layout)layout, appenderName, rollover);
                logAppender.setName(appenderName);
                ((DailyRollingFileAppender)logAppender).setAppend(true);
            }
        } else {
            layout = new RJPatternLayout("%m%n");
            logAppender = new ConsoleAppender((Layout)layout, this._consoleTarget);
        }
        this.addAppender((Appender)logAppender);
    }

    public void fatal(Object message) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.FATAL, (String)message, null);
    }

    public void fatal(Object message, Throwable tt) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.FATAL, (String)message, tt);
    }

    public void fatal(String key) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.FATAL, key, null);
    }

    public void fatal(String key, Throwable tt) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.FATAL, key, tt);
    }

    public void fatal(String key, Object arg0) {
        Object[] args = new Object[]{arg0};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.FATAL, key, args, null);
    }

    public void fatal(String key, Object arg0, Throwable tt) {
        Object[] args = new Object[]{arg0};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.FATAL, key, args, tt);
    }

    public void fatal(String key, Object arg0, Object arg1) {
        Object[] args = new Object[]{arg0, arg1};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.FATAL, key, args, null);
    }

    public void fatal(String key, Object arg0, Object arg1, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.FATAL, key, args, tt);
    }

    public void fatal(String key, Object arg0, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.FATAL, key, args, null);
    }

    public void fatal(String key, Object arg0, Object arg1, Object arg2, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.FATAL, key, args, tt);
    }

    public void fatal(String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.FATAL, key, args, null);
    }

    public void fatal(String key, Object arg0, Object arg1, Object arg2, Object arg3, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.FATAL, key, args, tt);
    }

    public void fatal(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.FATAL, key, args, null);
    }

    public void fatal(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.FATAL, key, args, tt);
    }

    public void fatal(String key, Object[] args) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.FATAL, key, args, null);
    }

    public void fatal(String key, Object[] args, Throwable tt) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.FATAL, key, args, tt);
    }

    public void error(Object message) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.ERROR, (String)message, null);
    }

    public void error(Object message, Throwable tt) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.ERROR, (String)message, tt);
    }

    public void error(String key) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.ERROR, key, null);
    }

    public void error(String key, Throwable tt) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.ERROR, key, tt);
    }

    public void error(String key, Object arg0) {
        Object[] args = new Object[]{arg0};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.ERROR, key, args, null);
    }

    public void error(String key, Object arg0, Throwable tt) {
        Object[] args = new Object[]{arg0};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.ERROR, key, args, tt);
    }

    public void error(String key, Object arg0, Object arg1) {
        Object[] args = new Object[]{arg0, arg1};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.ERROR, key, args, null);
    }

    public void error(String key, Object arg0, Object arg1, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.ERROR, key, args, tt);
    }

    public void error(String key, Object arg0, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.ERROR, key, args, null);
    }

    public void error(String key, Object arg0, Object arg1, Object arg2, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.ERROR, key, args, tt);
    }

    public void error(String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.ERROR, key, args, null);
    }

    public void error(String key, Object arg0, Object arg1, Object arg2, Object arg3, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.ERROR, key, args, tt);
    }

    public void error(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.ERROR, key, args, null);
    }

    public void error(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.ERROR, key, args, tt);
    }

    public void error(String key, Object[] args) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.ERROR, key, args, null);
    }

    public void error(String key, Object[] args, Throwable tt) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.ERROR, key, args, tt);
    }

    public void warn(Object message) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.WARN, (String)message, null);
    }

    public void warn(Object message, Throwable tt) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.WARN, (String)message, tt);
    }

    public void warn(String key) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.WARN, key, null);
    }

    public void warn(String key, Throwable tt) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.WARN, key, tt);
    }

    public void warn(String key, Object arg0) {
        Object[] args = new Object[]{arg0};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.WARN, key, args, null);
    }

    public void warn(String key, Object arg0, Throwable tt) {
        Object[] args = new Object[]{arg0};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.WARN, key, args, tt);
    }

    public void warn(String key, Object arg0, Object arg1) {
        Object[] args = new Object[]{arg0, arg1};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.WARN, key, args, null);
    }

    public void warn(String key, Object arg0, Object arg1, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.WARN, key, args, tt);
    }

    public void warn(String key, Object arg0, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.WARN, key, args, null);
    }

    public void warn(String key, Object arg0, Object arg1, Object arg2, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.WARN, key, args, tt);
    }

    public void warn(String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.WARN, key, args, null);
    }

    public void warn(String key, Object arg0, Object arg1, Object arg2, Object arg3, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.WARN, key, args, tt);
    }

    public void warn(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.WARN, key, args, null);
    }

    public void warn(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.WARN, key, args, tt);
    }

    public void warn(String key, Object[] args) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.WARN, key, args, null);
    }

    public void warn(String key, Object[] args, Throwable tt) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.WARN, key, args, tt);
    }

    public boolean isInfo() {
        return super.isInfoEnabled();
    }

    public void info(Object message) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.INFO, (String)message, null);
    }

    public void info(Object message, Throwable tt) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.INFO, (String)message, tt);
    }

    public void info(String key) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.INFO, key, null);
    }

    public void info(String key, Throwable tt) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.INFO, key, tt);
    }

    public void info(String key, Object arg0) {
        Object[] args = new Object[]{arg0};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.INFO, key, args, null);
    }

    public void info(String key, Object arg0, Throwable tt) {
        Object[] args = new Object[]{arg0};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.INFO, key, args, tt);
    }

    public void info(String key, Object arg0, Object arg1) {
        Object[] args = new Object[]{arg0, arg1};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.INFO, key, args, null);
    }

    public void info(String key, Object arg0, Object arg1, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.INFO, key, args, tt);
    }

    public void info(String key, Object arg0, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.INFO, key, args, null);
    }

    public void info(String key, Object arg0, Object arg1, Object arg2, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.INFO, key, args, tt);
    }

    public void info(String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.INFO, key, args, null);
    }

    public void info(String key, Object arg0, Object arg1, Object arg2, Object arg3, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.INFO, key, args, tt);
    }

    public void info(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.INFO, key, args, null);
    }

    public void info(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.INFO, key, args, tt);
    }

    public void info(String key, Object[] args) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.INFO, key, args, null);
    }

    public void info(String key, Object[] args, Throwable tt) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.INFO, key, args, tt);
    }

    public boolean isDebug() {
        return super.isDebugEnabled();
    }

    public void debug(Object message) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.DEBUG, (String)message, null);
    }

    public void debug(Object message, Throwable tt) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.DEBUG, (String)message, tt);
    }

    public void debug(String key) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.DEBUG, key, null);
    }

    public void debug(String key, Throwable tt) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.DEBUG, key, tt);
    }

    public void debug(String key, Object arg0) {
        Object[] args = new Object[]{arg0};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.DEBUG, key, args, null);
    }

    public void debug(String key, Object arg0, Throwable tt) {
        Object[] args = new Object[]{arg0};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.DEBUG, key, args, tt);
    }

    public void debug(String key, Object arg0, Object arg1) {
        Object[] args = new Object[]{arg0, arg1};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.DEBUG, key, args, null);
    }

    public void debug(String key, Object arg0, Object arg1, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.DEBUG, key, args, tt);
    }

    public void debug(String key, Object arg0, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.DEBUG, key, args, null);
    }

    public void debug(String key, Object arg0, Object arg1, Object arg2, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.DEBUG, key, args, tt);
    }

    public void debug(String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.DEBUG, key, args, null);
    }

    public void debug(String key, Object arg0, Object arg1, Object arg2, Object arg3, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.DEBUG, key, args, tt);
    }

    public void debug(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.DEBUG, key, args, null);
    }

    public void debug(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.DEBUG, key, args, tt);
    }

    public void debug(String key, Object[] args) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.DEBUG, key, args, null);
    }

    public void debug(String key, Object[] args, Throwable tt) {
        Logger.getLogger((String)this._name).l7dlog((Priority)Level.DEBUG, key, args, tt);
    }

    public boolean logAssert(Level level) {
        if (super.getLoggerRepository().isDisabled(level.toInt())) {
            return false;
        }
        return level.isGreaterOrEqual((Priority)super.getEffectiveLevel());
    }

    public void atLevel(Level level, String key) {
        Logger.getLogger((String)this._name).l7dlog((Priority)level, key, null);
    }

    public void atLevel(Level level, String key, Throwable tt) {
        Logger.getLogger((String)this._name).l7dlog((Priority)level, key, tt);
    }

    public void atLevel(Level level, String key, Object arg0) {
        Object[] args = new Object[]{arg0};
        Logger.getLogger((String)this._name).l7dlog((Priority)level, key, args, null);
    }

    public void atLevel(Level level, String key, Object arg0, Throwable tt) {
        Object[] args = new Object[]{arg0};
        Logger.getLogger((String)this._name).l7dlog((Priority)level, key, args, tt);
    }

    public void atLevel(Level level, String key, Object arg0, Object arg1) {
        Object[] args = new Object[]{arg0, arg1};
        Logger.getLogger((String)this._name).l7dlog((Priority)level, key, args, null);
    }

    public void atLevel(Level level, String key, Object arg0, Object arg1, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1};
        Logger.getLogger((String)this._name).l7dlog((Priority)level, key, args, tt);
    }

    public void atLevel(Level level, String key, Object arg0, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        Logger.getLogger((String)this._name).l7dlog((Priority)level, key, args, null);
    }

    public void atLevel(Level level, String key, Object arg0, Object arg1, Object arg2, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        Logger.getLogger((String)this._name).l7dlog((Priority)level, key, args, tt);
    }

    public void atLevel(Level level, String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        Logger.getLogger((String)this._name).l7dlog((Priority)level, key, args, null);
    }

    public void atLevel(Level level, String key, Object arg0, Object arg1, Object arg2, Object arg3, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        Logger.getLogger((String)this._name).l7dlog((Priority)level, key, args, tt);
    }

    public void atLevel(Level level, String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        Logger.getLogger((String)this._name).l7dlog((Priority)level, key, args, null);
    }

    public void atLevel(Level level, String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        Logger.getLogger((String)this._name).l7dlog((Priority)level, key, args, tt);
    }

    public void atLevel(Level level, String key, Object[] args) {
        Logger.getLogger((String)this._name).l7dlog((Priority)level, key, args, null);
    }

    public void atLevel(Level level, String key, Object[] args, Throwable tt) {
        Logger.getLogger((String)this._name).l7dlog((Priority)level, key, args, tt);
    }

    public ResourceBundle getResourceBundle() {
        ResourceBundle bundle = RaLogger.getRootLogger().getResourceBundle();
        if (bundle == null) {
            try {
                this.setModuleResourceBundle();
                bundle = RaLogger.getRootLogger().getResourceBundle();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bundle;
    }

    public String getResourceBundleString(String key) {
        String value = null;
        ResourceBundle bundle = this.getResourceBundle();
        if (bundle != null) {
            try {
                value = bundle.getString(key);
            }
            catch (Exception mre) {
                // empty catch block
            }
        }
        return value;
    }
}

