/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.mq;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.sybase.connector.repra.RepraAdapter;
import com.sybase.connector.repra.RepraClient;
import com.sybase.connector.repra.logging.RaLogger;
import java.util.Properties;

public abstract class MQBase
extends Thread
implements RepraAdapter,
RepraClient {
    protected RaLogger _log = null;
    protected Properties _cProps = null;
    protected String _hostname;
    protected String _portnumber;
    protected String _channel;
    protected String _username;
    protected String _password;
    protected MQQueueManager _queueManager;
    protected MQQueue _localQueue;
    protected MQMessage _mqMessage;
    protected String _qmgr;
    protected String _lqueue;
    protected boolean _localConnection = true;
    protected String _encode = "";

    public void initMQClient(Properties cProps, RaLogger log) {
        this._cProps = cProps;
        this._log = log;
        this.getHostInformation();
    }

    public void setLogger(RaLogger log) {
        if (this._log == null) {
            this._log = log;
        }
    }

    public void configureClient() throws Exception {
        try {
            MQEnvironment.hostname = this._hostname;
            if (this._portnumber == null || this._portnumber.equals("\"\"") || this._portnumber.equals("''")) {
                this._portnumber = "";
            }
            if (!this._portnumber.equals("")) {
                MQEnvironment.port = Integer.parseInt(this._portnumber);
            }
            if (this._channel == null || this._channel.equals("\"\"") || this._channel.equals("''")) {
                this._channel = "";
            }
            if (!this._channel.equals("")) {
                MQEnvironment.channel = this._channel;
            }
            if (this._username != null && this._username.equals("")) {
                MQEnvironment.userID = this._username;
            }
            if (this._password != null && this._password.equals("")) {
                MQEnvironment.password = this._password;
            }
            MQEnvironment.properties.put("transport", "MQSeries");
            this._queueManager = new MQQueueManager(this._qmgr);
            int option = 16;
            this._localQueue = this._queueManager.accessQueue(this._lqueue, option);
            this._log.info("MQClient.configureClient.m1", (Object)this._qmgr, (Object)this._lqueue, (Object)(this._channel + ":" + this._portnumber), this._hostname);
        }
        catch (Exception ex) {
            this._log.error("MQClient.configureClient.e1", (Object)this._lqueue, (Object)this._qmgr, (Object)(this._channel + ":" + this._portnumber), (Object)this._hostname, ex);
            throw ex;
        }
    }

    public boolean sendEvent(Object obj) throws Exception {
        throw new Exception();
    }

    public boolean sendEvent(Object obj, String eventId) throws Exception {
        throw new Exception();
    }

    public boolean isReady() {
        return this._queueManager != null;
    }

    public void close() {
        try {
            if (this._queueManager != null) {
                this._queueManager.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void getHostInformation() {
        this._qmgr = this._cProps.getProperty("MQ_QueueManager", "javax.jms.QueueConnectionFactory");
        this._lqueue = this._cProps.getProperty("MQ_LocalQueue", "repra_DEFAULT_QUEUE");
        if (!this._cProps.getProperty("MQ_LocalClient", "true").equals("true")) {
            this._localConnection = false;
        }
        this._username = this._cProps.getProperty("MQ_Username", "");
        this._password = this._cProps.getProperty("MQ_Password", "");
        this._hostname = this._cProps.getProperty("MQ_Hostname", "localhost");
        this._portnumber = this._cProps.getProperty("MQ_PortNumber", "");
        this._channel = this._cProps.getProperty("MQ_Channel", "");
        this._encode = this._cProps.getProperty("MQ_Encoding", "");
    }

    public String getConnectionName() {
        return this._cProps.getProperty("ConnectionName");
    }

    public void setProperties(Properties props) {
        this._cProps = props;
    }

    public Properties getProperties() {
        return this._cProps;
    }
}

