/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.mq;

import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.mq.MQJMSBase;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class MQJMSTopicClient
extends MQJMSBase {
    private Topic _topic = null;

    public MQJMSTopicClient() {
    }

    public MQJMSTopicClient(Properties cProps, RaLogger log) {
        this.initMQClient(cProps, log);
        this._log.info("MQJMSTopicClient.init.m1");
    }

    public void configureClient() throws Exception {
        this.configureMQJMS();
        try {
            this._topic = ((TopicSession)this._session).createTopic(this._lqueue);
            this._sender = ((TopicSession)this._session).createPublisher(this._topic);
            this._sender.setDisableMessageID(true);
            if (!this._cProps.getProperty("JMS_TopicSubscribers", "").equals("")) {
                StringTokenizer stoken = new StringTokenizer(this._cProps.getProperty("JMS_TopicSubscribers"), ",");
                String sub = "";
                while (stoken.hasMoreTokens()) {
                    sub = stoken.nextToken().trim();
                    TopicSubscriber topicSubscriber = ((TopicSession)this._session).createDurableSubscriber(this._topic, sub);
                }
            }
            this._log.info("MQJMSTopicClient.configureClient.m1", this._topic.getTopicName());
        }
        catch (Exception ex) {
            String info = this._hostname + ":" + this._portnumber + ":" + this._qmgr + ":" + this._username;
            this._log.error("MQJMSTopicClient.configureClient.e1", (Object)this._lqueue, (Object)info, ex);
        }
    }

    public boolean sendEvent(Object repMessage, String eventId) throws Exception {
        try {
            this._message = this.createMessage(repMessage, eventId);
            ((TopicPublisher)this._sender).publish(this._message, 2, 4, 0L);
            this._log.info("JMSTopicClient.sendEvent.m1", this._lqueue);
            if (repMessage instanceof String) {
                this._log.debug("JMSTopicClient.sendEvent.m2", (String)repMessage);
            } else {
                this._log.debug("JMSTopicClient.sendEvent.m2", repMessage.toString());
            }
            return true;
        }
        catch (Exception ex) {
            String info = this._hostname + ":" + this._portnumber + ":" + this._qmgr + ":" + this._username;
            this._log.error("JMSTopicClient.sendEvent.e1", (Object)this._lqueue, (Object)info, ex);
            throw ex;
        }
    }
}

