/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.ratool;

import com.sybase.connector.repra.ratool.Command;
import com.sybase.connector.repra.ratool.RTException;
import com.sybase.connector.repra.ratool.RTResourceManager;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;

public class Utils {
    private static RTResourceManager _resources = new RTResourceManager(Utils.class);

    private Utils() {
    }

    public static Vector arrayToVector(Object[] array) {
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < array.length; ++i) {
            v.addElement(array[i]);
        }
        return v;
    }

    public static String arrayToString(Object[] array) {
        return Utils.arrayToString(array, " ");
    }

    public static String arrayToString(Object[] array, String delimiter) {
        String s = "";
        for (int i = 0; i < array.length; ++i) {
            s = s + array[i];
            if (i >= array.length - 1) continue;
            s = s + delimiter;
        }
        return s;
    }

    public static String formatDescription(String commandName, String desc) {
        return _resources.getString("ratoolCommandDesc", new String[]{commandName, desc});
    }

    public static String formatUsage(String commandName, String usage) {
        return _resources.getString("ratoolCommandUsage", new String[]{commandName, usage});
    }

    public static String formatEntityTypeList(String[] entityTypes) {
        Object[] s = (String[])entityTypes.clone();
        Arrays.sort(s);
        String indent = _resources.getString("entityTypeIndent");
        StringBuffer buf = new StringBuffer(256);
        int i = 0;
        while (i < s.length) {
            StringBuffer line = new StringBuffer();
            line.append(indent);
            while (line.length() < 60 && i < s.length) {
                line.append((String)s[i]);
                line.append(" ");
                ++i;
            }
            line.setLength(line.length() - 1);
            buf.append(line);
            buf.append("\n");
        }
        buf.setLength(buf.length() - 1);
        return buf.toString();
    }

    public static String formatCommandMsg(String commandName, String msg) {
        return _resources.getString("ratoolCommandMsg", new String[]{commandName, msg});
    }

    public static String formatMissingValueMsg(String optionName) {
        return _resources.getString("missingValueMsg", new String[]{optionName});
    }

    public static String formatInvalidValueMsg(String optionName, String invalidValue) {
        return _resources.getString("invalidValueMsg", new String[]{optionName, invalidValue});
    }

    public static String formatUnknownOptionMsg(String optionName) {
        return _resources.getString("unknownOptionMsg", new String[]{optionName});
    }

    public static String formatInvalidEntityTypeMsg(String invalidType, String[] validTypes) {
        Arrays.sort(validTypes);
        return _resources.getString("invalidEntityTypeMsg", new String[]{invalidType, Utils.arrayToString(validTypes)});
    }

    public static String getParentName(Command command, String entityName) throws RTException {
        int index = entityName.indexOf("/");
        if (index <= 0) {
            throw new RTException(_resources.getString("incorrectEntityNameMsg"), command);
        }
        return entityName.substring(0, index);
    }

    public static String getChildName(Command command, String entityName) throws RTException {
        int index = entityName.indexOf("/");
        if (index <= 0) {
            throw new RTException(_resources.getString("incorrectEntityNameMsg"), command);
        }
        return entityName.substring(index + 1);
    }

    public static Vector getPropertyAsList(String propValue) {
        StringTokenizer st = new StringTokenizer(propValue, ",", false);
        Vector<String> list = new Vector<String>();
        while (st.hasMoreTokens()) {
            list.addElement(st.nextToken());
        }
        return list;
    }

    public static String formPropertyList(Vector props) {
        if (props == null || props.size() == 0) {
            return "";
        }
        String s = "";
        for (int i = 0; i < props.size(); ++i) {
            s = s + (String)props.get(i) + ",";
        }
        return s.substring(0, s.length() - 1);
    }
}

