/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.ratool.commands;

import com.sybase.connector.repra.ratool.BaseCommand;
import com.sybase.connector.repra.ratool.RTContext;
import com.sybase.connector.repra.ratool.RTResourceManager;
import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaException;
import com.sybase.connector.repra.util.RaStatus;
import com.sybase.connector.repra.util.RepraPropertyUtil;
import java.util.Enumeration;
import java.util.Properties;

public class GetPropertyCommand
extends BaseCommand {
    private static RTResourceManager _resources = new RTResourceManager(GetPropertyCommand.class);

    public String getName() {
        return _resources.getString("getProperty.Name");
    }

    public String getDescription() {
        return _resources.getString("getProperty.Desc");
    }

    public String getUsage() {
        return _resources.getString("getProperty.Usage");
    }

    public boolean isHidden() {
        return false;
    }

    public void run() throws Exception {
        _log.debug("RaCommand[DEBUG]:  Arguments to getPropertyCommand: " + this._args.toString());
        if (this._args.size() < 1) {
            _log.error("RaCommand[ERROR]:  " + _resources.getString("wrong.argument"));
            return;
        }
        String connName = (String)this._args.elementAt(0);
        _log.debug("RaCommand[DEBUG]:  getProperty.verbose.1'" + connName + "'");
        String connFileName = null;
        boolean writeToFile = false;
        if (this._args.size() > 1 && ((String)this._args.elementAt(1)).equals("-file")) {
            writeToFile = true;
            connFileName = this._args.size() > 2 ? (String)this._args.elementAt(2) : "default" + connName + ".props";
        }
        try {
            RTContext context = (RTContext)this.getBaseRTContext();
            RaClientUtil raClient = context.getRaClient();
            RaStatus returnObj = raClient.getConnectionProps(connName);
            if (returnObj == null || !(returnObj instanceof RaStatus)) {
                _log.error("RaCommand[ERROR]:  " + _resources.getString("status.unknown"));
                return;
            }
            RaStatus raS = returnObj;
            _log.debug("RaCommand[DEBUG]:  raStatus Object = " + raS.toString());
            if (raS.getCode() == 0) {
                Object retObj = raS.getReturnObject();
                if (retObj == null || !(retObj instanceof Properties)) {
                    _log.error("RaCommand[ERROR]:  " + _resources.getString("status.unknown"));
                    return;
                }
                Properties retP = (Properties)retObj;
                if (retP.isEmpty()) {
                    _log.error("RaCommand[ERROR]:  " + _resources.getString("getProperty.noprop"));
                    return;
                }
                Properties retPEncrypted = RepraPropertyUtil.encProperties(retP);
                if (writeToFile) {
                    _log.info("RaCommand[INFO]:  " + _resources.getString("getProperty.writeTo", new String[]{connFileName}));
                    this.writeToFile(connFileName, connName, retPEncrypted);
                } else {
                    _log.info(_resources.getString("getProperty.connProps") + "'" + connName + "':");
                    _log.info("");
                    Enumeration<?> e = retPEncrypted.propertyNames();
                    while (e.hasMoreElements()) {
                        String propName = (String)e.nextElement();
                        _log.info(_resources.getString("getProperty.propnamevalue", new String[]{propName, retPEncrypted.getProperty(propName)}));
                    }
                }
            } else if (raS.getCode() == 2) {
                _log.info("RaCommand[WARN]:  " + raS.getMessage());
            } else if (raS.getCode() == 4) {
                _log.error("RaCommand[ERROR]:  " + raS.getMessage());
            }
        }
        catch (RaException rae) {
            _log.error("RaCommand[ERROR]:  " + _resources.getString("getProperty.status.fail") + rae.toString());
        }
    }
}

