/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.ratool.commands;

import com.sybase.connector.repra.ratool.BaseCommand;
import com.sybase.connector.repra.ratool.BaseRTContext;
import com.sybase.connector.repra.ratool.Command;
import com.sybase.connector.repra.ratool.CommandFactory;
import com.sybase.connector.repra.ratool.RTResourceManager;
import java.util.Vector;

public class HelpCommand
extends BaseCommand {
    private static RTResourceManager _resources = new RTResourceManager(HelpCommand.class);

    public String getName() {
        return _resources.getString("help.Name");
    }

    public String getDescription() {
        return _resources.getString("help.Desc");
    }

    public String getUsage() {
        return _resources.getString("help.Usage");
    }

    public boolean isHidden() {
        return false;
    }

    public void run() throws Exception {
        _log.debug("RaCommand[DEBUG]:  At run() in HelpCommand: " + this._args.toString().toString());
        CommandFactory factory = CommandFactory.instance();
        factory.setLogger(_log);
        factory.initialize(BaseRTContext.getCommandFile());
        if (this._args.size() < 1) {
            _log.info(_resources.getString("ratoolUsage", new String[]{_resources.getString("PRODUCT_NAME"), "localhost"}));
            _log.info(_resources.getString("ratoolHelpHint", new String[]{BaseRTContext.getToolName()}));
            _log.info("");
            Vector names = factory.getCommandNames();
            _log.info(_resources.getString("ratoolCommandSummaryDesc"));
            _log.info("");
            for (int i = 0; i < names.size(); ++i) {
                Command command = factory.createCommand((String)names.elementAt(i));
                if (command.isHidden()) continue;
                _log.info(_resources.getString("ratoolCommandDesc", new String[]{command.getName(), command.getDescription()}));
            }
            _log.info("");
            _log.info(_resources.getString("ratoolHelpCommandHint", new String[]{BaseRTContext.getToolName()}));
            return;
        }
        String theCommand = (String)this._args.elementAt(0);
        if (!factory.hasCommand(theCommand)) {
            _log.error(_resources.getString("help.notvalid", new String[]{theCommand}));
            _log.info(this.getUsage());
            return;
        }
        Command command = factory.createCommand(theCommand);
        _log.info(_resources.getString("ratoolCommandDesc", new String[]{command.getName(), command.getDescription()}));
        _log.info(command.getUsage());
    }
}

