/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.ratool.commands;

import com.sybase.connector.repra.ratool.BaseCommand;
import com.sybase.connector.repra.ratool.RTContext;
import com.sybase.connector.repra.ratool.RTResourceManager;
import com.sybase.connector.repra.ratool.UsageException;
import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaException;
import com.sybase.connector.repra.util.RaStatus;
import java.util.Vector;

public class PingCommand
extends BaseCommand {
    private static RTResourceManager _resources = new RTResourceManager(PingCommand.class);

    public String getName() {
        return _resources.getString("ping.Name");
    }

    public String getDescription() {
        return _resources.getString("ping.Desc");
    }

    public String getUsage() {
        return _resources.getString("ping.Usage");
    }

    public void setArgs(String[] args) throws Exception {
        if (args.length == 0) {
            throw new UsageException(this);
        }
    }

    public boolean isHidden() {
        return false;
    }

    public void run() throws Exception {
        if (this._args.size() == 0) {
            _log.error("RaCommand[ERROR]:  " + _resources.getString("wrong.argument"));
            return;
        }
        String connName = (String)this._args.elementAt(0);
        String type = "ALL";
        if (this._args.size() > 1) {
            type = (String)this._args.elementAt(1);
        }
        _log.debug("RaCommand[DEBUG]:  " + _resources.getString("ping.verbose.1") + "'" + connName + "'");
        try {
            RTContext context = (RTContext)this.getBaseRTContext();
            RaClientUtil raClient = context.getRaClient();
            Vector returnObj = raClient.ping(connName, type);
            if (returnObj == null || !(returnObj instanceof Vector)) {
                _log.error("RaCommand[ERROR]:  " + _resources.getString("status.unknown"));
                return;
            }
            Vector raV = returnObj;
            for (int i = 0; i < raV.size(); ++i) {
                RaStatus raS = (RaStatus)raV.elementAt(i);
                if (raS.getCode() == 0) {
                    _log.info("RaCommand[INFO]:  Connection '" + connName + "'" + _resources.getString("ping.status.success"));
                    continue;
                }
                if (raS.getCode() == 2) {
                    _log.warn("RaCommand[WARN]:  " + raS.getMessage());
                    continue;
                }
                if (raS.getCode() != 4) continue;
                _log.error("RaCommand[ERROR]:  " + _resources.getString("ping.status.fail" + raS.getMessage()));
            }
        }
        catch (RaException rae) {
            _log.error("RaCommand[ERROR]:  " + _resources.getString("ping.status.fail") + rae.toString());
        }
    }
}

