/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.ratool.commands;

import com.sybase.connector.repra.ratool.BaseCommand;
import com.sybase.connector.repra.ratool.RTContext;
import com.sybase.connector.repra.ratool.RTResourceManager;
import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaException;
import com.sybase.connector.repra.util.RaStatus;
import java.util.Vector;

public class RefreshAllCommand
extends BaseCommand {
    private static RTResourceManager _resources = new RTResourceManager(RefreshAllCommand.class);

    public String getName() {
        return _resources.getString("refreshall.Name");
    }

    public String getDescription() {
        return _resources.getString("refreshall.Desc");
    }

    public String getUsage() {
        return _resources.getString("refreshall.Usage");
    }

    public boolean isHidden() {
        return false;
    }

    public void run() throws Exception {
        try {
            RTContext context = (RTContext)this.getBaseRTContext();
            RaClientUtil raClient = context.getRaClient();
            Vector returnObj = raClient.refreshConnection();
            if (returnObj == null || !(returnObj instanceof Vector)) {
                _log.error("RaCommand[ERROR]:  " + _resources.getString("status.unknown"));
                return;
            }
            Vector raV = returnObj;
            if (raV.size() == 0) {
                _log.info("RaCommand[INFO]:  " + _resources.getString("refreshall.no.connections"));
                return;
            }
            _log.info(_resources.getString("refreshall.result"));
            _log.info(_resources.getString("refreshall.status"));
            _log.info("---------------------\t------");
            _log.info("");
            for (int i = 0; i < raV.size(); ++i) {
                RaStatus raS = (RaStatus)raV.elementAt(i);
                _log.debug("RaCommand[DEBUG]:  raStatus Object = " + raS.toString());
                if (raS.getCode() == 0) {
                    _log.info(raS.getConnectionName() + "\t\t" + _resources.getString("refreshall.status.success"));
                    continue;
                }
                if (raS.getCode() != 2 && raS.getCode() != 4) continue;
                _log.error(raS.getConnectionName() + "\t\t" + raS.getMessage());
            }
        }
        catch (RaException rae) {
            _log.error("RaCommand[ERROR]:  " + _resources.getString("refreshall.status.fail") + rae.getMessage());
        }
    }
}

