/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.ratool.commands;

import com.sybase.connector.repra.ratool.BaseCommand;
import com.sybase.connector.repra.ratool.RTContext;
import com.sybase.connector.repra.ratool.RTResourceManager;
import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaException;
import com.sybase.connector.repra.util.RaStatus;
import java.util.Enumeration;
import java.util.Properties;

public class StatusCommand
extends BaseCommand {
    private static RTResourceManager _resources = new RTResourceManager(StatusCommand.class);

    public String getName() {
        return _resources.getString("status.Name");
    }

    public String getDescription() {
        return _resources.getString("status.Desc");
    }

    public String getUsage() {
        return _resources.getString("status.Usage");
    }

    public boolean isHidden() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws Exception {
        String connName = null;
        if (this._args.size() > 0) {
            connName = (String)this._args.elementAt(0);
        }
        try {
            RTContext context = (RTContext)this.getBaseRTContext();
            RaClientUtil raClient = context.getRaClient();
            Properties props = new Properties();
            RaStatus returnObj = connName == null ? raClient.getConnectionStatus() : raClient.getConnectionStatus(connName);
            if (returnObj == null || !(returnObj instanceof RaStatus)) {
                _log.error("RaCommand[ERROR]:  " + _resources.getString("status.unknown"));
                return;
            }
            RaStatus raS = returnObj;
            if (raS.getCode() == 0) {
                Object retObj = raS.getReturnObject();
                if (retObj == null) {
                    _log.error("RaCommand[ERROR]:  " + _resources.getString("status.no.returnobject"));
                    return;
                }
                if (retObj instanceof Properties) {
                    Properties retP = (Properties)retObj;
                    if (retP.isEmpty()) {
                        _log.info("RaCommand[INFO]:  " + _resources.getString("no.connections"));
                        return;
                    }
                    _log.info(_resources.getString("status.status"));
                    _log.info("----------------------\t------");
                    _log.info("\n");
                    Enumeration<?> e = retP.propertyNames();
                    while (e.hasMoreElements()) {
                        String propName = (String)e.nextElement();
                        _log.info(propName + "\t\t" + retP.getProperty(propName));
                    }
                    return;
                }
                if (retObj instanceof String) {
                    _log.info(_resources.getString("status.status"));
                    _log.info("----------------------\t------");
                    _log.info(connName + "\t\t" + (String)retObj);
                    return;
                }
                _log.error("RaCommand[ERROR]:  " + _resources.getString("status.invalid.returnobject"));
                return;
            }
            if (raS.getCode() == 2) {
                _log.warn("RaCommand[WARN]:  " + raS.getMessage());
                return;
            }
            if (raS.getCode() != 4) return;
            _log.error("RaCommand[ERROR]:  " + raS.getMessage());
            return;
        }
        catch (RaException rae) {
            _log.error("RaCommand[ERROR]:  " + _resources.getString("status.status.fail") + rae.getMessage());
        }
    }
}

