/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.rep;

import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.rep.DataServer;
import com.sybase.connector.repra.rep.RepAdapterImpl;
import com.sybase.connector.repra.rep.RepEvent;
import com.sybase.connector.repra.rep.RepHolderException;
import com.sybase.connector.repra.rep.RepMetaData;
import com.sybase.connector.repra.rep.ReplicateDB;
import com.sybase.connector.repra.rep.Result;
import com.sybase.connector.repra.rep.TSQLTokenizer;
import com.sybase.jdbc3.tds.SrvDataInputStream;
import com.sybase.jdbc3.tds.SrvSession;
import com.sybase.jdbc3.utils.HexConverts;
import java.io.ByteArrayOutputStream;
import java.util.StringTokenizer;

class DSISession {
    private RaLogger _log = null;
    private RepAdapterImpl _adapterImpl;
    private SrvSession _s;
    private String _info = null;
    private DataServer _server = null;
    private ReplicateDB _db = null;
    private String _statement = null;
    private String _bufferStatement = null;
    private String _combinedMsg = null;
    private boolean _inXAction = false;
    private RepEvent _blobEvent = null;
    private TSQLTokenizer _tokenizer;

    protected DSISession() {
    }

    protected void init(SrvSession s, String info, DataServer server, RaLogger log) {
        this._log = log;
        this._tokenizer = new TSQLTokenizer();
        this._s = s;
        this._info = info;
        this._server = server;
    }

    public void setLogger(RaLogger log) {
        if (this._log == null) {
            this._log = log;
        }
    }

    public void setAdapter(RepAdapterImpl adapterImpl) {
        this._adapterImpl = adapterImpl;
    }

    public Result handleLanguage(String statement) {
        this._log.debug("DSISession.handleLanguage.m1", this.sessionInfo() + "-" + statement);
        this._statement = statement;
        if (this._statement == null || this._statement.startsWith("bogus") || this._statement.trim().length() == 0) {
            return new Result();
        }
        if (this._statement.startsWith("use")) {
            return this.doUse();
        }
        if (this._statement.startsWith("sp_help") || this._statement.startsWith("help")) {
            return this.doHelp();
        }
        if (this._statement.startsWith("sp_serverinfo")) {
            return this.serverInfo();
        }
        if (this._statement.startsWith("set raw_object_serialization on")) {
            return new Result();
        }
        if (this._statement.startsWith("select 'yes'")) {
            Result r = new Result();
            String[] a = new String[]{"name"};
            r._header = a;
            Object[][] o = new Object[][]{{"YES"}};
            r._result = o;
            return r;
        }
        if (this._statement.startsWith("if @@error <> 0 rollback transaction")) {
            return new Result();
        }
        if (this._db != null) {
            return this.replicateOperation();
        }
        this._log.debug("DSISession.handleLanguage.m2");
        Result r = new Result();
        r._event = "Unknown function string mapping or use <db> has not been called for statment: " + this._statement;
        r.setErrorType(3);
        return r;
    }

    Result replicateOperation() {
        Result r = new Result();
        this._combinedMsg = "";
        try {
            if (this._statement.startsWith("commit") || this._statement.startsWith("execute") && this._statement.indexOf("lastcommit") != -1) {
                this._inXAction = false;
                return this.doCommit();
            }
            if (!(this._statement.startsWith("insert") || this._statement.startsWith("exec") || this._statement.startsWith("update") || this._statement.startsWith("delete") || this._statement.startsWith("set identity_insert"))) {
                if (this._statement.startsWith("begin")) {
                    this._inXAction = true;
                    this._db.xAction(0);
                    if (this._statement.indexOf("insert") >= 0) {
                        this._combinedMsg = this._statement;
                        this._statement = this._statement.substring(this._statement.indexOf("insert"), this._statement.length());
                    } else if (this._statement.indexOf("exec") >= 0) {
                        this._combinedMsg = this._statement;
                        this._statement = this._statement.substring(this._statement.indexOf("exec"), this._statement.length());
                    } else if (this._statement.indexOf("update") >= 0) {
                        this._combinedMsg = this._statement;
                        this._statement = this._statement.substring(this._statement.indexOf("update"), this._statement.length());
                    } else if (this._statement.indexOf("delete") >= 0) {
                        this._combinedMsg = this._statement;
                        this._statement = this._statement.substring(this._statement.indexOf("delete"), this._statement.length());
                    } else if (this._statement.indexOf("set identity_insert") >= 0) {
                        this._combinedMsg = this._statement;
                        this._statement = this._statement.substring(this._statement.indexOf("set identity_insert"), this._statement.length());
                    }
                } else if (this._statement.startsWith("rollback")) {
                    this._inXAction = false;
                    this._db.xAction(2);
                } else {
                    this._log.debug("DSISession.replicateOperation.m3", this._statement);
                    r._event = "Unknown or unsupported function string mapping: " + this._statement;
                    r.setErrorType(3);
                }
            }
            if (this._statement.startsWith("insert") || this._statement.startsWith("exec") || this._statement.startsWith("update") || this._statement.startsWith("delete") || this._statement.startsWith("set identity_insert")) {
                if (this._db.operation(this._statement)) {
                    this._log.debug("DSISession.replicateOperation.m1");
                } else {
                    this._log.error("DSISession.replicateOperation.m2");
                }
            }
        }
        catch (Exception ue) {
            r._event = ue instanceof RepHolderException ? ue.getMessage() + ":" + this._statement : ue + " " + this._statement;
            r.setErrorType(2);
            this._log.error("DSISession.replicateOperation.m4", (Throwable)ue);
        }
        return r;
    }

    private Result serverInfo() {
        if (this._statement.indexOf("server_csname") > -1) {
            this._log.debug("DSISession.serverInfo.m1", this._statement);
            Result r = new Result();
            String[] a = new String[]{"name"};
            r._header = a;
            Object[][] o = new Object[][]{{this._server.getCharset()}};
            r._result = o;
            return r;
        }
        if (this._statement.indexOf("server_soname") > -1) {
            this._log.debug("DSISession.serverInfo.m2", this._statement);
            Result r = new Result();
            String[] a = new String[]{"name"};
            r._header = a;
            Object[][] o = new Object[][]{{this._server.getSortOrder()}};
            r._result = o;
            return r;
        }
        this._log.debug("DSISession.serverInfo.m3", this._statement);
        Result r = new Result();
        r._event = "Received sp_serverinfo (rs_get...) of unknown type: ";
        r.setErrorType(3);
        return r;
    }

    private Result doUse() {
        String db = this._statement.substring(4).trim();
        Result r = new Result();
        this._db = this._server.findReplicateDB(db);
        if (this._db == null) {
            String[] args = new String[]{db, this.sessionInfo()};
            try {
                this._db = this._server.loadReplicate(db);
            }
            catch (Exception ume) {
                this._log.error("DSISession.doUse.m1", (Object)this._statement, (Throwable)ume);
            }
            if (!this._db.getExists()) {
                r._event = "Replicate " + db + " not found for server " + this._server.getDSIName();
                r.setErrorType(3);
                this._log.error("DSISession.doUse.m2", r._event);
            }
        }
        return r;
    }

    private Result doCommit() throws Exception {
        if (this._statement.indexOf("get_lastcommit") > -1) {
            this._log.debug("DSISession.doCommit.m1", this._statement);
            return this._db.getCommit();
        }
        if (this._statement.indexOf("update_lastcommit") > -1) {
            this._log.debug("DSISession.doCommit.m2", this._statement);
            Result r = new Result();
            try {
                if (this._statement.indexOf("commit transaction") > -1) {
                    this._db.xAction(1);
                }
                if (!this._adapterImpl.getRequiredGroup()) {
                    this._db.setCommit(this._statement);
                } else if (this._bufferStatement == null) {
                    this._bufferStatement = new String(this._statement);
                }
                r._count = 1;
            }
            catch (Exception me) {
                r._event = me instanceof RepHolderException ? me.getMessage() + " " + this._statement : me + " " + this._statement;
                this._log.error("DSISession.doCommit.m3", (Throwable)me);
                r.setErrorType(2);
            }
            return r;
        }
        if (this._statement.indexOf("commit transaction") > -1) {
            this._log.debug("DSISession.doCommit.m4", this._statement);
            this._db.xAction(1);
            if (this._bufferStatement != null) {
                this._db.setCommit(this._bufferStatement);
                this._bufferStatement = null;
            }
            return new Result();
        }
        Result r = new Result();
        r._event = "Bad syntax for commit command: " + this._statement;
        r.setErrorType(2);
        return r;
    }

    Result doHelp() {
        Result r = new Result();
        String[] a = new String[]{"RS function string", "MARS language mapping"};
        r._header = a;
        String[][] b = new String[][]{{"rs_usedb", "use ?rs_destination_db!sys_raw?"}, {"rs_begin", "begin transaction rs_origin_xact_name!sys_raw"}, {"rs_get_charset", "sp_serverinfo server_csname"}, {"rs_get_sortorder", "sp_serverinfo server_soname"}, {"rs_commit", "execute rs_update_lastcommit <args>;commit transaction"}, {"rs_get_lastcommit", "execute rs_get_lastcommit"}, {"rs_rollback", "rollback transaction"}, {"rs_insert", "TSQL insert"}, {"rs_update", "TSQL update with where on before image primary key(s)"}, {"rs_delete", "TSQL delete with where on before image primary key(s)"}};
        r._result = b;
        return r;
    }

    public String sessionInfo() {
        return this._info;
    }

    public RepEvent handleGetTextPtr(String statement) throws Exception {
        this._log.debug("DSISession.handleGetTextPtr.m1", statement);
        this._blobEvent = new RepEvent(statement);
        this._tokenizer.parse(this._blobEvent);
        RepMetaData rmd = this._db.getRepMetaData();
        rmd.setLogger(this._log);
        int columnType = -1;
        try {
            columnType = rmd.getTableColumnType(this._blobEvent.getName(), this._blobEvent.getColumns().getName(0));
        }
        catch (Exception anyex) {
            columnType = 5;
        }
        this._log.debug("DSISession.handleGetTextPtr.m2", Integer.toString(columnType));
        if (columnType != 4 && columnType != 5 && columnType != 29) {
            Exception ex = new Exception("Select column '" + this._blobEvent.getName() + "." + this._blobEvent.getColumns().getName(0) + "' is of type '" + columnType + "'. Only columns of type 'TEXT', 'IMAGE', or 'UNITEXT' " + "are allowed in a select statement received by RepAdapter.");
            this._log.error("DSISession.handleGetTextPtr.m3", (Object)Integer.toString(columnType), (Throwable)ex);
            throw ex;
        }
        this._blobEvent.setBlobType(columnType);
        this._blobEvent._operation = "update";
        return this._blobEvent;
    }

    public void handleWritetext(String statement) throws Exception {
        try {
            this._log.debug("DSISession.handleWriteText.m1", statement);
            if (this._blobEvent == null) {
                this._log.error("DSISession.handleWriteText.m2", statement);
                throw new Exception("There was no 'select <textptr>' command before the following writetext was received: " + statement);
            }
            StringTokenizer st = new StringTokenizer(statement);
            String str = st.nextToken();
            str = st.nextToken();
            str = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(str, ".");
            String table = st2.nextToken();
            this._s.setSessionData((Object)"Writetext.table", (Object)table);
            String column = st2.nextToken();
            this._s.setSessionData((Object)"Writetext.column", (Object)column);
            str = st.nextToken();
            this._s.setSessionData((Object)"Writetext.textptr", (Object)str);
            str = st.nextToken();
            str = st.nextToken();
            str = st.nextToken();
            this._s.setSessionData((Object)"Writetext.timestamp", (Object)str);
        }
        catch (Exception nsee) {
            this._log.error("DSISession.handleWriteText.m3", (Object)statement, (Throwable)nsee);
            throw new Exception("Unexpected error while parsing the writetext command in DSISession::handleWritetext: " + nsee.getMessage());
        }
    }

    public void handleBulk(SrvDataInputStream blobInputStream) throws Exception {
        this._log.debug("DSISession.handleBulk.m1", this.sessionInfo());
        if (this._blobEvent == null) {
            this._log.debug("DSISession.handleBulk.m2");
            throw new Exception("There was no 'select <textptr>' command before the bulk event was received.");
        }
        try {
            int blobLength = blobInputStream.readInt();
            this._log.debug("DSISession.handleBulk.m3", Integer.toString(blobLength));
            ByteArrayOutputStream baos = new ByteArrayOutputStream(blobLength);
            byte[] buf = new byte[blobLength];
            blobInputStream.read(buf, 0, blobLength);
            baos.write(buf, 0, blobLength);
            this._blobEvent.setBlobValue(baos);
            this._adapterImpl._newStatement = new StringBuffer();
            this._adapterImpl._newStatement.append("update " + this._blobEvent.getName() + " set " + this._blobEvent.getColumns().getName(0) + " = ");
            if (this._blobEvent.getBlobType() == 4) {
                if (baos.size() > 0) {
                    this._adapterImpl._newStatement.append("'" + this.genEscapedString(baos.toString()) + "'");
                    this._adapterImpl._escapedText = null;
                    this._adapterImpl._rawTextCharArray = null;
                } else {
                    this._adapterImpl._newStatement.append("NULL");
                    this._adapterImpl._escapedText = null;
                    this._adapterImpl._rawTextCharArray = null;
                }
            } else if (baos.size() > 0) {
                this._adapterImpl._newStatement.append("0x");
                this._adapterImpl._newStatement.append(HexConverts.hexConvert((byte[])baos.toByteArray()));
            } else {
                this._adapterImpl._newStatement.append("NULL");
            }
            this._adapterImpl._newStatement.append(" " + this._blobEvent._statement.substring(this._blobEvent._statement.indexOf("where")));
            this._blobEvent._statement = this._adapterImpl._newStatement.toString();
            this._adapterImpl._newStatement = null;
            if (!this._db.operation(this._blobEvent)) {
                this._log.error("DSISession.handleBulk.m4");
            }
            this._blobEvent = null;
        }
        catch (Exception e) {
            this._log.error("DSISession.handleBulk.m5", (Throwable)e);
            throw new Exception("Unexpected error processing bulk event in DSISession::handleBulk:" + e.getMessage());
        }
    }

    private String genEscapedString(String rawText) {
        this._adapterImpl._escapedText = new StringBuffer(rawText.length());
        this._adapterImpl._rawTextCharArray = rawText.toCharArray();
        int rawLength = rawText.length();
        char charBoundary = ' ';
        boolean charpolicy = this._log.getCharPolicy();
        if (charpolicy) {
            this._log.debug("DSISession.genEscapedString.m1");
            charBoundary = '\u0000';
        }
        for (int i = 0; i < rawLength; ++i) {
            if (this._adapterImpl._rawTextCharArray[i] == '\'') {
                this._adapterImpl._escapedText.append("''");
                continue;
            }
            if (this._adapterImpl._rawTextCharArray[i] < charBoundary) {
                if (this._adapterImpl._rawTextCharArray[i] == '\u0000') {
                    this._adapterImpl._escapedText.append("\u0000");
                    continue;
                }
                if (this._adapterImpl._rawTextCharArray[i] == '\n') {
                    this._adapterImpl._escapedText.append("\\n");
                    continue;
                }
                if (this._adapterImpl._rawTextCharArray[i] == '\t') {
                    this._adapterImpl._escapedText.append("\\t");
                    continue;
                }
                if (this._adapterImpl._rawTextCharArray[i] == '\r') {
                    this._adapterImpl._escapedText.append("\\r");
                    continue;
                }
                if (this._adapterImpl._rawTextCharArray[i] == '\f') {
                    this._adapterImpl._escapedText.append("\\f");
                    continue;
                }
                if (this._adapterImpl._rawTextCharArray[i] == '\\') {
                    this._adapterImpl._escapedText.append("\\");
                    continue;
                }
                this._adapterImpl._escapedText.append(this._adapterImpl._rawTextCharArray[i]);
                continue;
            }
            this._adapterImpl._escapedText.append(this._adapterImpl._rawTextCharArray[i]);
        }
        return this._adapterImpl._escapedText.toString();
    }
}

