/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.rep;

import com.sybase.connector.repra.rep.RepHolderException;
import java.io.Serializable;
import java.util.StringTokenizer;

class QID
implements Serializable {
    protected Integer _origin;
    protected byte[] _QID = new byte[36];
    protected byte[] _SQID = new byte[36];
    protected String _originTime = null;
    protected static final byte[] ZEROQID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    private QID() {
    }

    private QID(Integer origin, byte[] qid, byte[] sqid, String time) {
        this._origin = origin;
        this._QID = qid;
        this._SQID = sqid;
        this._originTime = time;
    }

    protected static byte[] qidStringToBytes(String s) throws NumberFormatException {
        byte[] qid = new byte[36];
        for (int i = 0; i < qid.length; ++i) {
            qid[i] = (byte)(Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16) & 0xFF);
        }
        return qid;
    }

    protected static String qidBytesToString(byte[] b) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < b.length; ++i) {
            String s = Integer.toHexString(b[i] & 0xFF);
            if (s.length() == 2) {
                sb.append(s);
                continue;
            }
            sb.append("0" + s);
        }
        return sb.toString();
    }

    protected static QID buildQID(String statement) throws Exception {
        Integer origdb = new Integer(1);
        byte[] qid = null;
        byte[] sqid = null;
        String date = null;
        StringTokenizer st = new StringTokenizer(statement);
        while (st.hasMoreTokens()) {
            String ss;
            String s = st.nextToken();
            if (s.equals("@origin")) {
                st.nextToken();
                ss = st.nextToken();
                try {
                    origdb = new Integer(ss.substring(0, ss.length() - 1));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    String[] o = new String[]{"@origin", ss};
                    throw new RepHolderException(null, "REPERR_QIDIdParseError", o);
                }
            }
            if (s.startsWith("@origin_qid")) {
                st.nextToken();
                ss = st.nextToken().substring(2, 74);
                try {
                    qid = QID.qidStringToBytes(ss);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    String[] o = new String[]{"@origin_qid", ss};
                    throw new RepHolderException((Throwable)nfe, "REPERR_QIDIdParseError", o);
                }
            }
            if (s.startsWith("@secondary_qid")) {
                st.nextToken();
                ss = st.nextToken().substring(2, 74);
                try {
                    sqid = QID.qidStringToBytes(ss);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    String[] o = new String[]{"@secondary_qid", ss};
                    throw new RepHolderException((Throwable)nfe, "REPERR_QIDIdParseError", o);
                }
            }
            if (!s.startsWith("@origin_time")) continue;
            st.nextToken();
            date = st.nextToken() + " " + st.nextToken();
        }
        return new QID(origdb, qid, sqid, date);
    }

    protected static QID buildQID(QID qid, int increment) {
        Integer origDb;
        String origTime;
        byte[] srcQid;
        byte[] qidVal = new byte[36];
        if (qid == null) {
            srcQid = ZEROQID;
            origTime = "";
            origDb = new Integer(0);
        } else {
            origDb = qid._origin;
            srcQid = qid._QID;
            origTime = qid._originTime;
        }
        System.arraycopy(srcQid, 0, qidVal, 0, 36);
        byte[] operId = new byte[4];
        for (int i = 0; i < 4; ++i) {
            operId[3 - i] = (byte)((increment & 255 << i * 8) >> i * 8);
        }
        System.arraycopy(operId, 0, qidVal, 30, 4);
        QID newQid = new QID(origDb, qidVal, qidVal, origTime);
        return newQid;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("");
        s.append("\n  Origin database id: " + this._origin);
        s.append("\n  Primary QID: " + QID.qidBytesToString(this._QID));
        s.append("\n  Secondary QID: " + QID.qidBytesToString(this._SQID));
        s.append("\n  Update time: " + this._originTime);
        return super.toString() + "\n" + s.toString();
    }
}

