/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.rep;

import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.rep.RepEvent;
import com.sybase.connector.repra.rep.RepEventIdGenerator;
import com.sybase.connector.repra.rep.RepHolderException;
import com.sybase.connector.repra.rep.RepMetaData;
import com.sybase.connector.repra.rep.RepTable;
import com.sybase.connector.repra.rep.RepTypeException;
import com.sybase.connector.repra.rep.RepraProcessor;
import com.sybase.connector.repra.rep.TSQLTokenizer;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

class RepEventStream {
    private RaLogger _log = null;
    private static final int AVERAGE_TRANSACTION_SIZE = 15;
    private RepMetaData _meta = null;
    private TSQLTokenizer _tokenizer;
    private Vector _listeners = new Vector();
    private Vector _tranListeners = new Vector();
    private Vector _events = null;
    private boolean _requiredGroup = false;
    private boolean _requiresMeta = false;
    private boolean _requiresParse = false;
    private RepEventIdGenerator _eventIdGenerator = null;
    private Hashtable _repSpec = null;
    protected Properties _props = null;

    protected RepEventStream() {
    }

    protected void init(Properties props, RepMetaData meta, RaLogger log) {
        this._props = props;
        this._log = log;
        this._meta = meta;
        if (Boolean.valueOf(this._props.getProperty("RequiredGroup", "false")).booleanValue()) {
            this._requiredGroup = true;
        }
        this._tokenizer = new TSQLTokenizer();
    }

    public void setLogger(RaLogger log) {
        if (this._log == null) {
            this._log = log;
        }
    }

    protected void addListener(RepraProcessor listener) {
        if (this._requiredGroup) {
            this._log.debug("RepEventStream.addListener.m3");
            this._tranListeners.addElement(listener);
        } else {
            this._log.debug("RepEventStream.addListener.m4");
            this._listeners.addElement(listener);
        }
        if (listener.requiresMetaData()) {
            this._log.debug("RepEventStream.addListener.m1");
            this._requiresMeta = true;
            this._requiresParse = true;
        } else if (listener.requiresParse()) {
            this._log.debug("RepEventStream.addListener.m2");
            this._requiresParse = true;
        }
    }

    protected void setEventIdGenerator(RepEventIdGenerator gen) {
        this._eventIdGenerator = gen;
    }

    protected void writeOperation(String statement) throws Exception {
        this.writeOperation(new RepEvent(statement));
    }

    protected void writeOperation(RepEvent re) throws Exception {
        if (this._requiresParse) {
            try {
                this._tokenizer.parse(re);
            }
            catch (Throwable t) {
                this._log.debug("RepEventStream.writeOperation.m1", t);
                throw (Exception)t;
            }
        }
        if (this._requiresMeta) {
            try {
                RepTable t = this._meta.findTable(re._name);
                t.setLogger(this._log);
                re._column.setMetaData(t);
                re._identity = t.hasIdentity();
                re._where.setMetaData(this._meta.findTable(re._name));
                re._dsName = this._meta.getDsName();
                re._dbName = this._meta.getDbName();
                re.setDbId(t.getDbId());
                if (this._eventIdGenerator != null) {
                    re.setCurrentQID(this._eventIdGenerator.nextEventId(t.getDbId()));
                    re.setEventId(this._eventIdGenerator.nextEventId(t.getDbId()));
                } else {
                    re.setCurrentQID("000000000000000000000000000000000000000000000000000000000000000000000000");
                    re.setEventId(null);
                }
                re._metaData = true;
            }
            catch (Exception rjex) {
                this._log.info("RepEventStream.writeOperation.m2", (Throwable)rjex);
                try {
                    this._meta.load();
                    RepTable t = this._meta.findTable(re._name);
                    t.setLogger(this._log);
                    re._column.setMetaData(t);
                    re._identity = t.hasIdentity();
                    re._where.setMetaData(this._meta.findTable(re._name));
                    re._dsName = this._meta.getDsName();
                    re._dbName = this._meta.getDbName();
                    if (this._eventIdGenerator != null) {
                        re.setCurrentQID(this._eventIdGenerator.nextEventId(t.getDbId()));
                        re.setEventId(this._eventIdGenerator.nextEventId(t.getDbId()));
                    } else {
                        re.setCurrentQID("000000000000000000000000000000000000000000000000000000000000000000000000");
                        re.setEventId(null);
                    }
                    re._metaData = true;
                }
                catch (Exception ume2) {
                    re._metaData = false;
                    this._log.debug("RepEventStream.writeOperation.m3", (Throwable)ume2);
                }
            }
        }
        for (int i = 0; i < this._listeners.size(); ++i) {
            RepraProcessor listener = (RepraProcessor)this._listeners.elementAt(i);
            listener.setLogger(this._log);
            this._log.debug("RepEventStream.writeOperation.m4", re.toString());
            try {
                listener.repevent(re);
                continue;
            }
            catch (Throwable t) {
                this._log.debug("RepEventStream.writeOperation.m5", (Object)re.toString(), t);
                if (t instanceof RepTypeException || t instanceof RepHolderException) {
                    RepHolderException rhe = (RepHolderException)t;
                    Exception se = new Exception("Converting a RepHolderException to an Exception");
                    throw se;
                }
                throw new Exception("Rep_Err_EVT_DELIV");
            }
        }
        this.accumulateEvent(re);
    }

    protected void begin() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            RepraProcessor listener = (RepraProcessor)this._listeners.elementAt(i);
            listener.setLogger(this._log);
            if (!listener.requiresXActions()) continue;
            listener.begin();
        }
        if (this._tranListeners.size() > 0) {
            this._log.debug("RepEventStream.begin.m1");
            this.initAccumulation();
        }
    }

    protected void rollback() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            RepraProcessor listener = (RepraProcessor)this._listeners.elementAt(i);
            listener.setLogger(this._log);
            if (!listener.requiresXActions()) continue;
            listener.rollback();
        }
        if (this._tranListeners.size() > 0) {
            this._log.debug("RepEventStream.rollback.m1");
            this.initAccumulation();
        }
    }

    protected void commit(int originDbId) throws Exception {
        for (int i = 0; i < this._listeners.size(); ++i) {
            RepraProcessor listener = (RepraProcessor)this._listeners.elementAt(i);
            listener.setLogger(this._log);
            if (!listener.requiresXActions()) continue;
            listener.commit();
        }
        this._log.debug("RepEventStream.commit.m1");
        this.forwardAccumulation(originDbId);
    }

    private void initAccumulation() {
        this._events = null;
    }

    private void accumulateEvent(RepEvent rep) throws Exception {
        if (this._tranListeners.size() > 0) {
            if (this._events == null) {
                this._events = new Vector(15);
            }
            this._events.addElement(rep);
        }
    }

    private void forwardAccumulation(int originDbId) throws Exception {
        if (this._tranListeners.size() == 0 || this._events == null || this._events.size() == 0) {
            return;
        }
        Object[] reps = new RepEvent[this._events.size()];
        this._events.copyInto(reps);
        this._log.debug("RepEventStream.forwardAccumulation.m1");
        for (int i = 0; i < this._tranListeners.size(); ++i) {
            RepraProcessor listener = (RepraProcessor)this._tranListeners.elementAt(i);
            listener.setLogger(this._log);
            try {
                listener.repGroupEvent((RepEvent[])reps);
                continue;
            }
            catch (Throwable t) {
                this._log.debug("RepEventStream.forwardAccumulation.m2", t);
                if (t instanceof RepTypeException || t instanceof RepHolderException) {
                    RepHolderException rhe = (RepHolderException)t;
                    Exception se = new Exception("RepHolderException to a Exception");
                    throw se;
                }
                if (!(t instanceof Exception)) continue;
                throw (Exception)t;
            }
        }
        this._events = null;
    }

    protected RepMetaData getRepMetaData() {
        return this._meta;
    }
}

