/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.rep;

import com.sybase.connector.repra.ConnectionContainer;
import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.rep.RepAdapterImpl;
import com.sybase.connector.repra.rep.RepHolderException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

class RepMetaConnection
implements Runnable {
    private RaLogger _log = null;
    private static ConnectionContainer _connectionContainer = ConnectionContainer.getInstance();
    protected RepAdapterImpl _adapterImpl = null;
    private static final int FADEOUT = 600;
    private String _connName = null;
    private String _url = null;
    private String _login = null;
    private String _password = null;
    private int _activityCount = 0;
    private Thread _timer = null;
    private Connection _conn = null;
    private boolean _connected = false;
    private Hashtable _stmts = new Hashtable();

    public void initMetaConnection(String connName, String url, String login, String password, RaLogger log) {
        this._connName = connName;
        this._url = url;
        this._login = login;
        this._password = password;
        this._log = log;
    }

    public void setLogger(RaLogger log) {
        if (this._log == null) {
            this._log = log;
        }
    }

    protected synchronized Connection getConnection() {
        return this._conn;
    }

    private void getConnected() throws Exception {
        try {
            Driver driver = (Driver)Class.forName("com.sybase.jdbc3.jdbc.SybDriver").newInstance();
            this._log.debug("RepMetaConnection.getConnected.m1");
            Properties props = new Properties();
            props.put("user", this._login);
            props.put("password", this._password);
            props.put("USE_METADATA", "false");
            this._conn = driver.connect(this._url, props);
            this._connected = true;
            this._log.debug("RepMetaConnection.getConnected.m2", (Object)this._url, this._login);
            this.startTimer();
        }
        catch (Exception ex) {
            this._log.error("REPERR_RepRSSDConnectError", (Object)this._url, (Object)this._login, ex);
            String[] args = new String[]{this._url, this._login};
            throw new RepHolderException((Throwable)ex, "REPERR_RepRSSDConnectError", args);
        }
    }

    synchronized void close() {
        try {
            Enumeration e = this._stmts.elements();
            while (e.hasMoreElements()) {
                ((Statement)e.nextElement()).close();
            }
            this._stmts.clear();
            if (this._conn != null) {
                this._conn.close();
                this._conn = null;
                this._connected = false;
            }
            this.stopTimer();
            this._log.debug("RepMetaConnection.close.m1");
        }
        catch (Exception e) {
            this._log.error("RepMetaConnection.close.m2");
        }
    }

    public synchronized ResultSet execute(Object key, String query) throws Exception {
        this._log.debug("RepMetaConnection.execute.m1", query);
        if (!this._connected) {
            this.getConnected();
        }
        Statement stmt = (Statement)this._stmts.get(key);
        try {
            if (stmt == null) {
                stmt = this._conn.createStatement();
                this._stmts.put(key, stmt);
            }
            this.resetTimer();
            return stmt.executeQuery(query);
        }
        catch (SQLException sqe) {
            this._log.debug("RepMetaConnection.execute.m2", (Object)query, (Throwable)sqe);
            String[] args = new String[]{query};
            throw new RepHolderException((Throwable)sqe, "REPERR_RepRSSDQueryError", args);
        }
        catch (Exception ex) {
            this._log.debug("RepMetaConnection.execute.m2", (Object)query, (Throwable)ex);
            String[] args = new String[]{query};
            throw new RepHolderException((Throwable)ex, "REPERR_RepRSSDNonSQLQueryError", args);
        }
    }

    private void startTimer() {
        this.resetTimer();
        this._timer = new Thread((Runnable)this, "RepMetaConnectionTimer");
        this._timer.start();
    }

    private void stopTimer() {
        if (this._timer != null) {
            this._activityCount = 0;
            this.notifyAll();
            try {
                this._timer.join(1500L);
            }
            catch (InterruptedException ie) {
                this._timer.destroy();
            }
            this._timer = null;
        }
    }

    private synchronized void resetTimer() {
        ++this._activityCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this._activityCount != 0) {
            this._activityCount = 0;
            RepMetaConnection repMetaConnection = this;
            synchronized (repMetaConnection) {
                try {
                    this.wait(600000L);
                }
                catch (InterruptedException ex) {
                    this._log.debug("RepMetaConnection.run.m1", (Throwable)ex);
                }
            }
        }
        this.close();
        this._connected = false;
    }
}

