/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.rep;

import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.rep.DSIInfo;
import com.sybase.connector.repra.rep.QID;
import com.sybase.connector.repra.rep.RepAdapterImpl;
import com.sybase.connector.repra.rep.RepEvent;
import com.sybase.connector.repra.rep.RepEventIdGenerator;
import com.sybase.connector.repra.rep.RepEventStream;
import com.sybase.connector.repra.rep.RepMetaData;
import com.sybase.connector.repra.rep.Result;

class ReplicateDB
implements RepEventIdGenerator {
    private RaLogger _log = null;
    protected RepAdapterImpl _adapterImpl = null;
    static final int BEGIN = 0;
    static final int COMMIT = 1;
    static final int ROLLBACK = 2;
    static String[] _eventLabel = new String[]{"BEGIN", "COMMIT", "ROLLBACK"};
    private int _operCount = 0;
    private String _replicateDBName = null;
    private boolean _sendOnce = true;
    private boolean _requiredGroup = false;
    private DSIInfo _dsi = null;
    private RepEventStream _stream = null;
    private int _originDbId = 0;
    private boolean _exists = true;

    protected ReplicateDB() {
    }

    protected void init(String name, RepEventStream stream, String dsiFile, boolean sendOnce, boolean requiredGroup, RaLogger log) {
        this._log = log;
        this._replicateDBName = name;
        this._stream = stream;
        this._sendOnce = sendOnce;
        this._requiredGroup = requiredGroup;
        try {
            this._dsi = DSIInfo.input(dsiFile);
            this._log.debug("ReplicateDB.ReplicateDB.m1", dsiFile);
        }
        catch (Exception ume) {
            this._log.debug("ReplicateDB.ReplicateDB.m2", (Object)dsiFile, (Throwable)ume);
        }
        this._dsi.setSendOnce(this._sendOnce);
        this._stream.setEventIdGenerator(this);
    }

    public void setLogger(RaLogger log) {
        if (this._log == null) {
            this._log = log;
        }
    }

    protected void setExists(boolean b) {
        this._exists = b;
    }

    boolean getExists() {
        return this._exists;
    }

    protected void xAction(int i) throws Exception {
        this._log.debug("ReplicateDB.xAction.m1", _eventLabel[i]);
        if (i == 0) {
            this._operCount = 0;
        }
        switch (i) {
            case 0: {
                this._stream.begin();
                break;
            }
            case 2: {
                this._stream.rollback();
                break;
            }
            case 1: {
                this._stream.commit(this._originDbId);
                break;
            }
            default: {
                this._log.debug("ReplicateDB.xAction.m2", _eventLabel[i]);
                break;
            }
        }
        this._originDbId = 0;
    }

    protected void setCommit(String statement) throws Exception {
        this._originDbId = this._dsi.setCommit(QID.buildQID(statement));
    }

    Result getCommit() {
        return this._dsi.getCommit();
    }

    protected boolean operation(String statement) throws Exception {
        ++this._operCount;
        if (this._requiredGroup || this._dsi.shouldSend(this._operCount)) {
            this._log.debug("ReplicateDB.operation.m1", statement);
            this._stream.writeOperation(statement);
            this._dsi.incrementOperCount();
            return true;
        }
        this._log.debug("ReplicateDB.operation.m2", statement);
        return false;
    }

    protected boolean operation(RepEvent re) throws Exception {
        ++this._operCount;
        if (this._requiredGroup || this._dsi.shouldSend(this._operCount)) {
            this._log.debug("ReplicateDB.operation.m1", re.getStatement());
            this._stream.writeOperation(re);
            this._dsi.incrementOperCount();
            return true;
        }
        this._log.debug("ReplicateDB.operation.m2", re.getStatement());
        return false;
    }

    public String nextEventId(int dbid) {
        return this._dsi.currentQidString(dbid, this._operCount);
    }

    public String lastCommittedEventId(int dbid) {
        return this._dsi.lastQidString(dbid);
    }

    public RepMetaData getRepMetaData() {
        return this._stream.getRepMetaData();
    }
}

