/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.rep;

import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.rep.RepEvent;
import com.sybase.connector.repra.rep.RepHolderException;
import com.sybase.connector.repra.rep.RepValue;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;

class TSQLTokenizer {
    private RaLogger _log = null;
    private StreamTokenizer _st = null;
    private RepEvent _rse = null;
    Vector _tokenVector = new Vector();
    protected static final String TOKINSERT = "insert";
    protected static final String TOKUPDATE = "update";
    protected static final String TOKDELETE = "delete";
    protected static final String TOKEXEC = "exec";
    protected static final String TOKINSERTIDENT = "set identity_insert";
    protected static final String TOKSELECT = "select";

    protected TSQLTokenizer() {
    }

    public void setLogger(RaLogger log) {
        if (this._log == null) {
            this._log = log;
        }
    }

    protected RepEvent parse(RepEvent rse) throws Exception {
        this._rse = rse;
        if (this._rse._statement.startsWith(TOKINSERTIDENT)) {
            this.init(this._rse._statement.substring(this._rse._statement.indexOf("insert into"), this._rse._statement.lastIndexOf(TOKINSERTIDENT)));
        } else {
            this.init(this._rse._statement);
        }
        this._rse._operation = this.nextToken();
        if (this._rse._operation.equals(TOKINSERT)) {
            this.doInsert();
        } else if (this._rse._operation.equals(TOKUPDATE)) {
            this.doUpdate();
        } else if (this._rse._operation.equals(TOKDELETE)) {
            this.doDelete();
        } else if (this._rse._operation.startsWith(TOKEXEC)) {
            this.doExec();
        } else if (this._rse._operation.startsWith(TOKSELECT)) {
            this.doSelectTextPtr();
        } else {
            String[] args = new String[]{this._rse._statement};
            throw new RepHolderException(null, "REPERR_OperParseError", args);
        }
        return this._rse;
    }

    private void init(String input) {
        StringTokenizer stokenizer = new StringTokenizer(input, "\n\r", true);
        String tokensrc = "";
        int currCell = 0;
        this._tokenVector.add("");
        block2: while (stokenizer.hasMoreTokens()) {
            tokensrc = stokenizer.nextToken();
            String value = "";
            int cnt = 0;
            boolean exceptionCase = false;
            String crlfValue = "";
            if (tokensrc.startsWith("'") || tokensrc.endsWith("'")) {
                exceptionCase = true;
            }
            if (tokensrc.equals("")) {
                tokensrc = "\n";
            }
            if (tokensrc.equals("\n") || tokensrc.equals("\r")) {
                crlfValue = tokensrc;
            }
            if (this._tokenVector.size() > 1) {
                tokensrc = "'" + tokensrc;
            }
            if (stokenizer.hasMoreTokens()) {
                tokensrc = tokensrc + "'";
            }
            this.initTokenizer(tokensrc);
            while (true) {
                block15: {
                    try {
                        value = this.buildToken();
                        if (exceptionCase || !value.equals("")) break block15;
                        value = crlfValue;
                    }
                    catch (Exception ex) {
                        continue block2;
                    }
                }
                if (cnt == 0) {
                    if (currCell == 0) {
                        this._tokenVector.setElementAt(value, 0);
                    } else {
                        String prevToken = (String)this._tokenVector.elementAt(this._tokenVector.size() - 1);
                        if (prevToken.equals(",") || prevToken.equals("(") || prevToken.equals(", ") || prevToken.equals("( ")) {
                            this._tokenVector.add(value);
                        } else {
                            this._tokenVector.setElementAt(prevToken + value, this._tokenVector.size() - 1);
                        }
                    }
                } else {
                    this._tokenVector.add(value);
                }
                ++currCell;
                ++cnt;
            }
        }
    }

    private void initTokenizer(String s) {
        this._st = new StreamTokenizer(new SlashEscapeReader(s));
        this._st.resetSyntax();
        this._st.eolIsSignificant(true);
        this._st.wordChars(97, 122);
        this._st.wordChars(64, 90);
        this._st.wordChars(160, 255);
        this._st.whitespaceChars(0, 32);
        this._st.quoteChar(39);
        this._st.ordinaryChar(9);
        this._st.wordChars(48, 57);
        this._st.wordChars(45, 47);
        this._st.wordChars(43, 43);
        this._st.wordChars(95, 95);
        this._st.wordChars(46, 46);
        this._st.wordChars(33, 38);
    }

    private void doInsert() throws Exception {
        this._rse._name = this.nextToken();
        if (this._rse._name.equals("into")) {
            this._rse._name = this.nextToken();
        }
        this.loadValue(this._rse._column, 1);
        this.nextToken();
        this.loadValue(this._rse._column, 2);
    }

    private void doUpdate() throws Exception {
        this._rse._name = this.nextToken();
        String s = this.nextToken();
        s = this.nextToken();
        do {
            this.nextToken();
            this._rse._column.addContent(s, (Object)this.nextToken(), 3);
            s = this.nextToken();
            if (!s.equals(",")) continue;
            s = this.nextToken();
        } while (!s.equals("where"));
        if (!s.equals("where")) {
            String[] args = new String[]{TOKUPDATE};
            throw new RepHolderException(null, "REPERR_WhereParseError", args);
        }
        this.doWhere();
    }

    private void doDelete() throws Exception {
        this._rse._name = this.nextToken();
        if (this._rse._name.equals("from")) {
            this._rse._name = this.nextToken();
        }
        if (!this.nextToken().equals("where")) {
            String[] args = new String[]{TOKDELETE};
            throw new RepHolderException(null, "REPERR_WhereParseError", args);
        }
        this.doWhere();
    }

    private void doSelectTextPtr() throws Exception {
        this._rse._column.addContent(this.nextToken(), null, 3);
        if (!this.nextToken().equals("from")) {
            String[] args = new String[]{"select(from)"};
            throw new RepHolderException(null, "REPERR_UnexpectedParseError", args);
        }
        this._rse._name = this.nextToken();
        if (!this.nextToken().equals("where")) {
            String[] args = new String[]{"select(where)"};
            throw new RepHolderException(null, "REPERR_WhereParseError", args);
        }
        this.doWhere();
    }

    private void doWhere() throws Exception {
        String s = this.nextToken();
        while (true) {
            this.nextToken();
            this._rse._where.addContent(s, (Object)this.nextToken(), 3);
            try {
                s = this.nextToken();
            }
            catch (Exception me) {
                break;
            }
            if (!s.equals("and")) continue;
            s = this.nextToken();
        }
    }

    private void doExec() throws Exception {
        String s = null;
        this._rse._name = this.nextToken();
        try {
            s = this.nextToken();
        }
        catch (Exception me) {
            return;
        }
        while (true) {
            this.nextToken();
            this._rse._column.addContent(s.substring(1), (Object)this.nextToken(), 3);
            try {
                s = this.nextToken();
            }
            catch (Exception me) {
                return;
            }
            if (!s.equals(",")) continue;
            s = this.nextToken();
        }
    }

    private void loadValue(RepValue v, int vType) throws Exception {
        int i = 0;
        String s = null;
        s = this.nextToken();
        do {
            s = this.nextToken();
            v.addContent(i, (Object)s, vType);
            ++i;
        } while (!(s = this.nextToken()).equals(")"));
    }

    private String nextToken() throws Exception {
        return (String)this._tokenVector.remove(0);
    }

    private int loadToken() throws Exception {
        int i = 0;
        try {
            i = this._st.nextToken();
        }
        catch (Exception e) {
            String[] args = new String[]{e.toString(), this._st.toString()};
            throw new RepHolderException(null, "REPERR_UnexpectedParseError", args);
        }
        return i;
    }

    private String buildToken() throws Exception {
        int i = this.loadToken();
        switch (i) {
            case -3: {
                return this._st.sval;
            }
            case 39: {
                String literal = this._st.sval;
                i = this.loadToken();
                while (i == 39) {
                    literal = literal + "'" + this._st.sval;
                    i = this.loadToken();
                }
                this._st.pushBack();
                return literal;
            }
            case -2: {
                String[] args = new String[]{this._st.toString()};
                throw new RepHolderException(null, "REPERR_NumericalParseError", args);
            }
            case -1: 
            case 10: {
                String[] args = new String[]{this._st.toString(), Integer.toString(i)};
                throw new RepHolderException(null, "REPERR_UnexpectedEndOfParse", args);
            }
        }
        return new Character((char)i).toString();
    }

    class SlashEscapeReader
    extends StringReader {
        private int _lastChar;

        public SlashEscapeReader(String s) {
            super(s);
            this._lastChar = 0;
        }

        public int read() throws IOException {
            if (this._lastChar == 92) {
                this._lastChar = 0;
                return 92;
            }
            this._lastChar = super.read();
            return this._lastChar;
        }

        public int read(char[] c) throws IOException {
            return this.read(c, 0, c.length);
        }

        public int read(char[] c, int off, int len) throws IOException {
            int i = 0;
            for (i = off; i < len + off; ++i) {
                c[i] = (char)this.read();
                if (c[i] != '\uffffffff') continue;
                --i;
            }
            return i - off > 0 ? i - off : -1;
        }
    }
}

