/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.servlet;

import com.sybase.connector.repra.license.RepraSySamClient;
import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.util.RaStatus;
import com.sybase.connector.repra.util.RepraCipherUtil2;
import com.sybase.connector.repra.util.RepraControlUtil;
import com.sybase.connector.repra.util.RepraPropertyUtil;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class RepraControlServlet
extends HttpServlet {
    private static RaLogger _log = null;
    private Properties _enteredConfig = new Properties();
    private RepraControlUtil _controlUtil = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        _log = new RaLogger(0);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html");
        ObjectOutputStream oostream = null;
        if (this._controlUtil == null) {
            this._controlUtil = new RepraControlUtil();
        }
        RaStatus raStatus = null;
        Vector raStatusVector = null;
        boolean validLogin = this.validateLogin(request);
        try {
            oostream = new ObjectOutputStream((OutputStream)response.getOutputStream());
            if (!validLogin) {
                try {
                    Object[] logininfo = new String[]{request.getParameter("loginuser"), request.getParameter("loginpass")};
                    _log.error("RepraControlServlet.doPost.m0", logininfo);
                    raStatus = new RaStatus(4, "");
                    raStatus.setCode(4);
                    raStatus.setMessage(_log.getResourceBundle().getString("RepraControlServlet.doPost.ms1"));
                    response.setHeader("ReturnCode", Integer.toString(raStatus.getCode()));
                    response.setHeader("ReturnString", raStatus.getMessage());
                    oostream.writeObject(raStatus);
                    oostream.flush();
                    oostream.close();
                    return;
                }
                catch (Exception loginEx) {
                    throw new ServletException(loginEx.getMessage());
                }
            }
            this._enteredConfig = null;
            ObjectInputStream instream = new ObjectInputStream((InputStream)request.getInputStream());
            Object inobj = instream.readObject();
            if (inobj != null && inobj instanceof Properties) {
                this._enteredConfig = (Properties)inobj;
                _log.debug("RepraControlServlet.doPost.m2", RepraPropertyUtil.encProperties(this._enteredConfig).toString());
            }
        }
        catch (StreamCorruptedException eofex) {
        }
        catch (EOFException eofex) {
        }
        catch (Exception ex) {
            _log.error("RepraControlServlet.doPost.m3", (Throwable)ex);
        }
        try {
            String command = request.getParameter("command");
            String connName = request.getParameter("connName");
            String newConnName = request.getParameter("newConnName");
            String propName = request.getParameter("propName");
            String propValue = request.getParameter("propValue");
            String override = request.getParameter("override");
            String intype = request.getParameter("InboundType");
            String outtype = request.getParameter("OutboundType");
            String source = request.getParameter("Source");
            _log.debug("RepraControlServlet.doPost.m4", "(" + command + ":" + connName + ":" + newConnName + ":" + propName + ":" + propValue + ":" + override + ")");
            if (command == null || command.equals("")) {
                command = "-1";
            }
            int cmdInt = Integer.parseInt(command);
            raStatus = new RaStatus(cmdInt, "");
            raStatus.setCode(0);
            if (!RepraSySamClient.getRepraLicense()) {
                raStatus.setCode(4);
                raStatus.setMessage(_log.getResourceBundle().getString("RepraControlServlet.doPost.ms6"));
                _log.info("RepraControlServlet.doPost.m6");
            } else {
                switch (cmdInt) {
                    case 1: {
                        raStatus = this._controlUtil.startConnection(connName);
                        break;
                    }
                    case 2: {
                        raStatusVector = this._controlUtil.startConnection();
                        break;
                    }
                    case 3: {
                        raStatus = this._controlUtil.stopConnection(connName);
                        break;
                    }
                    case 4: {
                        raStatusVector = this._controlUtil.stopConnection();
                        break;
                    }
                    case 5: {
                        raStatus = this._controlUtil.refreshConnection(connName);
                        break;
                    }
                    case 6: {
                        raStatusVector = this._controlUtil.refreshConnection();
                        break;
                    }
                    case 7: {
                        boolean overrideFlag = false;
                        if (override != null && override.equalsIgnoreCase("true")) {
                            overrideFlag = true;
                        }
                        raStatus = this._controlUtil.createConnection(connName, this._enteredConfig, overrideFlag);
                        break;
                    }
                    case 8: {
                        raStatus = this._controlUtil.updateConnection(connName, this._enteredConfig);
                        break;
                    }
                    case 11: {
                        raStatus = this._controlUtil.renameConnection(connName, newConnName);
                        break;
                    }
                    case 12: {
                        raStatus = this._controlUtil.copyConnection(connName, newConnName);
                        break;
                    }
                    case 9: {
                        raStatus = this._controlUtil.deleteConnection(connName);
                        break;
                    }
                    case 10: {
                        raStatusVector = this._controlUtil.deleteConnection();
                        break;
                    }
                    case 13: {
                        if (this._enteredConfig != null) {
                            raStatus = this._controlUtil.validateConnection(connName, this._enteredConfig);
                            break;
                        }
                        raStatus = this._controlUtil.validateConnection(connName);
                        break;
                    }
                    case 14: {
                        raStatus = this._controlUtil.getConnections();
                        break;
                    }
                    case 15: {
                        raStatus = this._controlUtil.getConnectionStatus(connName);
                        break;
                    }
                    case 16: {
                        raStatus = this._controlUtil.getConnectionStatus();
                        break;
                    }
                    case 17: {
                        raStatus = this._controlUtil.getLogInfo(connName);
                        break;
                    }
                    case 18: {
                        raStatus = this._controlUtil.getConnectionProps(connName);
                        break;
                    }
                    case 19: {
                        raStatus = this._controlUtil.getConnectionPropValue(connName, propName);
                        break;
                    }
                    case 20: {
                        raStatus = this._controlUtil.setConnectionPropValue(connName, propName, propValue);
                        break;
                    }
                    case 21: {
                        raStatus = this._controlUtil.getGeneralParams(this._enteredConfig);
                        break;
                    }
                    case 22: {
                        raStatus = this._controlUtil.getInboundParams(this._enteredConfig);
                        break;
                    }
                    case 23: {
                        raStatus = this._controlUtil.getOutboundParams(this._enteredConfig);
                        break;
                    }
                    case 24: {
                        raStatus = this._controlUtil.getPluginParams(this._enteredConfig);
                        break;
                    }
                    case 25: {
                        if (outtype == null || outtype.equals("")) {
                            raStatus = this._controlUtil.getInboundTypes();
                            break;
                        }
                        raStatus = this._controlUtil.getInboundTypes(outtype);
                        break;
                    }
                    case 26: {
                        if (intype == null || intype.equals("")) {
                            raStatus = this._controlUtil.getOutboundTypes();
                            break;
                        }
                        raStatus = this._controlUtil.getOutboundTypes(intype);
                        break;
                    }
                    case 29: {
                        raStatusVector = this._controlUtil.ping(connName, source, this._enteredConfig);
                        break;
                    }
                    default: {
                        raStatus.setCode(4);
                        raStatus.setMessage(_log.getResourceBundle().getString("RepraControlServlet.doPost.ms5"));
                    }
                }
            }
            if (raStatusVector != null) {
                response.setHeader("ReturnCode", Integer.toString(0));
                response.setHeader("ReturnString", "Check the Vector of RaStatus at RaStatus.getReturnObject())");
                oostream.writeObject(raStatusVector);
            } else {
                response.setHeader("ReturnCode", Integer.toString(raStatus.getCode()));
                response.setHeader("ReturnString", raStatus.getMessage());
                oostream.writeObject(raStatus);
            }
            oostream.flush();
            oostream.close();
        }
        catch (Throwable raex) {
            response.setHeader("ReturnCode", Integer.toString(4));
            response.setHeader("ReturnString", raex.toString());
            oostream.close();
            _log.error("RepraControlServlet.doPost.e1", (Object)raex.toString(), raex);
        }
    }

    private boolean validateLogin(HttpServletRequest request) {
        boolean validLogin = false;
        try {
            Enumeration enums = request.getParameterNames();
            String name = null;
            String value = null;
            while (enums.hasMoreElements()) {
                name = (String)enums.nextElement();
                value = request.getParameter(name);
            }
            HttpSession httpSession = request.getSession(true);
            String loginuser = (String)httpSession.getAttribute("loginuser");
            String encloginpass = (String)httpSession.getAttribute("loginpass");
            String loginpass = null;
            if (encloginpass != null) {
                loginpass = RepraCipherUtil2.decrypt_ascii_pwd(encloginpass);
            }
            String[] userPass = this._controlUtil.getUserPass();
            if (loginuser != null && loginuser.equals(userPass[0])) {
                if (loginpass != null && loginpass.equals(userPass[1])) {
                    validLogin = true;
                } else if (loginpass == null && userPass[1].equals("")) {
                    validLogin = true;
                }
            }
            if (!validLogin) {
                loginuser = request.getParameter("loginuser");
                encloginpass = request.getParameter("loginpass");
                if (encloginpass != null) {
                    loginpass = RepraCipherUtil2.decrypt_ascii_pwd(encloginpass);
                }
                if (loginuser != null && loginuser.equals(userPass[0])) {
                    if (loginpass != null && loginpass.equals(userPass[1])) {
                        validLogin = true;
                    } else if (loginpass == null && userPass[1].equals("")) {
                        validLogin = true;
                    }
                }
            }
            return validLogin;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

