/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.tibrv;

import com.sybase.connector.repra.ConnectionContainer;
import com.sybase.connector.repra.RepraClient;
import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.tibrv.MsgPipeLine;
import com.sybase.connector.repra.tibrv.TibAEAdapterImpl;
import com.tibco.sdk.MApp;
import com.tibco.sdk.MAppProperties;
import com.tibco.sdk.events.MDataEvent;
import com.tibco.sdk.events.MEvent;
import com.tibco.sdk.events.MEventListener;
import com.tibco.sdk.events.MExceptionEvent;
import com.tibco.tibrv.TibrvMsg;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.StringTokenizer;

public class TIBAECMClient
implements RepraClient,
MEventListener {
    private RaLogger _log = null;
    private Properties _cProps = null;
    private static final String DATA_FIELD = "RepEevent";
    MAppProperties _mProps;
    TibAEAdapterImpl _mApp = null;
    MsgPipeLine _pipeLine = new MsgPipeLine();
    boolean _senderStatus = true;
    Properties _customerProps = new Properties();
    private TibrvMsg _rvMessage;
    private int _protocolInt = 2;
    private static ConnectionContainer _connectionContainer = null;

    public void initAECMClient(Properties cProps, RaLogger log) {
        this._cProps = cProps;
        this._log = log;
        String protocol = this._cProps.getProperty("TIBType", "RVCM");
        this._protocolInt = protocol.equalsIgnoreCase("AECM") ? 2 : 1;
        _connectionContainer = ConnectionContainer.getInstance();
    }

    public void setLogger(RaLogger log) {
        if (this._log == null) {
            this._log = log;
        }
    }

    public void configureClient() throws Exception {
        try {
            String propsFile = this._cProps.getProperty("AppConfig", "");
            FileInputStream fin = null;
            fin = !propsFile.equals("") ? new FileInputStream(propsFile) : new FileInputStream("../repra/conf/ae.props");
            this._customerProps.load(fin);
            this._customerProps.setProperty("MsgGenerator", this._cProps.getProperty("MsgGenerator", ""));
            String[] argArray = null;
            String argLine = this._customerProps.getProperty("command_args", "");
            if (argLine != null && !argLine.equals("")) {
                StringTokenizer sTokenizer = new StringTokenizer(argLine);
                argArray = new String[sTokenizer.countTokens()];
                int ido = 0;
                while (sTokenizer.hasMoreTokens()) {
                    argArray[ido] = sTokenizer.nextToken();
                    ++ido;
                }
            }
            String appName = this._customerProps.getProperty("application_name", "");
            String appVers = this._customerProps.getProperty("application_version", "1.0");
            String appInfo = this._customerProps.getProperty("application_info", "");
            String confURL = this._customerProps.getProperty("config_URL", "");
            String repoURL = this._customerProps.getProperty("remote_repository", "");
            this._mProps = new MAppProperties(appName, appVers, appInfo, confURL, repoURL, argArray);
            this._mApp = new TibAEAdapterImpl(this, this._pipeLine, this._mProps, this._customerProps, this._protocolInt, true);
            Thread sendPost = new Thread(new AESenderPost(this._mApp, this));
            _connectionContainer.setThreadVector(this._cProps.getProperty("ConnectionName"), sendPost);
            sendPost.start();
            this._log.debug("TIBAECMClient.configureClient.m2", this._customerProps.toString());
        }
        catch (Exception ex) {
            this._log.error("TIBAECMClient.configureClient.e1", (Object)this._customerProps.toString(), (Throwable)ex);
            throw ex;
        }
    }

    public boolean sendEvent(Object repMessage) throws Exception {
        try {
            String utfMsg = "";
            if (repMessage instanceof ByteArrayOutputStream) {
                byte[] tmp = ((ByteArrayOutputStream)repMessage).toByteArray();
                utfMsg = new String(tmp, "UTF-8");
            } else if (repMessage instanceof String) {
                utfMsg = (String)repMessage;
            }
            boolean validate = true;
            if (this._mApp == null) {
                this._mApp = new TibAEAdapterImpl(this, this._pipeLine, this._mProps, this._customerProps, this._protocolInt, validate);
                Thread sendPost = new Thread(new AESenderPost(this._mApp, this));
                _connectionContainer.setThreadVector(this._cProps.getProperty("ConnectionName"), sendPost);
                sendPost.start();
            }
            this._pipeLine.put(utfMsg);
            while (!this._pipeLine.isEmpty()) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception ex) {}
            }
            if (!this._senderStatus) {
                throw new Exception(this._log.getResourceBundle().getString("TIBAECMClient.sendEvent.e2"));
            }
            this._log.debug("TIBAECMClient.sendEvent.m1", utfMsg);
            return true;
        }
        catch (Exception ex) {
            this._log.error("TIBAECMClient.sendEvent.e1", (Throwable)ex);
            throw ex;
        }
    }

    public boolean isReady() {
        return true;
    }

    public void close() {
    }

    public void setSenderStatus(boolean status) {
        this._senderStatus = status;
    }

    public void onEvent(MEvent event) {
        try {
            if (event instanceof MExceptionEvent) {
                ((MExceptionEvent)event).confirm();
            } else if (event instanceof MDataEvent) {
                ((MDataEvent)event).confirm();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class AESenderPost
    implements Runnable {
        MApp _sendMApp;
        TIBAECMClient _parent = null;

        AESenderPost(MApp mApp, TIBAECMClient parent) {
            this._sendMApp = mApp;
            this._parent = parent;
        }

        public void run() {
            try {
                this._sendMApp.start();
            }
            catch (Exception ex) {
                this._parent.setSenderStatus(false);
            }
        }
    }
}

