/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.tibrv;

import com.sybase.connector.repra.ConnectionContainer;
import com.sybase.connector.repra.RepraAdapter;
import com.sybase.connector.repra.jdbc.JDBCClient;
import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.tibrv.TIBRVBase;
import com.sybase.connector.repra.transform.ErrorGenerator;
import com.sybase.connector.repra.transform.EventFormatter;
import com.sybase.connector.repra.transform.EventFormatterFactory;
import com.tibco.tibrv.Tibrv;
import com.tibco.tibrv.TibrvListener;
import com.tibco.tibrv.TibrvMsg;
import com.tibco.tibrv.TibrvMsgCallback;
import com.tibco.tibrv.TibrvRvdTransport;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class TIBRVAdapterImpl
extends TIBRVBase
implements TibrvMsgCallback,
RepraAdapter {
    protected Vector _rvListeners = new Vector();
    public static ConnectionContainer _connectionContainer = null;
    protected String _controlCmd = "";
    protected JDBCClient _jdbcClient = null;
    protected boolean _shutdown = false;
    protected TibrvListener _callbackListener;
    protected String _messageId = "";
    protected String _errorDest;

    protected TIBRVAdapterImpl() {
    }

    public TIBRVAdapterImpl(Properties cProps) {
        this.initTIBRVAdapter(cProps);
    }

    protected void initTIBRVAdapter(Properties cProps) {
        this._cProps = cProps;
        try {
            this._log = new RaLogger(this._cProps.getProperty("ConnectionName"), 0, this._cProps.getProperty("LogLevel", "INFO"));
            this.initRV(this._cProps, this._log);
            _connectionContainer = ConnectionContainer.getInstance();
            this._errorDest = this._cProps.getProperty("Status.Destination", "StatusQueue");
        }
        catch (Exception anyex) {
            this._log.error("TIBRVAdapterImpl.initTIBRVAdapter.e1", (Object)this._service, (Object)this._network, (Object)this._daemon, (Object)this._subject, anyex);
        }
    }

    public void configureJDBCClient() throws Exception {
        this._jdbcClient = new JDBCClient(this._cProps, this._log);
        this._jdbcClient.configureClient();
    }

    public void configureRVReceiver() throws Exception {
        Object[] info = new String[]{this._service, this._network, this._daemon};
        try {
            Tibrv.open((int)2);
            this._rvTransport = new TibrvRvdTransport(this._service, this._network, this._daemon);
            StringTokenizer stokenizer = new StringTokenizer(this._subject, ",");
            String subject = "";
            while (stokenizer.hasMoreTokens()) {
                subject = stokenizer.nextToken().trim();
                this._rvListeners.add(new TibrvListener(Tibrv.defaultQueue(), (TibrvMsgCallback)this, this._rvTransport, subject, null));
            }
            this._log.debug("TIBRVAdapterImpl.configureRVReceiver.m1", info);
        }
        catch (Exception ex) {
            this._log.error("TIBRVAdapterImpl.configureRVReceiver.m2", info, (Throwable)ex);
            throw ex;
        }
    }

    public void run() {
        try {
            this.configureRVReceiver();
        }
        catch (Throwable ex) {
            _connectionContainer.setControl(this.getConnectionName(), "STOP");
            this.close();
            return;
        }
        try {
            this.configureJDBCClient();
            this._log.info("TIBRVAdapterImpl.configureJDBCClient.m1", (Object)this._cProps.getProperty("DATABASE_URL"), this._cProps.getProperty("DATABASE_Username"));
        }
        catch (Throwable ex) {
            this._log.error("TIBRVAdapterImpl.configureJDBCClient.e1", (Object)this._cProps.getProperty("DATABASE_URL"), (Object)this._cProps.getProperty("DATABASE_Username"), ex);
            this.handleException(ex.toString());
            _connectionContainer.setControl(this.getConnectionName(), "STOP");
            this.close();
            return;
        }
        _connectionContainer.setControl(this.getConnectionName(), "RUNNING");
        this._log.debug("TIBRVAdapterImpl.run.m1");
        block8: while (true) {
            try {
                while (true) {
                    this._controlCmd = _connectionContainer.getControl(this.getConnectionName());
                    Tibrv.defaultQueue().dispatch();
                    if (this._controlCmd.equals("") || this._controlCmd.equals("STOP")) break block8;
                    try {
                        Thread.sleep(3000L);
                        continue block8;
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                // empty catch block
                break;
            }
        }
        this.close();
    }

    public void close() {
        this._shutdown = true;
        this._log.debug("TIBRVAdapterImpl.close.m1", this.getConnectionName());
        this.cleanup();
        super.close();
        _connectionContainer.setControl(this.getConnectionName(), "STOP");
    }

    public void cleanup() {
        this._log.debug("Clenup at TIBRVAdapterImpl");
        try {
            if (this._jdbcClient != null) {
                this._jdbcClient.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            TibrvListener listener = null;
            if (this._rvListeners.size() > 0) {
                for (int ido = 0; ido < this._rvListeners.size(); ++ido) {
                    listener = (TibrvListener)this._rvListeners.elementAt(ido);
                    if (listener == null) continue;
                    this._log.debug("Destroy the TIBRV listener at TIBRVAdapterImpl.");
                    listener.destroy();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onMsg(TibrvListener listener, TibrvMsg message) {
        this.onMsgImpl(listener, message);
    }

    protected synchronized void onMsgImpl(TibrvListener listener, TibrvMsg message) {
        try {
            boolean status = true;
            String msg = (String)message.get("DATABASEEvent");
            if (msg == null) {
                msg = (String)message.get("RepEvent");
            }
            if (msg.toLowerCase().startsWith("select")) {
                this._messageId = msg;
                this.handleException("WARNING");
                this._log.warn("TIBRVAdapterImpl.onMsgImpl.m1", message.toString());
            } else {
                try {
                    if (!msg.toLowerCase().startsWith("<")) {
                        this._messageId = msg;
                        status = this._jdbcClient.sendEvent(msg);
                    } else {
                        EventFormatter formatter = EventFormatterFactory.getFormatter(this._jdbcClient.getDatabaseType());
                        List stmts = formatter.format(msg);
                        this._messageId = formatter.getEventId(msg);
                        status = this._jdbcClient.sendEvent(stmts);
                    }
                    this._log.debug("TIBRVAdapterImpl.onMsgImpl.m2", message.toString());
                }
                catch (Exception sendEx) {
                    this._callbackListener = listener;
                    if (message.getReplySubject() != null && !message.getReplySubject().equals("")) {
                        this._errorDest = message.getReplySubject();
                    }
                    this.handleException(sendEx.toString());
                    this._log.error("TIBRVAdapterImpl.onMsgImpl.e1", (Throwable)sendEx);
                }
            }
        }
        catch (Exception ex) {
            this.handleException(ex.toString());
            this._log.error("TIBRVAdapterImpl.onMsgImpl.m4", (Object)"Result : false", (Throwable)ex);
        }
    }

    protected void handleException(String errMsg) {
        try {
            ErrorGenerator errorGen = new ErrorGenerator();
            String uri = this._cProps.getProperty("DTD_URL");
            errorGen.setLogger(this._log);
            errorGen.setXsdUrl(uri);
            String msg = errorGen.genErrorMessage(this._messageId, errMsg, "ERROR");
            TibrvMsg replyMsg = new TibrvMsg();
            replyMsg.setSendSubject(this._errorDest);
            replyMsg.update("DATABASEEventStatus", (Object)msg);
            this._callbackListener.getTransport().send(replyMsg);
            this._log.debug("TIBRVAdapterImpl.handleException.m1");
        }
        catch (Throwable tex) {
            this._log.error("TIBRVAdapterImpl.handleException.e1", tex);
        }
    }

    public String getConnectionName() {
        return this._cProps.getProperty("ConnectionName");
    }
}

