/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.tibrv;

import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.tibrv.TIBRVClient;
import com.sybase.connector.repra.util.RepraPropertyUtil;
import com.tibco.tibrv.Tibrv;
import com.tibco.tibrv.TibrvCmMsg;
import com.tibco.tibrv.TibrvCmTransport;
import com.tibco.tibrv.TibrvDispatchable;
import com.tibco.tibrv.TibrvDispatcher;
import com.tibco.tibrv.TibrvListener;
import com.tibco.tibrv.TibrvMsg;
import com.tibco.tibrv.TibrvMsgCallback;
import com.tibco.tibrv.TibrvRvdTransport;
import com.tibco.tibrv.TibrvTransport;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.StringTokenizer;

public class TIBRVCMClient
extends TIBRVClient
implements TibrvMsgCallback {
    private String _cmName;
    private long _lastSeqNo = 0L;
    private Object _lockSeqNo = new Object();
    private double _cmDuration = 0.0;
    private TibrvRvdTransport _rvdTransport;
    private TibrvCmTransport _cmTransport;
    private TibrvListener _confirmListener;
    private TibrvDispatcher _dispatcher;

    public void initRVCMClient(Properties cProps, RaLogger log) {
        this.initRV(cProps, log);
        this._cmName = this._cProps.getProperty("RV_CMName", "RepaCM");
        String durationString = this._cProps.getProperty("RV_CMDuration", "0");
        if (durationString == null || durationString.startsWith("-") || durationString.equals("")) {
            durationString = "0";
        }
        this._cmDuration = Double.parseDouble(durationString);
    }

    public void configureClient() throws Exception {
        this._log.debug("TIBRVCMClient.configureClient.m1");
        try {
            this._rvdTransport = new TibrvRvdTransport(this._service, this._network, this._daemon);
            File ledgerDir = new File(RepraPropertyUtil.getRepraDir() + "cmledgers");
            if (!ledgerDir.exists()) {
                ledgerDir.mkdir();
            }
            String ledgerPath = RepraPropertyUtil.getRepraDir() + File.separator + "cmledgers" + File.separator + this._cProps.getProperty("ConnectionName") + "_" + this._cmName + "_ledger.send";
            File fptr = new File(RepraPropertyUtil.getRepraDir() + File.separator + "cmledgers");
            if (!fptr.exists()) {
                fptr.mkdir();
            }
            this._cmTransport = new TibrvCmTransport(this._rvdTransport, this._cmName, true, ledgerPath, true, null);
            this._cmTransport.setDefaultTimeLimit(this._cmDuration);
            this._cmTransport.allowListener(this._cmName);
            StringTokenizer stokenizer = new StringTokenizer(this._subject, ",");
            String subjToken = "";
            String preRegCmName = "";
            String preRegCmSubject = "";
            while (stokenizer.hasMoreTokens()) {
                subjToken = stokenizer.nextToken().trim();
                if (subjToken.indexOf(":") > 0) {
                    preRegCmName = subjToken.substring(0, subjToken.indexOf(":"));
                    preRegCmSubject = subjToken.substring(subjToken.indexOf(":") + 1, subjToken.length());
                    this._cmTransport.allowListener(preRegCmName);
                    this._cmTransport.addListener(preRegCmName, preRegCmSubject);
                    if (this._registeredSubjects.contains(preRegCmSubject)) continue;
                    this._registeredSubjects.add(preRegCmSubject);
                    continue;
                }
                this._cmTransport.addListener(this._cmName, subjToken);
                if (this._registeredSubjects.contains(subjToken)) continue;
                this._registeredSubjects.add(subjToken);
            }
            this._rvTransport = this._cmTransport;
            this._confirmListener = new TibrvListener(Tibrv.defaultQueue(), (TibrvMsgCallback)this, (TibrvTransport)this._rvdTransport, "_RV.INFO.RVCM.DELIVERY.CONFIRM.>", null);
            this._dispatcher = new TibrvDispatcher((TibrvDispatchable)Tibrv.defaultQueue());
            this._rvMessage = new TibrvMsg();
            this._log.debug("TIBRVCMClient.configureClient.m2", (Object)this._service, (Object)this._network, this._daemon);
        }
        catch (Exception ex) {
            this._log.error("TIBRVCMClient.configureClient.e1", (Object)this._service, (Object)this._network, (Object)this._daemon, ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendEvent(Object repMessage) throws Exception {
        try {
            String sendSubject = "";
            String utfMsg = "";
            if (repMessage instanceof ByteArrayOutputStream) {
                byte[] tmp = ((ByteArrayOutputStream)repMessage).toByteArray();
                utfMsg = new String(tmp, "UTF-8");
            } else if (repMessage instanceof String) {
                utfMsg = (String)repMessage;
            }
            for (int ido = 0; ido < this._registeredSubjects.size(); ++ido) {
                sendSubject = (String)this._registeredSubjects.elementAt(ido);
                if (sendSubject == null || sendSubject.equals("")) continue;
                this._rvMessage.setSendSubject((String)this._registeredSubjects.elementAt(ido));
                if (repMessage instanceof ByteArrayOutputStream || repMessage instanceof String) {
                    this._rvMessage.update("RepEvent", (Object)utfMsg);
                } else {
                    this._rvMessage.update("RepEvent", (Object)((Serializable)repMessage));
                }
                Object object = this._lockSeqNo;
                synchronized (object) {
                    this._lastSeqNo = TibrvCmMsg.getSequence((TibrvMsg)this._rvMessage);
                    this._cmTransport.send(this._rvMessage);
                    this._lastSeqNo = TibrvCmMsg.getSequence((TibrvMsg)this._rvMessage);
                    break;
                }
            }
            this._log.info("TIBRVCMClient.sendEvent.m1", (Object)this._service, (Object)this._network, this._daemon);
            this._log.debug("TIBRVCMClient.sendEvent.m2", utfMsg);
            return true;
        }
        catch (Exception ex) {
            try {
                if (this._dispatcher != null && this._dispatcher.isValid()) {
                    this._dispatcher.join();
                }
                Tibrv.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._log.error("TIBRVCMClient.sendEvent.e1", (Object)this._service, (Object)this._network, (Object)this._daemon, ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMsg(TibrvListener listener, TibrvMsg msg) {
        long seqNo = 0L;
        String info = null;
        Object object = this._lockSeqNo;
        synchronized (object) {
            try {
                seqNo = msg.getAsLong("seqno", 0);
                info = Long.toString(seqNo);
                this._log.debug("TIBRVCMClient.onMsg.m1", info);
            }
            catch (Exception ex) {
                this._log.error("TIBRVCMClient.onMsg.e1", (Throwable)ex);
                try {
                    Tibrv.close();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
        }
    }
}

