/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.tibrv;

import com.sybase.connector.repra.tibrv.TIBRVBase;
import com.tibco.tibrv.Tibrv;
import com.tibco.tibrv.TibrvMsg;
import com.tibco.tibrv.TibrvRvdTransport;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.StringTokenizer;

public class TIBRVClient
extends TIBRVBase {
    public void configureClient() throws Exception {
        this._log.debug("TIBRVClient.configureClient.m1");
        try {
            this._rvTransport = new TibrvRvdTransport(this._service, this._network, this._daemon);
            this._rvMessage = new TibrvMsg();
            StringTokenizer stokenizer = new StringTokenizer(this._subject, ",");
            String subject = "";
            while (stokenizer.hasMoreTokens()) {
                subject = stokenizer.nextToken().trim();
                if (this._registeredSubjects.contains(subject)) continue;
                this._registeredSubjects.add(subject);
            }
            this._log.debug("TIBRVClient.configureClient.m2", (Object)this._service, (Object)this._network, this._daemon);
        }
        catch (Exception ex) {
            this._log.error("TIBRVClient.configureClient.e1", (Object)this._service, (Object)this._network, (Object)this._daemon, ex);
            throw ex;
        }
    }

    public boolean sendEvent(Object repMessage) throws Exception {
        try {
            String utfMsg = "";
            if (repMessage instanceof ByteArrayOutputStream) {
                byte[] tmp = ((ByteArrayOutputStream)repMessage).toByteArray();
                utfMsg = new String(tmp, "UTF-8");
            } else if (repMessage instanceof String) {
                utfMsg = (String)repMessage;
            }
            String sendSubject = "";
            for (int ido = 0; ido < this._registeredSubjects.size(); ++ido) {
                sendSubject = (String)this._registeredSubjects.elementAt(ido);
                if (sendSubject == null || sendSubject.equals("")) continue;
                this._rvMessage.setSendSubject(sendSubject);
                if (repMessage instanceof ByteArrayOutputStream || repMessage instanceof String) {
                    this._rvMessage.update("RepEvent", (Object)utfMsg);
                } else {
                    this._rvMessage.update("RepEvent", (Object)((Serializable)repMessage));
                }
                this._rvTransport.send(this._rvMessage);
            }
            this._log.info("TIBRVClient.sendEvent.m1", (Object)this._service, (Object)this._network, this._daemon);
            this._log.debug("TIBRVClient.sendEvent.m2", utfMsg);
            return true;
        }
        catch (Exception ex) {
            try {
                Tibrv.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._log.error("TIBRVClient.sendEvent.e2", (Object)this._service, (Object)this._network, (Object)this._daemon, ex);
            throw ex;
        }
    }

    public boolean isReady() {
        return this._rvTransport != null;
    }

    public void close() {
        try {
            Tibrv.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

