/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.transform;

import com.sybase.connector.repra.transform.EventFormatter;
import com.sybase.connector.repra.util.DBEventParserFactory;
import com.sybase.connector.repra.util.XMLParseUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SqlFormatter
implements EventFormatter {
    Logger _log;
    protected XMLParseUtil _parser = null;

    public void setLogger(Logger log) {
        this._log = log;
    }

    public List format(String event) throws Exception {
        ArrayList<String> stmts = new ArrayList<String>();
        if (!event.trim().startsWith("<")) {
            stmts.add(0, event);
            return stmts;
        }
        if (this._parser == null) {
            this.initParser(event);
        }
        int size = this._parser.size();
        for (int i = 0; i < size; ++i) {
            String sql = this._parser.getStatement(i);
            stmts.add(sql);
        }
        return stmts;
    }

    protected void initParser(String event) throws Exception {
        this._parser = (XMLParseUtil)DBEventParserFactory.getDBEventParser(event);
        this._parser.validate(true);
        this._parser.setLogger(this._log);
        this._parser.setDatabaseType(0);
    }

    public String getEventId(String event) throws Exception {
        if (this._parser == null) {
            this.initParser(event);
        }
        return this._parser.getEventId();
    }

    public static void main(String[] args) {
        SqlFormatter sft = new SqlFormatter();
        try {
            String document = args[0];
            BufferedReader bf = new BufferedReader(new FileReader(document));
            String line = null;
            StringBuffer sb = new StringBuffer();
            while ((line = bf.readLine()) != null) {
                sb.append(line);
            }
            String xml = sb.toString();
            List stmts = sft.format(xml);
            for (String sql : stmts) {
                System.out.println("xml2sql:" + sql);
            }
            bf.close();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

