/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.util;

import com.sybase.connector.repra.Version;
import java.io.BufferedReader;
import java.io.FileReader;

public class LogViewer {
    private static String _type = "RUNTIME";
    public static String _fileName = "d:\\jaguar\\eas422\\repra\\logs\\rc_" + Version.getFullDotVersion() + "_events.log";
    public static int _startLine = 1;
    public static int _endLine = 5000;

    public static void main(String[] args) {
        if (args.length >= 1) {
            _type = args[0];
        }
        if (args.length >= 2) {
            _startLine = new Integer(args[1]);
        }
        if (args.length >= 3) {
            _endLine = new Integer(args[2]);
        }
        if (args.length >= 4) {
            _fileName = args[3];
        }
        LogViewer view = new LogViewer();
        try {
            StringBuffer sb = view.getLog(_type);
            System.out.println(sb.toString());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void setStartLine(int value) {
        _startLine = value;
    }

    public void setFileName(String value) {
        _fileName = value;
    }

    public void setEndLine(int value) {
        _endLine = value;
    }

    public StringBuffer getLog(String type) throws Exception {
        StringBuffer sb = new StringBuffer();
        BufferedReader bf = new BufferedReader(new FileReader(_fileName));
        String line = null;
        type = "[" + type + "]: ";
        boolean needMore = false;
        int lineCount = 1;
        String tmp = null;
        int totalCount = 1;
        BufferedReader tmpbf = new BufferedReader(new FileReader(_fileName));
        try {
            while ((tmp = tmpbf.readLine()) != null) {
                if (!tmp.startsWith("[")) continue;
                ++totalCount;
            }
            if (totalCount > _endLine) {
                _startLine = totalCount - _endLine;
                _endLine = totalCount;
            }
            while ((line = bf.readLine()) != null && ++lineCount <= _endLine) {
                if (lineCount < _startLine) continue;
                if (line.startsWith(type)) {
                    sb.append(line.substring(type.length()));
                    sb.append("\n");
                    needMore = true;
                    continue;
                }
                if (line.startsWith("[")) {
                    needMore = false;
                    continue;
                }
                if (!needMore) continue;
                --lineCount;
                sb.append(line);
                sb.append("\n");
            }
            StringBuffer stringBuffer = sb;
            return stringBuffer;
        }
        catch (Throwable ex) {
            throw new Exception(ex.toString());
        }
        finally {
            bf.close();
            tmpbf.close();
        }
    }
}

