/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.util;

import com.sybase.connector.repra.util.RepraCipherUtil2;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class RaConnection {
    private String _host = "localhost";
    private String _port = "8000";
    private String _user = "repraadmin";
    private String _password = "rapassword";
    private String _servletName = "/RepraWebApp/RepraControlServlet";
    private HttpURLConnection _conn = null;
    private int _connCode;
    private String _connMsg;
    private int _serverReturnCode;
    private String _serverReturnMsg;
    private String _url = null;
    private String _uri = null;
    private boolean _verbose = false;

    public RaConnection(String host, String port) {
        if (this._host != null && !this._host.equals("")) {
            this._host = host;
        }
        if (this._port != null && !this._port.equals("")) {
            this._port = port;
        }
        this.init();
    }

    public RaConnection(String host, String port, boolean verbose) {
        this._verbose = verbose;
        if (this._host != null && !this._host.equals("")) {
            this._host = host;
        }
        if (this._port != null && !this._port.equals("")) {
            this._port = port;
        }
        this.init();
    }

    public RaConnection(String host, String port, String user, String password) {
        if (this._host != null && !this._host.equals("")) {
            this._host = host;
        }
        if (this._port != null && !this._port.equals("")) {
            this._port = port;
        }
        if (this._user != null && !this._user.equals("")) {
            this._user = user;
        }
        if (this._password != null && !this._password.equals("")) {
            this._password = password;
        }
        this.init();
    }

    public RaConnection(String host, String port, String user, String password, boolean verbose) {
        this._verbose = verbose;
        if (this._host != null && !this._host.equals("")) {
            this._host = host;
        }
        if (this._port != null && !this._port.equals("")) {
            this._port = port;
        }
        if (this._user != null && !this._user.equals("")) {
            this._user = user;
        }
        if (this._password != null && !this._password.equals("")) {
            this._password = password;
        }
        this.init();
    }

    private void init() {
        this._url = "http://" + this._host + ":" + this._port;
        if (this._user != null) {
            this.setURI("loginuser", this._user);
        }
        if (this._password != null) {
            this.setURI("loginpass", RepraCipherUtil2.encrypt_ascii_pwd(this._password));
        }
    }

    public void setUser(String user) {
        if (this._user != null && !this._user.equals("")) {
            this._user = user;
        }
    }

    public void setServletName(String servletName) {
        this._servletName = servletName;
    }

    public String getServletName() {
        return this._servletName;
    }

    public void setPassword(String password) {
        if (this._password != null && !this._password.equals("")) {
            this._password = password;
        }
    }

    public void setURI(String name, String value) {
        this._uri = this._uri == null ? name + "=" + value : this._uri + "&" + name + "=" + value;
    }

    public void setURI(String name, int value) {
        this.setURI(name, String.valueOf(value));
    }

    public Object send(Object dataObj) throws Exception {
        ObjectOutputStream outstream = null;
        ObjectInputStream instream = null;
        Object returnObj = null;
        String receiverURL = this._url + this._servletName + "?" + this._uri;
        if (this._verbose) {
            System.out.println("RaConnection[DEBUG]: Send Message to " + receiverURL);
        }
        try {
            URL url = new URL(receiverURL);
            this._conn = (HttpURLConnection)url.openConnection();
            this._conn.setDoInput(true);
            this._conn.setDoOutput(true);
            this._conn.setUseCaches(false);
            this._conn.setRequestMethod("POST");
            this._conn.setRequestProperty("Content-Type", "application/x-java-serialized-object");
            if (dataObj != null) {
                outstream = new ObjectOutputStream(this._conn.getOutputStream());
                outstream.writeObject(dataObj);
                outstream.flush();
                outstream.close();
                this._conn.getOutputStream().close();
                outstream = null;
            } else {
                this._conn.connect();
            }
            this._connCode = this._conn.getResponseCode();
            this._connMsg = this._conn.getResponseMessage();
            if (this._verbose) {
                System.out.println("RaConnection[DEBUG]: Returned getResponseCode = " + this._connCode + ",getResponseMessage = '" + this._connMsg + "' for receiverURL '" + receiverURL + "'.");
                System.out.println("RaConnection[DEBUG]: contentLength = " + this._conn.getContentLength());
            }
            String retCodeStr = this._conn.getHeaderField("ReturnCode");
            this._serverReturnCode = Integer.parseInt(retCodeStr);
            this._serverReturnMsg = this._conn.getHeaderField("ReturnString");
            if (retCodeStr == null || this._serverReturnCode == 4) {
                throw new Exception(this._serverReturnMsg);
            }
            InputStream in = this._conn.getInputStream();
            if (in != null) {
                instream = new ObjectInputStream(in);
                returnObj = instream.readObject();
            }
        }
        catch (Throwable ee) {
            throw new Exception(ee.toString());
        }
        finally {
            if (this._conn != null) {
                try {
                    this._conn.getInputStream().close();
                }
                catch (Exception ee) {}
            }
        }
        return returnObj;
    }

    public Object send() throws Exception {
        return this.send(null);
    }

    private void setConnectionStatusCode(int code) {
        this._connCode = code;
    }

    private void setConnectionStatusMsg(String msg) {
        this._connMsg = msg;
    }

    public String getUser() {
        return this._user;
    }

    public String getPassword() {
        return this._password;
    }

    public String getURL() {
        return this._url + this._servletName;
    }

    public String getURI() {
        return this._uri;
    }

    public int getConnectionStatusCode() {
        return this._connCode;
    }

    public String getConnectionStatusMsg() {
        return this._connMsg;
    }

    public int getServerReturnCode() {
        return this._serverReturnCode;
    }

    public String getServerReturnMessage() {
        return this._serverReturnMsg;
    }
}

