/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.util;

import com.sybase.connector.repra.RepraDataTypes;
import com.sybase.connector.repra.rep.RepEvent;
import com.sybase.connector.repra.rep.RepTransactionFormatter;
import com.sybase.connector.repra.rep.RepValue;
import com.sybase.connector.repra.rep.StdXMLFormatter;
import com.sybase.connector.repra.rep.XsdXmlFormatter;
import com.sybase.connector.repra.util.DBEventParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.crimson.tree.XmlDocument;
import org.dom4j.Document;

public class RepParseUtil
implements DBEventParser {
    private static final int REPEVENT = 0;
    private static final int REPEVENTARRAY = 1;
    private int _sourceType = 0;
    private RepEvent _repEvent = null;
    private RepEvent[] _repEventArray = null;
    private String _dsName;
    private String _dbName;
    private String _eventId;
    private int _databaseType = 0;

    RepParseUtil() {
    }

    RepParseUtil(Object src) throws Exception {
        this.setSource(src);
    }

    public void setSource(Object src) throws Exception {
        if (src instanceof RepEvent) {
            this._sourceType = 0;
            this._repEvent = (RepEvent)src;
            this._repEventArray = null;
        } else if (src instanceof RepEvent[]) {
            this._sourceType = 1;
            this._repEvent = null;
            this._repEventArray = (RepEvent[])src;
        } else {
            throw new Exception("Not supported source type");
        }
    }

    public void setDatabaseType(int databaseType) {
        this._databaseType = databaseType;
    }

    public int getDatabaseType() {
        return this._databaseType;
    }

    public int size() {
        if (this._sourceType == 0) {
            return 1;
        }
        return this._repEventArray.length;
    }

    public String getDSName() throws Exception {
        if (this._sourceType == 0) {
            return this._repEvent.getDsName();
        }
        return this._repEventArray[0].getDsName();
    }

    public String getDBName() throws Exception {
        if (this._sourceType == 0) {
            return this._repEvent.getDbName();
        }
        return this._repEventArray[0].getDbName();
    }

    public String getEventId() throws Exception {
        if (this._sourceType == 0) {
            return this._repEvent.getMessageId();
        }
        if (this._sourceType == 1) {
            return this._repEventArray[this.size() - 1].getMessageId();
        }
        return null;
    }

    public String getStatement() throws Exception {
        if (this._sourceType == 0) {
            return this._repEvent.getStatement();
        }
        StringBuffer stmtbuffer = new StringBuffer();
        for (int ido = 0; ido < this.size(); ++ido) {
            stmtbuffer.append(this.getStatement(ido));
            if (ido == this.size() - 1) continue;
            stmtbuffer.append("\n");
        }
        return stmtbuffer.toString();
    }

    public String getOperation(int elemAt) throws Exception {
        if (this._sourceType == 0 && elemAt == 0) {
            return this._repEvent.getOperation();
        }
        if (this._sourceType == 1) {
            return this._repEventArray[elemAt].getOperation();
        }
        throw new Exception("Invalid element index : " + elemAt);
    }

    public String getTableFullName(int elemAt) throws Exception {
        if (this._sourceType == 0 && elemAt == 0) {
            return this._repEvent.getName();
        }
        if (this._sourceType == 1) {
            return this._repEventArray[elemAt].getName();
        }
        throw new Exception("Invalid element index : " + elemAt);
    }

    public String getSchemaName(int elemAt) throws Exception {
        String tableName = this.getTableFullName(elemAt);
        if (tableName != null && tableName.indexOf(".") >= 0) {
            return tableName.substring(tableName.indexOf(".") + 1, tableName.length());
        }
        return tableName;
    }

    public String getOwner(int elemAt) throws Exception {
        String tableName = this.getTableFullName(elemAt);
        if (tableName != null && tableName.indexOf(".") >= 0) {
            return tableName.substring(0, tableName.indexOf("."));
        }
        return tableName;
    }

    public Vector getData(int elemAt) throws Exception {
        Vector data = new Vector();
        RepValue repValue = null;
        if (this._sourceType == 0 && elemAt == 0) {
            repValue = this._repEvent.getColumns();
        } else if (this._sourceType == 1) {
            repValue = this._repEventArray[elemAt].getColumns();
        } else {
            throw new Exception("Invalid element index : " + elemAt);
        }
        if (repValue.size() > 0) {
            for (int i = 0; i < repValue.size(); ++i) {
                Hashtable<String, Object> field = new Hashtable<String, Object>();
                field.put("FieldName", repValue.getName(i));
                field.put("FieldType", new Integer(repValue.getType(i)));
                field.put("FieldValue", this.getValueToObject(repValue, i));
                data.add(field);
            }
        }
        return data;
    }

    public Vector getKeys(int elemAt) throws Exception {
        Vector keys = new Vector();
        RepValue repValue = null;
        if (this._sourceType == 0 && elemAt == 0) {
            repValue = this._repEvent.getWhere();
        } else if (this._sourceType == 1) {
            repValue = this._repEventArray[elemAt].getWhere();
        } else {
            throw new Exception("Invalid element index : " + elemAt);
        }
        if (repValue.size() > 0) {
            for (int i = 0; i < repValue.size(); ++i) {
                Hashtable<String, Object> field = new Hashtable<String, Object>();
                field.put("FieldName", repValue.getName(i));
                field.put("FieldType", new Integer(repValue.getType(i)));
                field.put("FieldValue", this.getValueToObject(repValue, i));
                keys.add(field);
            }
        }
        return keys;
    }

    public String getStatement(int elemAt) throws Exception {
        if (this._sourceType == 0 && elemAt == 0) {
            return this._repEvent.getStatement();
        }
        if (this._sourceType == 1) {
            return this._repEventArray[elemAt].getStatement();
        }
        throw new Exception("Invalid element index : " + elemAt);
    }

    public String getFieldName(Hashtable field) {
        return (String)field.get("FieldName");
    }

    public int getFieldType(Hashtable field) {
        return (Integer)field.get("FieldType");
    }

    public String getFieldTypeString(Hashtable field) {
        return (String)RepraDataTypes.DATATYPE_STRINGS.get(new Integer(this.getFieldType(field)));
    }

    public Object getFieldValue(Hashtable field) {
        return field.get("FieldValue");
    }

    public String toXMLText(String dtdURL) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Object formatted = "";
        boolean isdtd = false;
        RepTransactionFormatter _formatter = null;
        if (dtdURL.endsWith("dtd")) {
            isdtd = true;
            _formatter = new StdXMLFormatter();
            ((StdXMLFormatter)_formatter).setDTD_URL(dtdURL);
            ((StdXMLFormatter)_formatter).setEventId(this.getEventId());
        } else if (dtdURL.endsWith("xsd")) {
            _formatter = new XsdXmlFormatter();
            ((XsdXmlFormatter)_formatter).setXsdUri(dtdURL);
            ((XsdXmlFormatter)_formatter).setEventId(this.getEventId());
        }
        if (this._sourceType == 0) {
            formatted = _formatter.format(this._repEvent);
        } else if (this._sourceType == 1) {
            formatted = _formatter.formatTransaction(this._repEventArray);
        }
        if (isdtd) {
            StdXMLFormatter cfr_ignored_0 = (StdXMLFormatter)_formatter;
            baos = StdXMLFormatter.xmlDocString((XmlDocument)formatted);
        } else {
            XsdXmlFormatter cfr_ignored_1 = (XsdXmlFormatter)_formatter;
            baos = XsdXmlFormatter.xmlDocString((Document)formatted);
        }
        return baos.toString("UTF-8");
    }

    private String strip(String s) {
        if (s == null) {
            return null;
        }
        if (s.charAt(0) == '\'') {
            int i = s.length();
            s = s.substring(1, i - 1);
        }
        return s.trim();
    }

    private Object getValueToObject(RepValue repValue, int i) throws Exception {
        Object obj = null;
        if (repValue.getType(i) == 5 || repValue.getType(i) == 1 || repValue.getType(i) == 19) {
            ByteArrayInputStream barray = new ByteArrayInputStream(repValue.getBytes(i, 2));
            obj = barray;
        } else if (repValue.getType(i) == 6 || repValue.getType(i) == 7 || repValue.getType(i) == 8) {
            Integer intVal = new Integer(repValue.getInt(i, 2));
            obj = intVal;
        } else if (repValue.getType(i) == 9) {
            Double doubleVal = new Double(repValue.getDouble(i, 2));
            obj = doubleVal;
        } else if (repValue.getType(i) == 10) {
            Float floatVal = new Float(repValue.getFloat(i, 2));
            obj = floatVal;
        } else if (repValue.getType(i) == 11) {
            Boolean bitVal = new Boolean(repValue.getBoolean(i, 2));
            obj = bitVal;
        } else {
            String strVal = this.strip(repValue.getLiteral(i, 2));
            obj = strVal;
        }
        return obj;
    }
}

