/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.util;

import com.sun.crypto.provider.SunJCE;
import com.sun.net.ssl.internal.ssl.Provider;
import com.sybase.connector.repra.RepraConst;
import com.sybase.connector.repra.util.RepraPropertyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Key;
import java.security.Security;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class RepraCipherUtil {
    private static final String KEYFILE_NAME = "repraSecurity.key";
    private static final String CIPHER_ALGORITHM = "DES/ECB/PKCS5Padding";
    private static String _securityDir = ".";
    private Cipher _cipher;
    private Key _key = null;
    private String _seedString = "6r7laBl32F";

    public void init() {
        _securityDir = RepraPropertyUtil.getSecurityDir();
        this.getKeyObject();
    }

    public void init(String seed) {
        _securityDir = RepraPropertyUtil.getSecurityDir();
        this._seedString = seed;
        this.getKeyObject();
    }

    public void getKeyObject() {
        ObjectInputStream instream = null;
        System.out.println("Key Filename : " + _securityDir + File.separator + KEYFILE_NAME);
        try {
            File keyptr = new File(_securityDir + File.separator + KEYFILE_NAME);
            if (!keyptr.isFile()) {
                this.createKeyObject();
            }
            Security.addProvider(new SunJCE());
            Security.addProvider((java.security.Provider)new Provider());
            instream = new ObjectInputStream(new FileInputStream(_securityDir + File.separator + KEYFILE_NAME));
            this._key = (Key)instream.readObject();
            instream.close();
            this._cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void createKeyObject(String seedString) {
        this._seedString = seedString;
        this.createKeyObject();
    }

    public void createKeyObject() {
        File fptr = new File(_securityDir);
        if (!fptr.isDirectory()) {
            fptr.mkdir();
        }
        try {
            String keyfileName = _securityDir + File.separator + KEYFILE_NAME;
            fptr = new File(keyfileName);
            if (fptr.isFile()) {
                RepraPropertyUtil.decryptAll();
            }
            this._key = this.getKey();
            ObjectOutputStream outstream = null;
            outstream = new ObjectOutputStream(new FileOutputStream(keyfileName));
            outstream.writeObject(this._key);
            outstream.close();
            RepraPropertyUtil.encryptAll();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Key getKey() throws Exception {
        try {
            byte[] bArray = this._seedString.getBytes();
            DESKeySpec pass = new DESKeySpec(bArray);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DES");
            SecretKey sk = skf.generateSecret(pass);
            return sk;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new Exception(ex.getMessage());
        }
    }

    public String encrypt(String plaintext) throws Exception {
        if (this._key != null) {
            this._cipher.init(1, this._key);
            byte[] stringBytes = plaintext.getBytes("UTF8");
            byte[] raw = this._cipher.doFinal(stringBytes);
            String hexString = this.byteArrayToHexString(raw);
            return hexString;
        }
        return plaintext;
    }

    public String decrypt(String ciphertext) throws Exception {
        if (this._key != null) {
            this._cipher.init(2, this._key);
            byte[] cipher_bytes = this.hexToByteArray(ciphertext);
            byte[] stringBytes = this._cipher.doFinal(cipher_bytes);
            String result = new String(stringBytes, "UTF8");
            return result;
        }
        return ciphertext;
    }

    private byte[] hexToByteArray(String hexText) throws Exception {
        String hexUpperText = hexText.toUpperCase();
        byte[] result = new byte[hexText.length() / 2];
        int ido = 0;
        int jdo = 0;
        while (ido < hexText.length()) {
            result[jdo] = (byte)(16 * this.hexToDecimal(hexUpperText.charAt(ido)) + this.hexToDecimal(hexUpperText.charAt(ido + 1)));
            ido += 2;
            ++jdo;
        }
        return result;
    }

    private byte hexToDecimal(char c) throws Exception {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': {
                return 10;
            }
            case 'B': {
                return 11;
            }
            case 'C': {
                return 12;
            }
            case 'D': {
                return 13;
            }
            case 'E': {
                return 14;
            }
            case 'F': {
                return 15;
            }
        }
        throw new Exception("Out of range of HexDecimal");
    }

    private String byteArrayToHexString(byte[] byteArray) throws Exception {
        String result = "";
        if (byteArray.length == 0) {
            return null;
        }
        for (int ido = 0; ido < byteArray.length; ++ido) {
            result = result + this.byteToHex(byteArray[ido]);
        }
        return result;
    }

    private String byteToHex(byte b) {
        char[] hex_digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] charArray = new char[]{hex_digit[b >> 4 & 0xF], hex_digit[b & 0xF]};
        return new String(charArray);
    }

    public static void main(String[] args) {
        if (args.length != 5 || !args[0].equalsIgnoreCase("setlogin")) {
            System.out.println("Usage : java -classpath <your classpat> com.sybase.connector.repra.util.RepraCipherUtil setlogin <oldName> <oldPass> <newName> <newPass>");
            System.exit(1);
        }
        File fptr = new File(_securityDir + File.separator + "repralogin.key");
        File fptr2 = new File(_securityDir + File.separator + KEYFILE_NAME);
        if (!fptr.isFile()) {
            System.out.println("This is not a valid security directory.");
            System.exit(1);
        }
        try {
            String curName = args[1];
            String curPass = args[2];
            String newName = args[3];
            String newPass = args[4];
            Properties secProps = new Properties();
            secProps.load(new FileInputStream(_securityDir + File.separator + "repralogin.key"));
            String user = secProps.getProperty("loginuser", "");
            String pass = secProps.getProperty("loginpass", "");
            String encpass = "";
            if (fptr2.isFile()) {
                RepraCipherUtil cUtil = new RepraCipherUtil();
                cUtil.getKeyObject();
                pass = cUtil.decrypt(pass);
                newPass = cUtil.encrypt(newPass);
            }
            if (newName == null || newName.equals("") || !curName.equals(user) || !curPass.equals(pass)) {
                System.out.println("You have entered invalid login information.");
                System.exit(1);
            }
            secProps.setProperty("loginuser", newName);
            secProps.setProperty("loginpass", newPass);
            secProps.store(new FileOutputStream(_securityDir + File.separator + "repralogin.key"), RepraConst.FILE_WARNING);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

