/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.util;

public class RepraCipherUtil2 {
    public static final int BAD_TYPE = -999;
    private static final int MAX_IDENT_LEN_C = 30;
    private static final int ENC_KEY_LEN_C = 32;
    private static final int ENCRYPT_NONE_C = 0;
    private static final int ENCRYPT_RS1010_C = 1;
    private static final int MIN_ENCRYPT_C = 0;
    private static final int MAX_ENCRYPT_C = 1;
    private static final int ENCRYPT_VER_INDEX = 0;
    private static final int ENCRYPT_LEN_INDEX = 1;
    private static final int ENCRYPT_DAT_INDEX = 2;
    public static final String NULL_PASSWORD = "0x0100676767676767676767676767676767676767676767676767676767676767";
    private static char[] _enckeys = new char[]{'g', '\u00cf', '\u00d4', 'v', '\u009d', '\u0018', 'g', '\u00af', '\u00c6', '\u00bf', 'd', 'c', 'j', 'F', '\u00d0', '\u00bb', '\u0004', '\u00b4', 'd', 'X', '\u00c2', '\u00d5', '\u00c6', '\u00bc', '\u00cc', '\u00b4', '\u00d1', 'N', '\u00d3', '\u00f0', '\u007f', '\u0080'};
    private static String _securityDir = ".";

    public static final char[] encrypt(char[] plaintext, int salt, int len) {
        char[] ciphertext = new char[len];
        if (len <= 0) {
            return ciphertext;
        }
        ciphertext[0] = (char)(salt ^ plaintext[0]);
        for (int i = 1; i < len; ++i) {
            ciphertext[i] = (char)(ciphertext[i - 1] ^ plaintext[i]);
        }
        return ciphertext;
    }

    public static final char[] decrypt(char[] ciphertext, int salt, int len) {
        char[] plaintext = new char[len];
        if (len <= 0) {
            return plaintext;
        }
        plaintext[0] = (char)(salt ^ ciphertext[0]);
        for (int i = 1; i < len; ++i) {
            plaintext[i] = (char)(ciphertext[i - 1] ^ ciphertext[i]);
        }
        return plaintext;
    }

    public static final String encrypt_pwd(String pwd) {
        int pwd_len = pwd.length();
        char[] tmp_area = new char[30];
        pwd.getChars(0, pwd_len, tmp_area, 0);
        System.arraycopy(_enckeys, 0, tmp_area, pwd_len, 30 - pwd_len);
        for (int i = 0; i < 30; ++i) {
            int n = i;
            tmp_area[n] = (char)(tmp_area[n] ^ _enckeys[i % 32]);
        }
        char salt = _enckeys[pwd_len];
        tmp_area = RepraCipherUtil2.encrypt(tmp_area, salt, 30);
        char[] encr_buf = new char[32];
        encr_buf[0] = '\u0001';
        encr_buf[1] = (char)pwd_len;
        System.arraycopy(tmp_area, 0, encr_buf, 2, tmp_area.length);
        return new String(encr_buf);
    }

    public static final String decrypt_pwd(String cipher) {
        if (cipher == null || cipher.length() == 0) {
            return new String();
        }
        int pwd_len = cipher.charAt(1);
        char salt = _enckeys[pwd_len];
        char[] tmp_area = new char[30];
        cipher.getChars(2, cipher.length(), tmp_area, 0);
        tmp_area = RepraCipherUtil2.decrypt(tmp_area, salt, 30);
        char[] pwd = new char[pwd_len];
        for (int i = 0; i < pwd_len; ++i) {
            pwd[i] = (char)(tmp_area[i] ^ _enckeys[i % 32]);
        }
        return new String(pwd);
    }

    public static final String conv_to_char(String src) {
        StringBuffer sb = new StringBuffer("0x");
        if (src == null || src.length() < 1) {
            sb.append("0");
        } else {
            char[] ba = src.toCharArray();
            for (int i = 0; i < ba.length; ++i) {
                sb.append(Character.forDigit((byte)(ba[i] >> 4), 16));
                sb.append(Character.forDigit((byte)(ba[i] & 0xF), 16));
            }
        }
        return new String(sb);
    }

    public static final String conv_to_bin(String src) {
        if (src == null || src.equals("")) {
            return "";
        }
        char[] ca = src.toCharArray();
        StringBuffer sb = new StringBuffer();
        if (ca.length >= 2 && ca[0] == '0' && (ca[1] == 'x' || ca[1] == 'X')) {
            int i = 2;
            while (i < ca.length && i + 1 != ca.length) {
                int bin = Character.digit(ca[i++], 16) << 4;
                if (i + 1 == ca.length) break;
                sb.append((char)(bin += Character.digit(ca[i++], 16)));
            }
        }
        return new String(sb);
    }

    public static final String encrypt_ascii_pwd(String pwd) {
        if (pwd == null || pwd.equals("") || pwd.equals("\"\"") || pwd.equals("''")) {
            return NULL_PASSWORD;
        }
        if (pwd.equals(NULL_PASSWORD)) {
            return pwd;
        }
        String encpwd = RepraCipherUtil2.conv_to_char(RepraCipherUtil2.encrypt_pwd(pwd));
        if (encpwd == null || encpwd.equals("")) {
            return pwd;
        }
        return encpwd;
    }

    public static final String decrypt_ascii_pwd(String pwd) {
        if (pwd == null || pwd.equals("") || pwd.equals("\"\"") || pwd.equals("''")) {
            return "";
        }
        if (pwd.equals(NULL_PASSWORD)) {
            return "";
        }
        String decpwd = RepraCipherUtil2.decrypt_pwd(RepraCipherUtil2.conv_to_bin(pwd));
        if (decpwd == null || decpwd.equals("")) {
            return pwd;
        }
        return decpwd;
    }
}

