/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.util;

import com.sybase.connector.repra.BaseConst;
import com.sybase.connector.repra.ConnectionContainer;
import com.sybase.connector.repra.RepraConnection;
import com.sybase.connector.repra.RepraConnectionSpec;
import com.sybase.connector.repra.RepraConst;
import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.util.LogViewer;
import com.sybase.connector.repra.util.RaException;
import com.sybase.connector.repra.util.RaStatus;
import com.sybase.connector.repra.util.RaUtils;
import com.sybase.connector.repra.util.RepraPingUtil;
import com.sybase.connector.repra.util.RepraPropertyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;

public class RepraControlUtil
implements RaUtils {
    private static RaLogger _log = null;
    private static final int VALIDATE_SUCCESS = 0;
    private static final int VALIDATE_FAIL_INBOUND = 1;
    private static final int VALIDATE_FAIL_OUTBOUND = 2;
    private static final int VALIDATE_FAIL_GENERAL = 3;
    private static final int VALIDATE_FAIL_CUSTOMSENDER = 4;
    private static final int VALIDATE_FAIL_CUSTOMFORMATTER = 5;
    private static final int VALIDATE_FAIL_CUSTOM_SENDER_FORMATTER = 6;
    private static Hashtable _pingTypeMap;
    public String _configDir = RepraPropertyUtil.getConfigDir();
    private static Hashtable _configProps;

    public int getInTypeInt(String inStr) {
        String[] typeStr = new String[]{"REPLICATION", "JMS", "TIBCO", "IBMMQ"};
        for (int ido = 0; ido < typeStr.length; ++ido) {
            if (!inStr.equalsIgnoreCase(typeStr[ido])) continue;
            return ido;
        }
        return 0;
    }

    public int getOutTypeInt(String outStr) {
        String[] typeStr = new String[]{"JMS", "TIBCO", "IBMMQ", "DATABASE", "CUSTOM"};
        for (int ido = 0; ido < typeStr.length; ++ido) {
            if (!outStr.equalsIgnoreCase(typeStr[ido])) continue;
            return ido;
        }
        return 0;
    }

    public boolean isConnection(String connName) {
        try {
            String fileName = this.getConnectionFile(connName);
            File ftpr = new File(fileName);
            if (ftpr.isFile()) {
                Properties props = new Properties();
                FileInputStream fin = new FileInputStream(fileName);
                props.load(fin);
                fin.close();
                if (!(props.getProperty("ConnectionName", "").equals("") || props.getProperty("InboundType", "").equals("") || props.getProperty("OutboundType", "").equals(""))) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.isConnection.e1", (Object)connName, (Throwable)ex);
            return false;
        }
    }

    public boolean saveConnection(String connName, Properties props) throws Exception {
        try {
            String propsFile = this._configDir + File.separator + connName + ".props";
            FileOutputStream fout = new FileOutputStream(propsFile);
            Properties encProps = RepraPropertyUtil.encProperties(props);
            encProps.store(fout, BaseConst.FILE_WARNING);
            fout.flush();
            fout.close();
            return true;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.saveConnection.e1", (Object)connName, (Throwable)ex);
            return false;
        }
    }

    public RaStatus getConnections() throws RaException {
        RaStatus raStatus = new RaStatus(14, "");
        try {
            raStatus.setReturnObject(this.getConnectionNames());
            raStatus.setCode(0);
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.getConnections.m1", null, (Throwable)ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.getConnections.ms1"), ex);
        }
    }

    public Vector getConnectionNames() throws Exception {
        Vector<String> connections = new Vector<String>();
        File fptr = new File(this._configDir);
        if (!fptr.isDirectory() && !fptr.mkdir()) {
            throw new IOException(this._configDir + " directory does not exist.");
        }
        String[] files = fptr.list();
        Properties props = new Properties();
        for (int ido = 0; ido < files.length; ++ido) {
            File ptr;
            if (!files[ido].endsWith(".props") || !(ptr = new File(this._configDir + File.separator + files[ido])).isFile()) continue;
            FileInputStream fin = new FileInputStream(this._configDir + File.separator + files[ido]);
            props.load(fin);
            fin.close();
            if (props.getProperty("ConnectionName", "").equals("") || props.getProperty("InboundType", "").equals("") || props.getProperty("OutboundType", "").equals("")) continue;
            connections.add(props.getProperty("ConnectionName"));
        }
        return connections;
    }

    public Properties getConfigProps(String connName) throws Exception {
        this.checkName(connName);
        try {
            String propsFile = this.getConnectionFile(connName);
            FileInputStream fin = new FileInputStream(propsFile);
            fin.close();
            Properties props = RepraPropertyUtil.getProperties(connName);
            return props;
        }
        catch (FileNotFoundException fne) {
            _log.error("RepraControlUtil.getConfigProps.e1", (Object)connName, (Throwable)fne);
            throw new Exception(_log.getResourceBundle().getString("RepraControlUtil.getConfigProps.es1"));
        }
        catch (Throwable ex) {
            _log.error("RepraControlUtil.getConfigProps.e2", (Object)connName, ex);
            throw new Exception(ex);
        }
    }

    public RaStatus getConnectionProps(String connName) throws RaException {
        RaStatus raStatus = new RaStatus(18, connName);
        try {
            this.checkName(connName);
            if (this.isConnection(connName)) {
                raStatus.setReturnObject(this.getConfigProps(connName));
                raStatus.setCode(0);
            } else {
                raStatus.setCode(4);
                raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.getConnectionProps.ms2"));
            }
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.getConnectionProps.m3", (Object)connName, (Throwable)ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.getConnectionProps.m3"), ex);
        }
    }

    public RaStatus getConnectionPropValue(String connName, String propName) throws RaException {
        RaStatus raStatus = new RaStatus(19, connName);
        try {
            this.checkName(connName);
            raStatus.setCode(4);
            if (this.isConnection(connName)) {
                Properties props = this.getConfigProps(connName);
                if (props.containsKey(propName)) {
                    raStatus.setReturnObject(props.getProperty(propName));
                    raStatus.setCode(0);
                    _log.debug("RepraControlUtil.getConnectionPropValue.m1", (Object)connName, (Object)propName, (Object)props.getProperty(propName), null);
                } else {
                    raStatus.setReturnObject(null);
                    raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.getConnectionPropValue.ms2"));
                    _log.error("RepraControlUtil.getConnectionPropValue.m2", (Object)connName, (Object)propName, null);
                }
            } else {
                raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.getConnectionPropValue.ms3"));
                _log.error("RepraControlUtil.getConnectionPropValue.m3", (Object)connName, null);
            }
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.getConnectionPropValue.m4", (Object)connName, (Object)propName, ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.getConnectionPropValue.ms4"), ex);
        }
    }

    public RaStatus setConnectionPropValue(String connName, String propName, String propValue) throws RaException {
        RaStatus raStatus = new RaStatus(20, connName);
        try {
            this.checkName(connName);
            raStatus.setCode(4);
            if (this.isConnection(connName)) {
                Properties props = this.getConfigProps(connName);
                props.setProperty(propName, propValue);
                if (this.saveConnection(connName, props)) {
                    raStatus.setCode(0);
                    _log.debug("RepraControlUtil.setConnectionPropValue.m1", (Object)connName, (Object)propName, (Object)propValue, null);
                } else {
                    raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.setConnectionPropValue.ms2"));
                    _log.error("RepraControlUtil.setConnectionPropValue.m2", (Object)connName, (Object)propName, (Object)propValue, null);
                }
            } else {
                raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.setConnectionPropValue.ms3"));
                _log.error("RepraControlUtil.setConnectionPropValue.m3", (Object)connName, null);
            }
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.setConnectionPropValue.m4", (Object)propName, (Object)propValue, (Object)connName, ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.setConnectionPropValue.ms4"), ex);
        }
    }

    public String getConnectionFile(String connName) throws Exception {
        this.checkName(connName);
        String configProp = (String)_configProps.get(connName);
        if (configProp != null) {
            return configProp;
        }
        File fptr = new File(this._configDir);
        if (!fptr.isDirectory() && !fptr.mkdir()) {
            throw new IOException(this._configDir + " directory does not exist.");
        }
        String[] files = fptr.list();
        Properties props = new Properties();
        for (int ido = 0; ido < files.length; ++ido) {
            File ptr;
            if (!files[ido].endsWith(".props") || !(ptr = new File(this._configDir + File.separator + files[ido])).isFile()) continue;
            FileInputStream fin = new FileInputStream(this._configDir + File.separator + files[ido]);
            props.load(fin);
            fin.close();
            if (!props.getProperty("ConnectionName", "").equals(connName)) continue;
            configProp = this._configDir + File.separator + files[ido];
            _configProps.put(connName, configProp);
            return configProp;
        }
        _log.warn("getPropertyFile(), returning empty file", null, null);
        return "";
    }

    public Vector getGenConfigParams(Properties props) {
        Vector<String> genParams = new Vector<String>();
        genParams.add(0, props.getProperty("ConnectionName", ""));
        genParams.add(1, props.getProperty("InboundType", ""));
        genParams.add(2, props.getProperty("OutboundType", ""));
        genParams.add(3, props.getProperty("DTD_URL", "http://localhost:8000/RepraWebApp/dtds/dbeventstream.dtd"));
        genParams.add(4, props.getProperty("AutoStart", "false"));
        genParams.add(5, props.getProperty("FormatterFlag", "false"));
        genParams.add(6, props.getProperty("RetryLimit", ""));
        genParams.add(7, props.getProperty("RetryPeriod", ""));
        genParams.add(8, props.getProperty("LogLevel", "ERROR"));
        return genParams;
    }

    public Vector getInboundConfigParams(Properties props) {
        Vector<String> inParams = new Vector<String>();
        String inType = props.getProperty("InboundType", "REPLICATION");
        if (inType.equalsIgnoreCase("REPLICATION")) {
            inParams.add(0, props.getProperty("DSIName", ""));
            inParams.add(1, props.getProperty("DSIPort", ""));
            inParams.add(2, props.getProperty("RepAdapterLogin", "sa"));
            inParams.add(3, props.getProperty("RepAdapterPassword", ""));
            inParams.add(4, props.getProperty("RSSDURL", ""));
            inParams.add(5, props.getProperty("SQLINITSTR", ""));
            inParams.add(6, props.getProperty("RSSDLogin", "sa"));
            inParams.add(7, props.getProperty("RSSDPassword", ""));
            inParams.add(8, props.getProperty("RequiredGroup", "false"));
        } else if (inType.equalsIgnoreCase("JMS")) {
            inParams.add(0, props.getProperty("JMSType", "queue"));
            inParams.add(1, props.getProperty("JMS_ProviderURL", ""));
            inParams.add(2, props.getProperty("JMS_InitialContext", ""));
            inParams.add(3, props.getProperty("JMS_QCF", ""));
            inParams.add(4, props.getProperty("JMS_LocalQueue", ""));
            inParams.add(5, props.getProperty("JMS_Username", ""));
            inParams.add(6, props.getProperty("JMS_Password", ""));
            inParams.add(7, props.getProperty("JMS_TopicSubscribers", ""));
        } else if (inType.equalsIgnoreCase("TIBCO")) {
            inParams.add(0, props.getProperty("TIBType", "RV"));
            inParams.add(1, props.getProperty("RV_Service", ""));
            inParams.add(2, props.getProperty("RV_Network", ""));
            inParams.add(3, props.getProperty("RV_Daemon", ""));
            inParams.add(4, props.getProperty("RV_Subject", ""));
            inParams.add(5, props.getProperty("RV_CMName", ""));
            inParams.add(6, props.getProperty("RV_CMDuration", ""));
            inParams.add(7, props.getProperty("AppConfig", "").replace('\\', '/'));
            inParams.add(8, props.getProperty("MsgGenerator", ""));
        } else if (inType.equalsIgnoreCase("IBMMQ")) {
            inParams.add(0, props.getProperty("MQType", "MQ"));
            inParams.add(1, props.getProperty("MQ_LocalClient", "false"));
            inParams.add(2, props.getProperty("MQ_Hostname", ""));
            inParams.add(3, props.getProperty("MQ_PortNumber", ""));
            inParams.add(4, props.getProperty("MQ_Channel", ""));
            inParams.add(5, props.getProperty("MQ_QueueManager", ""));
            inParams.add(6, props.getProperty("MQ_LocalQueue", ""));
            inParams.add(7, props.getProperty("MQ_Encoding", "default"));
            inParams.add(8, props.getProperty("MQ_Username", ""));
            inParams.add(9, props.getProperty("MQ_Password", ""));
        }
        return inParams;
    }

    public Vector getOutboundConfigParams(Properties props) {
        Vector<String> outParams = new Vector<String>();
        String outType = props.getProperty("OutboundType", "JMS");
        if (outType.equalsIgnoreCase("JMS")) {
            outParams.add(0, props.getProperty("JMSType", "queue"));
            outParams.add(1, props.getProperty("JMS_ProviderURL", ""));
            outParams.add(2, props.getProperty("JMS_InitialContext", ""));
            outParams.add(3, props.getProperty("JMS_QCF", ""));
            outParams.add(4, props.getProperty("JMS_LocalQueue", ""));
            outParams.add(5, props.getProperty("JMS_Username", ""));
            outParams.add(6, props.getProperty("JMS_Password", ""));
            outParams.add(7, props.getProperty("JMS_TopicSubscribers", ""));
        } else if (outType.equalsIgnoreCase("TIBCO")) {
            outParams.add(0, props.getProperty("TIBType", "RV"));
            outParams.add(1, props.getProperty("RV_Service", ""));
            outParams.add(2, props.getProperty("RV_Network", ""));
            outParams.add(3, props.getProperty("RV_Daemon", ""));
            outParams.add(4, props.getProperty("RV_Subject", ""));
            outParams.add(5, props.getProperty("RV_CMName", ""));
            outParams.add(6, props.getProperty("RV_CMDuration", ""));
            outParams.add(7, props.getProperty("AppConfig", "").replace('\\', '/'));
            outParams.add(8, props.getProperty("MsgGenerator", ""));
        } else if (outType.equalsIgnoreCase("IBMMQ")) {
            outParams.add(0, props.getProperty("MQType", "MQ"));
            outParams.add(1, props.getProperty("MQ_LocalClient", ""));
            outParams.add(2, props.getProperty("MQ_Hostname", ""));
            outParams.add(3, props.getProperty("MQ_PortNumber", ""));
            outParams.add(4, props.getProperty("MQ_Channel", ""));
            outParams.add(5, props.getProperty("MQ_QueueManager", ""));
            outParams.add(6, props.getProperty("MQ_LocalQueue", ""));
            outParams.add(7, props.getProperty("MQ_Encoding", "UTF"));
            outParams.add(8, props.getProperty("MQ_Username", ""));
            outParams.add(9, props.getProperty("MQ_Password", ""));
        } else if (outType.equalsIgnoreCase("DATABASE")) {
            outParams.add(0, props.getProperty("DATABASE_URL", ""));
            outParams.add(1, props.getProperty("DATABASE_Driver", ""));
            outParams.add(2, props.getProperty("DATABASE_Username", "sa"));
            outParams.add(3, props.getProperty("DATABASE_Password", ""));
        }
        return outParams;
    }

    public Vector getPluginConfigParams(Properties props) {
        Vector<String> pluginParams = new Vector<String>();
        if (props.getProperty("FormatterFlag", "false").equalsIgnoreCase("true")) {
            pluginParams.add(0, props.getProperty("FormatterPlugin", ""));
        } else {
            pluginParams.add(0, "");
        }
        pluginParams.add(1, props.getProperty("SenderPlugin", ""));
        return pluginParams;
    }

    public RaStatus updateConnection(String connName, Properties connProps) throws RaException {
        RaStatus raStatus = new RaStatus(8, connName);
        try {
            this.checkName(connName);
            Properties props = this.getConfigProps(connName);
            Enumeration<?> enums = connProps.propertyNames();
            String propName = "";
            while (enums.hasMoreElements()) {
                propName = (String)enums.nextElement();
                props.setProperty(propName, connProps.getProperty(propName, ""));
            }
            this.saveConnection(connName, props);
            raStatus.setCode(0);
            _log.debug("RepraControlUtil.updateConnection.m1", (Object)connName, null);
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.updateConnection.m2", (Object)connName, (Throwable)ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.updateConnection.ms2"), ex);
        }
    }

    public RaStatus createConnection(String connName, Properties connProps, boolean override) throws RaException {
        String filename = this._configDir + File.separator + connName + ".props";
        RaStatus raStatus = new RaStatus(28, connName);
        try {
            String propFile;
            this.checkName(connName);
            File fptr = new File(filename);
            if (!override && fptr.exists()) {
                _log.error("RepraControlUtil.createConnection.m1", (Object)(connName + ":" + filename), null);
                raStatus.setCode(4);
                raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.createConnection.ms1"));
                return raStatus;
            }
            FileOutputStream fout = new FileOutputStream(filename);
            Properties encProps = RepraPropertyUtil.encProperties(connProps);
            int customStatus = 0;
            String ResultMessage = "";
            String outboundType = encProps.getProperty("OutboundType", "JMS");
            if (outboundType.equalsIgnoreCase("CUSTOM")) {
                propFile = encProps.getProperty("SenderProperties", "");
                _log.debug("RepraControlUtil.java - CUSTOM SENDER PROP FILE IS [" + propFile + "], it has a length of " + propFile.length());
                if (propFile.length() != 0 && !new File(propFile).exists()) {
                    ResultMessage = _log.getResourceBundle().getString("RepraControlUtil.createConnection.w1") + "\n" + connName + ":" + propFile;
                    _log.warn(ResultMessage);
                    customStatus = 2;
                    raStatus.setMessage(ResultMessage);
                    ResultMessage = ResultMessage + "\n";
                }
            }
            if (encProps.getProperty("FormatterFlag", "false").equalsIgnoreCase("true") && (propFile = encProps.getProperty("FormatterProperties", "")).length() != 0) {
                _log.debug("RepraControlUtil.java - FORMATTER PROP FILE IS [" + propFile + "], it has a length of " + propFile.length());
                if (!new File(propFile).exists()) {
                    _log.warn(_log.getResourceBundle().getString("RepraControlUtil.createConnection.w2"), connName + ":" + propFile);
                    customStatus = 2;
                    ResultMessage = ResultMessage + _log.getResourceBundle().getString("RepraControlUtil.createConnection.w2") + "\n" + connName + ":" + propFile;
                    _log.warn(ResultMessage);
                    raStatus.setMessage(ResultMessage);
                }
            }
            encProps.store(fout, BaseConst.FILE_WARNING);
            fout.close();
            raStatus.setCode(customStatus);
            _log.debug("RepraControlUtil.createConnection.m2", (Object)connName, null);
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.createConnection.m3", (Object)connName, (Throwable)ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.createConnection.ms3"), ex);
        }
    }

    public RaStatus copyConnection(String connName, String newConnName) throws RaException {
        RaStatus raStatus = new RaStatus(12, connName);
        try {
            this.checkName(connName);
            this.checkName(newConnName);
            if (!this.isConnection(connName)) {
                raStatus.setCode(4);
                raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.copyConnection.ms1"));
                _log.error("RepraControlUtil.copyConnection.m1", (Object)connName, null);
                return raStatus;
            }
            if (this.isConnection(newConnName)) {
                raStatus.setCode(4);
                raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.copyConnection.ms2"));
                _log.error("RepraControlUtil.copyConnection.m2", (Object)newConnName, null);
                return raStatus;
            }
            Properties props = this.getConfigProps(connName);
            props.setProperty("ConnectionName", newConnName);
            raStatus = this.createConnection(newConnName, props, false);
            raStatus.setCommand(12);
            raStatus.setCode(0);
            _log.debug("RepraControlUtil.copyConnection.m3", (Object)connName, (Object)newConnName, null);
            return raStatus;
        }
        catch (Exception ex) {
            _log.debug("RepraControlUtil.copyConnection.m4", (Object)connName, (Object)newConnName, ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.copyConnection.ms4"), ex);
        }
    }

    public RaStatus renameConnection(String connName, String newConnName) throws RaException {
        RaStatus raStatus = new RaStatus(11, connName);
        try {
            this.checkName(connName);
            this.checkName(newConnName);
            ConnectionContainer container = ConnectionContainer.getInstance();
            if (container.getControl(connName).equals("STARTING") || container.getControl(connName).equals("RUNNING")) {
                raStatus.setCode(4);
                _log.error("RepraControlUtil.renameConnection.m1", (Object)connName, null);
                raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.renameConnection.ms1"));
                return raStatus;
            }
            if (!this.isConnection(connName)) {
                raStatus.setCode(4);
                raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.renameConnection.ms2"));
                _log.error("RepraControlUtil.renameConnection.m2", (Object)connName, null);
                return raStatus;
            }
            if (this.isConnection(newConnName)) {
                raStatus.setCode(4);
                raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.renameConnection.ms3"));
                _log.error("RepraControlUtil.renameConnection.m3", (Object)newConnName, null);
                return raStatus;
            }
            Properties props = this.getConfigProps(connName);
            props.setProperty("ConnectionName", newConnName);
            if (this.saveConnection(newConnName, props)) {
                this.deleteConnection(connName);
                _log.debug("RepraControlUtil.renameConnection.m4", (Object)connName, (Object)newConnName, null);
                raStatus.setCode(0);
            } else {
                raStatus.setCode(4);
                raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.renameConnection.ms5"));
                if (this.isConnection(newConnName)) {
                    this.deleteConnection(newConnName);
                }
                _log.error("RepraControlUtil.renameConnection.m5", (Object)connName, (Object)newConnName, null);
            }
            return raStatus;
        }
        catch (Exception ex) {
            _log.debug("RepraControlUtil.renameConnection.m6", (Object)connName, (Object)newConnName, ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.renameConnection.m6"), ex);
        }
    }

    public void setConfigFile(String connName, Properties props) throws Exception {
        String filename = this._configDir + File.separator + connName + ".props";
        FileOutputStream fout = new FileOutputStream(filename);
        Properties encProps = RepraPropertyUtil.encProperties(props);
        encProps.store(fout, BaseConst.FILE_WARNING);
        fout.close();
    }

    public RaStatus deleteConnection(String connName) throws RaException {
        String filename = this._configDir + File.separator + connName + ".props";
        RaStatus raStatus = new RaStatus(9, connName);
        try {
            this.checkName(connName);
            if (!this.isConnection(connName)) {
                throw new Exception(_log.getResourceBundle().getString("RepraControlUtil.invalid_connection_name"));
            }
            ConnectionContainer container = ConnectionContainer.getInstance();
            if (container.getControl(connName).equals("STARTING") || container.getControl(connName).equals("RUNNING")) {
                raStatus.setCode(4);
                _log.error("RepraControlUtil.deleteConnection.m1");
                raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.deleteConnection.ms1"));
                return raStatus;
            }
            File fptr = new File(filename);
            if (fptr.exists()) {
                fptr.delete();
                raStatus.setCode(0);
                _log.debug("RepraControlUtil.deleteConnection.m2", (Object)connName, null);
            } else {
                raStatus.setCode(4);
                _log.error("RepraControlUtil.deleteConnection.m3", (Object)connName, null);
                raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.deleteConnection.ms3") + connName);
            }
            _configProps.remove(connName);
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.deleteConnection.m4", (Object)connName, (Throwable)ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.deleteConnection.ms4"), ex);
        }
    }

    public Vector deleteConnection() throws RaException {
        Vector<RaStatus> deleteVector = new Vector<RaStatus>();
        try {
            Vector conns = this.getConnectionNames();
            String connName = "";
            for (int ido = 0; ido < conns.size(); ++ido) {
                if (conns.elementAt(ido) == null || ((String)conns.elementAt(ido)).equals("")) continue;
                connName = (String)conns.elementAt(ido);
                RaStatus raStatus = new RaStatus(10, connName);
                try {
                    raStatus = this.deleteConnection(connName);
                }
                catch (RaException raEx) {
                    raStatus.setCode(4);
                    raStatus.setMessage(raEx.getMessage());
                }
                catch (Exception ex) {
                    raStatus.setCode(4);
                    raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.deleteConnection.ms4") + connName);
                    raStatus.appendMessage(ex.getMessage());
                }
                raStatus.setCommand(10);
                deleteVector.add(raStatus);
            }
            _log.debug("RepraControlUtil.deleteConnectionAll.m2", (Object)connName, null);
            return deleteVector;
        }
        catch (Exception anyex) {
            _log.error("RepraControlUtil.deleteConnectionAll.m4", null, (Throwable)anyex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.deleteConnectionAll.ms4"), anyex);
        }
    }

    public String[] getUserPass() {
        String[] userPass = new String[]{"", ""};
        try {
            String authFile = RepraPropertyUtil.getSecurityDir() + File.separator + "repralogin.key";
            Properties authProps = new Properties();
            authProps.load(new FileInputStream(authFile));
            String user = authProps.getProperty("loginuser", "");
            String pass = authProps.getProperty("loginpass", "");
            userPass[0] = user;
            userPass[1] = RepraPropertyUtil.decText(pass);
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.getUserPass.e1", (Throwable)ex);
        }
        return userPass;
    }

    public void setUserPass(String user, String pass) throws Exception {
        try {
            String authFile = RepraPropertyUtil.getSecurityDir() + File.separator + "repralogin.key";
            Properties authProps = new Properties();
            authProps.setProperty("loginuser", user);
            authProps.setProperty("loginpass", RepraPropertyUtil.encText(pass));
            authProps.store(new FileOutputStream(authFile), BaseConst.FILE_WARNING);
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.setUserPass.e1", (Throwable)ex);
            throw ex;
        }
    }

    public RaStatus getConnectionStatus() throws RaException {
        RaStatus raStatus = new RaStatus(16, "");
        try {
            Properties statusProps = new Properties();
            Vector connList = this.getConnectionNames();
            ConnectionContainer container = ConnectionContainer.getInstance();
            String connections = "";
            String elemName = "";
            String elemStatus = "";
            for (int ido = 0; ido < connList.size(); ++ido) {
                elemName = (String)connList.elementAt(ido);
                if (elemName == null || elemName.equals("")) continue;
                elemStatus = container.getControl(elemName);
                if (elemStatus == null || elemStatus.equals("")) {
                    elemStatus = "STOP";
                }
                statusProps.setProperty(elemName, elemStatus);
            }
            raStatus.setCode(0);
            raStatus.setReturnObject(statusProps);
            _log.debug("RepraControlUtil.getConnectionStatus.m1", null, null);
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.getConnectionStatus.m2", null, (Throwable)ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.getConnectionStatus.ms2"), ex);
        }
    }

    public RaStatus getConnectionStatus(String connName) throws RaException {
        RaStatus raStatus = new RaStatus(15, connName);
        try {
            this.checkName(connName);
            Properties statusProp = new Properties();
            if (this.isConnection(connName)) {
                ConnectionContainer container = ConnectionContainer.getInstance();
                String status = container.getControl(connName);
                if (status == null || status.equals("")) {
                    status = "STOP";
                }
                statusProp.setProperty(connName, status);
                raStatus.setCode(0);
                raStatus.setReturnObject(statusProp);
                _log.debug("RepraControlUtil.getConnectionStatus.m1", null, null);
            } else {
                raStatus.setCode(4);
                raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.getConnectionStatus.ms2"));
                _log.error("RepraControlUtil.getConnectionStatus.m2", (Object)connName, null);
            }
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.getConnectionStatus.m3", null, (Throwable)ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.getConnectionStatus.ms3"), ex);
        }
    }

    public RaStatus isRunning(String connName) throws RaException {
        RaStatus raStatus = new RaStatus(27, connName);
        try {
            this.checkName(connName);
            if (this.isConnection(connName)) {
                ConnectionContainer container = ConnectionContainer.getInstance();
                String status = container.getControl(connName);
                if (status == null || status.equals("")) {
                    status = "STOP";
                }
                if (status.equals("RUNNING")) {
                    raStatus.setReturnObject(new Boolean(true));
                } else {
                    raStatus.setReturnObject(new Boolean(false));
                }
                raStatus.setCode(0);
                _log.debug("RepraControlUtil.isRunning.m1", (Object)connName, (Object)status, null);
            } else {
                raStatus.setCode(4);
                raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.isRunning.ms2"));
                _log.error("RepraControlUtil.isRunning.m2", (Object)connName, null);
            }
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.isRunning.m3", (Object)connName, (Throwable)ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.isRunning.ms3"), ex);
        }
    }

    public RaStatus validateConnection(String connName) throws RaException {
        return this.validateConnection(connName, null);
    }

    public RaStatus validateConnection(String connName, Properties props) throws RaException {
        RaStatus raStatus = new RaStatus(13, connName);
        try {
            Properties connProps;
            this.checkName(connName);
            if (props == null) {
                if (!this.isConnection(connName) && props == null) {
                    _log.error("RepraControlUtil.validateConnection.m1", connName);
                    raStatus.setCode(4);
                    raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.validateConnection.ms1"));
                    return raStatus;
                }
                connProps = this.getConfigProps(connName);
            } else {
                connProps = props;
            }
            int retCode = this.validate(connProps);
            if (retCode == 0) {
                raStatus.setCode(0);
            } else {
                raStatus.setCode(4);
                if (retCode == 1) {
                    raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.validateConnection.ms2"));
                    _log.error("RepraControlUtil.validateConnection.m2", (Object)connName, null);
                } else if (retCode == 2) {
                    raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.validateConnection.ms3"));
                    _log.error("RepraControlUtil.validateConnection.m3", (Object)connName, null);
                } else if (retCode == 3) {
                    raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.validateConnection.ms4"));
                    _log.error("RepraControlUtil.validateConnection.m4", (Object)connName, null);
                } else if (retCode == 4) {
                    raStatus.setCode(2);
                    raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.createConnection.w1"));
                    _log.warn("RepraControlUtil.createConnection.w1");
                } else if (retCode == 5) {
                    raStatus.setCode(2);
                    raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.createConnection.w2"));
                    _log.warn("RepraControlUtil.createConnection.w2");
                } else if (retCode == 6) {
                    String ResultMessage = _log.getResourceBundle().getString("RepraControlUtil.createConnection.w1") + "\n" + _log.getResourceBundle().getString("RepraControlUtil.createConnection.w2");
                    _log.warn(ResultMessage);
                    raStatus.setCode(2);
                    raStatus.setMessage(ResultMessage);
                }
            }
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.validateConnection.m5", (Object)connName, (Throwable)ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.validateConnection.ms5"), ex);
        }
    }

    private int validate(Properties origProps) throws Exception {
        String propFile;
        String outType;
        Properties props;
        block15: {
            props = RepraPropertyUtil.decProperties(origProps);
            String inType = (String)props.get("InboundType");
            outType = (String)props.get("OutboundType");
            if (inType.equals("REPLICATION")) {
                try {
                    if (!this.pingRssd(props)) {
                        return 1;
                    }
                }
                catch (Exception ee) {
                    _log.error("RepraControlUtil.validateConnection.m6", ee.getMessage());
                    return 1;
                }
                try {
                    if (!this.pingMessageProvider(outType, props)) {
                        return 2;
                    }
                    break block15;
                }
                catch (Exception ee) {
                    _log.error("RepraControlUtil.validateConnection.m7", ee.getMessage());
                    return 2;
                }
            }
            try {
                if (!this.pingMessageProvider(inType, props)) {
                    return 1;
                }
            }
            catch (Exception ee) {
                _log.error("RepraControlUtil.validateConnection.m8", ee.getMessage());
                return 1;
            }
            try {
                if (!this.pingDb(props)) {
                    return 2;
                }
            }
            catch (Exception ee) {
                _log.error("RepraControlUtil.validateConnection.m9", ee.getMessage());
                return 2;
            }
        }
        int ReturnStatus = 0;
        if (outType.equals("CUSTOM") && (propFile = props.getProperty("SenderProperties", "")).length() != 0 && !new File(propFile).exists()) {
            ReturnStatus = 4;
        }
        if (props.getProperty("FormatterFlag", "false").equalsIgnoreCase("true") && (propFile = props.getProperty("FormatterProperties", "")).length() != 0 && !new File(propFile).exists()) {
            ReturnStatus = ReturnStatus == 4 ? 6 : 5;
        }
        return ReturnStatus;
    }

    private boolean pingMessageProvider(String type, Properties props) throws Exception {
        if (type.equals("JMS")) {
            return this.pingJms(props);
        }
        if (type.equals("TIBCO")) {
            return this.pingTibco(props);
        }
        if (type.equals("IBMMQ")) {
            return this.pingMq(props);
        }
        return type.equals("CUSTOM");
    }

    private boolean pingJms(Properties props) throws Exception {
        String destType = (String)props.get("JMSType");
        String url = (String)props.get("JMS_ProviderURL");
        String connFactory = (String)props.get("JMS_QCF");
        String initContext = (String)props.get("JMS_InitialContext");
        String userName = (String)props.get("JMS_Username");
        String password = (String)props.get("JMS_Password");
        String dest = (String)props.get("JMS_LocalQueue");
        String statusDest = (String)props.get("Status.Destination");
        return RepraPingUtil.pingJMS(_log, destType, url, connFactory, initContext, userName, password, dest, statusDest);
    }

    private boolean pingTibco(Properties props) throws Exception {
        String service = (String)props.get("RV_Service");
        String network = (String)props.get("RV_Network");
        String daemon = (String)props.get("RV_Daemon");
        return RepraPingUtil.pingTIBRV(_log, service, network, daemon);
    }

    private boolean pingMq(Properties props) throws Exception {
        String host = (String)props.get("MQ_Hostname");
        String port = (String)props.get("MQ_PortNumber");
        String channel = (String)props.get("MQ_Channel");
        String mgr = (String)props.get("MQ_QueueManager");
        String lqueue = (String)props.get("MQ_LocalQueue");
        String mqUser = (String)props.get("MQ_Username");
        String mqPass = (String)props.get("MQ_Password");
        String mqtype = (String)props.get("MQType");
        if (mqtype.equals("MQJMS")) {
            String localClient = props.getProperty("MQ_LocalClient", "false");
            return RepraPingUtil.pingIBMMQJMS(_log, host, port, channel, localClient, mgr, lqueue, mqUser, mqPass);
        }
        return RepraPingUtil.pingIBMMQ(_log, host, port, channel, mgr, lqueue, mqUser, mqPass);
    }

    private boolean pingDb(Properties props) throws Exception {
        String dbUrl = (String)props.get("DATABASE_URL");
        String dbDriver = (String)props.get("DATABASE_Driver");
        String dbUser = (String)props.get("DATABASE_Username");
        String dbPass = (String)props.get("DATABASE_Password");
        return RepraPingUtil.pingDB(_log, dbUrl, dbDriver, dbUser, dbPass);
    }

    private boolean pingRssd(Properties props) throws Exception {
        String rssdUrl = (String)props.get("RSSDURL");
        String rssdUser = (String)props.get("RSSDLogin");
        String rssdPass = (String)props.get("RSSDPassword");
        return RepraPingUtil.pingRSSD(_log, rssdUrl, rssdUser, rssdPass);
    }

    private boolean validate(String connName) throws Exception {
        Properties props = this.getConfigProps(connName);
        return this.validate(props) == 0;
    }

    private ConnectionFactory getConnectionFactory() throws Exception {
        try {
            InitialContext ctx = new InitialContext();
            ConnectionFactory cf = null;
            try {
                cf = (ConnectionFactory)ctx.lookup("eis/Sybase_RepConnector_MCF");
            }
            catch (Exception ex) {
                cf = (ConnectionFactory)ctx.lookup("Repra/Sybase_RepConnector_MCF");
            }
            _log.debug("RepraControlUtil.getConnectionFactory.m1");
            return cf;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.getConnectionFactory.m2", null, (Throwable)ex);
            throw ex;
        }
    }

    public RaStatus startConnection(String connName) throws RaException {
        RaStatus raStatus = new RaStatus(1, connName);
        try {
            block8: {
                this.checkName(connName);
                ConnectionContainer container = ConnectionContainer.getInstance();
                if (!this.isConnection(connName)) {
                    _log.error("RepraControlUtil.startConnection.m1", (Object)connName, null);
                    raStatus.setCode(4);
                    raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.startConnection.ms1"));
                    return raStatus;
                }
                if (container.getControl(connName).equals("RUNNING")) {
                    _log.warn("RepraControlUtil.startConnection.m2", (Object)connName, null);
                    raStatus.setCode(2);
                    raStatus.appendMessage(_log.getResourceBundle().getString("RepraControlUtil.startConnection.ms2"));
                    return raStatus;
                }
                if (container.getControl(connName).equals("STARTING")) {
                    _log.warn("RepraControlUtil.startConnection.m3", (Object)connName, null);
                    raStatus.setCode(2);
                    raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.startConnection.ms3"));
                    return raStatus;
                }
                Connection conn = null;
                ConnectionFactory cf = this.getConnectionFactory();
                Properties props = this.getConfigProps(connName);
                RepraConnectionSpec spec = new RepraConnectionSpec(props);
                try {
                    conn = cf.getConnection((ConnectionSpec)spec);
                    container.setConnection(connName, conn);
                }
                catch (ResourceException rex) {
                    _log.error("RepraControlUtil.startConnection.m6", (Throwable)rex);
                    throw rex;
                }
                catch (Exception cex) {
                    if (cex.getMessage().indexOf("cannot be overriden") > 0) break block8;
                    _log.error("RepraControlUtil.startConnection.m7", (Throwable)cex);
                    throw cex;
                }
            }
            raStatus.setCode(0);
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.startConnection.m5", (Object)connName, (Throwable)ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.startConnection.ms5"), ex);
        }
    }

    public RaStatus stopConnection(String connName) throws RaException {
        RaStatus raStatus = new RaStatus(3, connName);
        try {
            this.checkName(connName);
            ConnectionContainer container = ConnectionContainer.getInstance();
            if (!this.isConnection(connName)) {
                _log.error("RepraControlUtil.stopConnection.m1", (Object)connName, null);
                raStatus.setCode(4);
                raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.stopConnection.ms1"));
                return raStatus;
            }
            if (container.getControl(connName) == null || container.getControl(connName).equals("") || container.getControl(connName).equals("STOP")) {
                _log.warn("RepraControlUtil.stopConnection.m2", (Object)connName, null);
                raStatus.setCode(2);
                raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.stopConnection.ms2"));
                return raStatus;
            }
            Connection conn = container.getConnection(connName);
            try {
                if (conn != null) {
                    ((RepraConnection)conn).close();
                }
                container.removeConnection(connName);
            }
            catch (ResourceException rex) {
                _log.error("RepraControlUtil.stopConnection.m4", (Object)connName, (Throwable)rex);
                throw rex;
            }
            catch (Exception threadEx) {
                _log.error("RepraControlUtil.stopConnection.m4", (Object)connName, (Throwable)threadEx);
                throw threadEx;
            }
            _log.debug("RepraControlUtil.stopConnection.m3", (Object)connName, null);
            raStatus.setCode(0);
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.stopConnection.m4", (Object)connName, (Throwable)ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.stopConnection.m4"), ex);
        }
    }

    public RaStatus refreshConnection(String connName) throws RaException {
        RaStatus raStatus = new RaStatus(5, connName);
        try {
            RaStatus ctrlStatus;
            this.checkName(connName);
            if (_configProps.get(connName) != null) {
                _configProps.remove(connName);
            }
            if ((ctrlStatus = this.stopConnection(connName)).getCode() == 4) {
                _log.error("RepraControlUtil.refreshConnection.m1", (Object)connName, null);
                raStatus.setCode(ctrlStatus.getCode());
                raStatus.setMessage(ctrlStatus.getMessage());
                return raStatus;
            }
            if (ctrlStatus.getCode() == 2) {
                _log.error("RepraControlUtil.refreshConnection.m4", (Object)connName, null);
                raStatus.setCode(2);
                raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.refreshConnection.ms4"));
                return raStatus;
            }
            ctrlStatus = this.startConnection(connName);
            if (ctrlStatus.getCode() == 4) {
                _log.error("RepraControlUtil.refreshConnection.m2", (Object)connName, null);
                raStatus.setCode(ctrlStatus.getCode());
                raStatus.setMessage(ctrlStatus.getMessage());
                return raStatus;
            }
            _log.debug("RepraControlUtil.refreshConnection.m3", (Object)connName, null);
            raStatus.setCode(0);
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.refreshConnection.m4", (Object)connName, (Throwable)ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.refreshConnection.ms4"), ex);
        }
    }

    public Vector startConnection() throws RaException {
        Vector<RaStatus> statusVector = new Vector<RaStatus>();
        try {
            ConnectionContainer container = ConnectionContainer.getInstance();
            Vector conns = this.getConnectionNames();
            String connName = "";
            for (int ido = 0; ido < conns.size(); ++ido) {
                if (conns.elementAt(ido) == null || ((String)conns.elementAt(ido)).equals("") || container.getControl(connName = (String)conns.elementAt(ido)).equals("STARTING") || container.getControl(connName).equals("RUNNING")) continue;
                RaStatus raStatus = new RaStatus(2, connName);
                if (this.validate(connName)) {
                    try {
                        raStatus = this.startConnection(connName);
                        _log.debug("RepraControlUtil.startConnectionAll.m1", (Object)connName, null);
                    }
                    catch (Exception ex) {
                        raStatus.setCode(4);
                        raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.startConnection.ms5") + ex.getMessage());
                    }
                } else {
                    _log.warn("RepraControlUtil.startConnectionAll.m2", (Object)connName, null);
                    raStatus = new RaStatus(2, connName, 2, _log.getResourceBundle().getString("RepraControlUtil.startConnectionAll.ms2"));
                }
                raStatus.setCommand(2);
                statusVector.add(raStatus);
            }
            return statusVector;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.startConnectionAll.m3", null, (Throwable)ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.startConnectionAll.ms3"), ex);
        }
    }

    public Vector stopConnection() throws RaException {
        Vector<RaStatus> statusVector = new Vector<RaStatus>();
        try {
            ConnectionContainer container = ConnectionContainer.getInstance();
            Vector conns = this.getConnectionNames();
            String connName = "";
            for (int ido = 0; ido < conns.size(); ++ido) {
                if (conns.elementAt(ido) == null || ((String)conns.elementAt(ido)).equals("") || !container.getControl(connName = (String)conns.elementAt(ido)).equals("STARTING") && !container.getControl(connName).equals("RUNNING")) continue;
                RaStatus raStatus = new RaStatus(4, connName);
                try {
                    raStatus = this.stopConnection(connName);
                    _log.debug("RepraControlUtil.stopConnectionAll.m1", (Object)connName, null);
                }
                catch (Exception ex) {
                    raStatus.setCode(4);
                    raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.stopConnection.ms4"));
                }
                raStatus.setCommand(4);
                statusVector.add(raStatus);
            }
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.stopConnectionAll.m2", null, (Throwable)ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.stopConnectionAll.ms2"), ex);
        }
        return statusVector;
    }

    public Vector refreshConnection() throws RaException {
        Vector<RaStatus> refreshVector = new Vector<RaStatus>();
        try {
            ConnectionContainer container = ConnectionContainer.getInstance();
            Vector conns = this.getConnectionNames();
            String connName = "";
            for (int ido = 0; ido < conns.size(); ++ido) {
                if (conns.elementAt(ido) == null || ((String)conns.elementAt(ido)).equals("") || !container.getControl(connName = (String)conns.elementAt(ido)).equals("STARTING") && !container.getControl(connName).equals("RUNNING")) continue;
                RaStatus refreshStatus = new RaStatus(6, connName);
                RaStatus stopStatus = this.stopConnection(connName);
                RaStatus startStatus = null;
                if (stopStatus.getCode() != 4) {
                    startStatus = this.startConnection(connName);
                    if (startStatus.getCode() == 4) {
                        _log.error("RepraControlUtil.refreshConnectionAll.m1", (Object)connName, null);
                        refreshStatus.setCode(4);
                        refreshStatus.setMessage(startStatus.getMessage());
                    } else {
                        _log.debug("RepraControlUtil.refreshConnectionAll.m2", (Object)connName, null);
                        refreshStatus.setCode(0);
                    }
                } else {
                    _log.error("RepraControlUtil.refreshConnectionAll.m3", (Object)connName, null);
                    refreshStatus.setCode(4);
                    refreshStatus.setMessage(stopStatus.getMessage());
                }
                refreshStatus.setCommand(6);
                refreshVector.add(refreshStatus);
            }
            return refreshVector;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.refreshConnectionAll.m4", null, (Throwable)ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.refreshConnectionAll.ms4"), ex);
        }
    }

    public RaStatus getInboundTypes() throws RaException {
        try {
            RaStatus raStatus = new RaStatus(25, "");
            Vector<String> typeVector = new Vector<String>();
            for (int ido = 0; ido < RepraConst.INBOUND_LIST.length; ++ido) {
                typeVector.add(RepraConst.INBOUND_LIST[ido]);
            }
            raStatus.setCode(0);
            raStatus.setReturnObject(typeVector);
            _log.debug("RepraControlUtil.getInboundTypes.m1", null, null);
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.getInboundTypes.m2", null, (Throwable)ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.getInboundTypes.m2"), ex);
        }
    }

    public RaStatus getOutboundTypes() throws RaException {
        try {
            RaStatus raStatus = new RaStatus(26, "");
            Vector<String> typeVector = new Vector<String>();
            for (int ido = 0; ido < RepraConst.OUTBOUND_LIST.length; ++ido) {
                typeVector.add(RepraConst.OUTBOUND_LIST[ido]);
            }
            raStatus.setCode(0);
            raStatus.setReturnObject(typeVector);
            _log.debug("RepraControlUtil.getOutboundTypes.m1", null, null);
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.getOutboundTypes.m2", null, (Throwable)ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.getOutboundTypes.ms2"), ex);
        }
    }

    public RaStatus getInboundTypes(String outboundType) throws RaException {
        try {
            RaStatus raStatus = new RaStatus(25, "");
            Vector<String> typeVector = new Vector<String>();
            if (outboundType.equals("DATABASE")) {
                for (int ido = 0; ido < RepraConst.INBOUND_LIST.length; ++ido) {
                    if (RepraConst.INBOUND_LIST[ido].equals("REPLICATION")) continue;
                    typeVector.add(RepraConst.INBOUND_LIST[ido]);
                }
            } else if (outboundType.equals("JMS") || outboundType.equals("TIBCO") || outboundType.equals("IBMMQ") || outboundType.equals("CUSTOM")) {
                typeVector.add("REPLICATION");
            } else {
                raStatus.setCode(4);
                _log.error("RepraControlUtil.getInboundTypesByOutbound.m1", (Object)outboundType, null);
                raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.getInboundTypesByOutbound.ms1"));
                return raStatus;
            }
            raStatus.setCode(0);
            raStatus.setReturnObject(typeVector);
            _log.debug("RepraControlUtil.getInboundTypesByOutbound.m2", (Object)outboundType, null);
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.getInboundTypesByOutbound.m1", (Object)outboundType, (Throwable)ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.getInboundTypesByOutbound.ms1"), ex);
        }
    }

    public RaStatus getOutboundTypes(String inboundType) throws RaException {
        try {
            RaStatus raStatus = new RaStatus(26, "");
            Vector<String> typeVector = new Vector<String>();
            if (inboundType.equals("REPLICATION")) {
                for (int ido = 0; ido < RepraConst.OUTBOUND_LIST.length; ++ido) {
                    if (RepraConst.OUTBOUND_LIST[ido].equals("REPLICATION") || RepraConst.OUTBOUND_LIST[ido].equals("DATABASE")) continue;
                    typeVector.add(RepraConst.OUTBOUND_LIST[ido]);
                }
                raStatus.setReturnObject(typeVector);
            } else if (inboundType.equals("JMS") || inboundType.equals("TIBCO") || inboundType.equals("IBMMQ")) {
                raStatus.setCode(0);
                typeVector.add("DATABASE");
                raStatus.setReturnObject(typeVector);
            } else {
                raStatus.setCode(4);
                _log.error("RepraControlUtil.getOutboundTypesByInbound.m1", (Object)inboundType, null);
                raStatus.setMessage(_log.getResourceBundle().getString("RepraControlUtil.getOutboundTypesByInbound.ms1"));
                return raStatus;
            }
            raStatus.setReturnObject(typeVector);
            _log.debug("RepraControlUtil.getOutboundTypesByInbound.m2", (Object)inboundType, null);
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.getOutboundTypesByInbound.m1", (Object)inboundType, (Throwable)ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.getOutboundTypesByInbound.ms1"), ex);
        }
    }

    public RaStatus getGeneralParams(Properties props) throws RaException {
        String connName = props.getProperty("ConnectionName", "");
        RaStatus raStatus = new RaStatus(21, connName);
        try {
            this.checkName(connName);
            raStatus.setReturnObject(this.getGenConfigParams(props));
            raStatus.setCode(0);
            _log.debug("RepraControlUtil.getGenParams.m1", (Object)connName, null);
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.getGenParams.m2", (Object)connName, null);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.getGenParams.ms2"), ex);
        }
    }

    public RaStatus getInboundParams(Properties props) throws RaException {
        String connName = props.getProperty("ConnectionName", "");
        RaStatus raStatus = new RaStatus(22, connName);
        try {
            this.checkName(connName);
            raStatus.setReturnObject(this.getInboundConfigParams(props));
            raStatus.setCode(0);
            _log.debug("RepraControlUtil.getInboundParams.m1", (Object)connName, null);
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.getInboundParams.m2", (Object)connName, null);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.getInboundParams.ms2"), ex);
        }
    }

    public RaStatus getOutboundParams(Properties props) throws RaException {
        String connName = props.getProperty("ConnectionName", "");
        RaStatus raStatus = new RaStatus(23, connName);
        try {
            this.checkName(connName);
            raStatus.setReturnObject(this.getOutboundConfigParams(props));
            raStatus.setCode(0);
            _log.debug("RepraControlUtil.getOutboundParams.m1", (Object)connName, null);
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.getOutboundParams.m2", (Object)connName, null);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.getOutboundParams.ms2"), ex);
        }
    }

    public RaStatus getPluginParams(Properties props) throws RaException {
        String connName = props.getProperty("ConnectionName", "");
        RaStatus raStatus = new RaStatus(24, connName);
        try {
            this.checkName(connName);
            raStatus.setReturnObject(this.getPluginConfigParams(props));
            raStatus.setCode(0);
            _log.debug("RepraControlUtil.getPluginParams.m1", (Object)connName, null);
            return raStatus;
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.getPluginParams.m2", (Object)connName, (Throwable)ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.getPluginParams.ms2"), ex);
        }
    }

    public RaStatus getLogInfo(String connName, int startLine, int endLine) throws RaException {
        RaStatus raStatus = new RaStatus(17, connName);
        try {
            this.checkName(connName);
            String filename = RepraPropertyUtil.getRepraDir() + File.separator + "logs" + File.separator + "repra.log";
            LogViewer view = new LogViewer();
            if (startLine != 0) {
                view.setStartLine(startLine);
            }
            if (endLine != 0) {
                view.setEndLine(endLine);
            }
            view.setFileName(filename);
            try {
                StringBuffer sb = view.getLog(connName);
                raStatus.setReturnObject(sb);
                raStatus.setCode(0);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            _log.error("RepraControlUtil.getLogInfo.m2", (Object)connName, (Throwable)ex);
            throw new RaException(_log.getResourceBundle().getString("RepraControlUtil.getLogInfo.ms2"), ex);
        }
        return raStatus;
    }

    public RaStatus getLogInfo(String connName) throws RaException {
        return this.getLogInfo(connName, 0, 0);
    }

    public RaStatus getLogInfo(String connName, int size) throws RaException {
        throw new RaException("This method is not implemented yet.");
    }

    public boolean checkName(String name) throws Exception {
        if (name == null || name.equals("")) {
            throw new Exception(_log.getResourceBundle().getString("RepraControlUtil.invalid_connection_name"));
        }
        return true;
    }

    public Vector ping(String connName, String type, Properties props) throws RaException {
        Vector<RaStatus> retStatus = new Vector<RaStatus>();
        try {
            _log.debug("Pinging: " + connName + ":" + type, null, null);
            if (props == null) {
                props = this.getConfigProps(connName);
            }
            _log.debug("Pinging: " + connName + ":" + type + ":" + RepraPropertyUtil.encProperties(props).toString(), null, null);
            if (type.equals("INBOUND")) {
                type = (String)props.get("InboundType");
            } else if (type.equals("OUTBOUND")) {
                type = (String)props.get("OutboundType");
            }
            int pingType = (Integer)_pingTypeMap.get(type);
            boolean result = false;
            switch (pingType) {
                case 105: {
                    _log.debug("Pinging JMS Connection", null, null);
                    result = this.pingJms(props);
                    retStatus.addElement(this.handleResult(connName, type, result));
                    return retStatus;
                }
                case 103: {
                    _log.debug("Pinging DB Connection", null, null);
                    result = this.pingDb(props);
                    retStatus.addElement(this.handleResult(connName, type, result));
                    return retStatus;
                }
                case 104: {
                    _log.debug("Pinging RSSD Connection", null, null);
                    result = this.pingRssd(props);
                    retStatus.addElement(this.handleResult(connName, type, result));
                    return retStatus;
                }
                case 106: {
                    _log.debug("Pinging TIBCO Connection", null, null);
                    result = this.pingTibco(props);
                    retStatus.addElement(this.handleResult(connName, type, result));
                    return retStatus;
                }
                case 108: {
                    _log.debug("Pinging MQ Connection", null, null);
                    result = this.pingMq(props);
                    retStatus.addElement(this.handleResult(connName, type, result));
                    return retStatus;
                }
                case 100: {
                    _log.debug("RepracontrolUtil.ping.all.debug.1", null, null);
                    Vector retResult = this.pingAll(connName, props);
                    return retResult;
                }
            }
            retStatus.addElement(this.handleResult(connName, type, false));
            return retStatus;
        }
        catch (Throwable ex) {
            RaStatus status = new RaStatus(29, connName);
            status.setCode(4);
            status.setMessage(ex.toString());
            _log.error("RepraControlUtil.ping.m1", (Object)connName, ex);
            retStatus.addElement(status);
            return retStatus;
        }
    }

    private Vector pingAll(String connName, Properties props) throws Exception {
        String inbound = (String)props.get("InboundType");
        String outbound = (String)props.get("OutboundType");
        boolean result = false;
        Vector<RaStatus> retStatus = new Vector<RaStatus>();
        if (inbound.equals("REPLICATION")) {
            RaStatus status;
            try {
                result = this.pingRssd(props);
                status = this.handleResult(connName, inbound, result);
            }
            catch (Throwable ex) {
                status = new RaStatus(29, connName);
                status.setCode(4);
                status.setMessage(ex.toString());
            }
            retStatus.addElement(status);
            try {
                result = this.pingDest(outbound, props);
                status = this.handleResult(connName, outbound, result);
            }
            catch (Throwable ex) {
                status = new RaStatus(29, connName);
                status.setCode(4);
                status.setMessage(ex.toString());
            }
            retStatus.addElement(status);
        } else {
            RaStatus status;
            try {
                result = this.pingDest(inbound, props);
                status = this.handleResult(connName, inbound, result);
            }
            catch (Throwable ex) {
                status = new RaStatus(29, connName);
                status.setCode(4);
                status.setMessage(ex.toString());
            }
            retStatus.addElement(status);
            try {
                result = this.pingDb(props);
                status = this.handleResult(connName, inbound, result);
            }
            catch (Throwable ex) {
                status = new RaStatus(29, connName);
                status.setCode(4);
                status.setMessage(ex.toString());
            }
            retStatus.addElement(status);
        }
        return retStatus;
    }

    private boolean pingDest(String dest, Properties props) throws Exception {
        boolean result = false;
        if (dest.equals("JMS")) {
            result = this.pingJms(props);
        } else if (dest.equals("TIBCO")) {
            result = this.pingTibco(props);
        } else if (dest.equals("IBMMQ")) {
            result = this.pingMq(props);
        }
        return result;
    }

    public Vector ping(String connName, String type) throws RaException {
        return this.ping(connName, type, null);
    }

    private RaStatus handleResult(String connName, String type, boolean result) {
        RaStatus status = new RaStatus(29, connName);
        if (result) {
            status.setCode(0);
            status.setMessage("Ping:" + type + " succeed");
        } else {
            status.setCode(4);
            status.setMessage(_log.getResourceBundle().getString("RepraControlUtil.ping.ms1"));
            _log.error("RepraControlUtil.ping.m1", (Object)connName, null);
        }
        return status;
    }

    static {
        if (_log == null) {
            _log = new RaLogger(0);
        }
        _pingTypeMap = new Hashtable();
        _pingTypeMap.put("ALL", new Integer(100));
        _pingTypeMap.put("INBOUND", new Integer(101));
        _pingTypeMap.put("OUTBOUND", new Integer(102));
        _pingTypeMap.put("JMS", new Integer(105));
        _pingTypeMap.put("TIBCO", new Integer(106));
        _pingTypeMap.put("IBMMQ", new Integer(108));
        _pingTypeMap.put("DATABASE", new Integer(103));
        _pingTypeMap.put("REPLICATION", new Integer(104));
        _configProps = new Hashtable();
    }
}

