/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.util;

import com.sybase.connector.repra.RepraConst;
import com.sybase.connector.repra.util.RepraCipherUtil2;
import com.sybase.connector.repra.util.RepraControlUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class RepraPropertyUtil {
    private static final String[] passKeys = new String[]{"loginpass", "RepAdapterPassword", "RSSDPassword", "JMS_Password", "MQ_Password", "DATABASE_Password"};
    public static final String IN_JAGUAR_SERVER = "IN_JAGUAR_SERVER";
    public static final String WEBLOGIC_SERVER = "WEBLOGIC";

    public static String getServerType() {
        String serverType = "JAGUAR";
        String inJaguar = System.getProperties().getProperty(IN_JAGUAR_SERVER, "false");
        if (inJaguar.equals("true")) {
            return "JAGUAR";
        }
        if (!System.getProperties().getProperty("bea.repra.home", "").equals("")) {
            return WEBLOGIC_SERVER;
        }
        return "JAGUAR";
    }

    public static String getConfigProperty(String configFile, String keyName) {
        String filePath = RepraPropertyUtil.getConfigPath(configFile);
        Properties props = new Properties();
        try {
            FileInputStream fin = new FileInputStream(filePath);
            props.load(fin);
            fin.close();
            Properties decProps = RepraPropertyUtil.decProperties(props);
            return decProps.getProperty(keyName, null);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Properties getProperties(String configFile) {
        String filePath = RepraPropertyUtil.getConfigPath(configFile);
        Properties props = new Properties();
        try {
            FileInputStream fin = new FileInputStream(filePath);
            props.load(fin);
            fin.close();
            Properties decProps = RepraPropertyUtil.decProperties(props);
            return decProps;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getConfigPath(String configFile) {
        String filePath = RepraPropertyUtil.getConfigDir() + File.separator + configFile + ".props";
        return filePath;
    }

    public static String getConfigDir() {
        String fileDir = RepraPropertyUtil.getRepraDir() + File.separator + "conf";
        return fileDir;
    }

    public static String getSecurityDir() {
        String fileDir = RepraPropertyUtil.getRepraDir() + File.separator + "security";
        return fileDir;
    }

    public static String getSerDir() {
        String fileDir = RepraPropertyUtil.getRepraDir() + File.separator + "sers";
        return fileDir;
    }

    public static String getRepraDir() {
        String fileDir = ".";
        if (RepraPropertyUtil.getServerType().equals("JAGUAR")) {
            fileDir = System.getProperty("JAGUAR", "");
            if (fileDir != null && !fileDir.equals("")) {
                fileDir = fileDir + File.separator + "repra";
            }
        } else if (RepraPropertyUtil.getServerType().equals(WEBLOGIC_SERVER)) {
            fileDir = System.getProperty("bea.repra.home", "");
        }
        return fileDir;
    }

    public static String dropQuote(String instr) {
        if (instr == null || instr.equals("")) {
            return instr;
        }
        if (instr.startsWith("\"") && instr.endsWith("\"") || instr.startsWith("'") && instr.endsWith("'")) {
            String naked = instr.substring(1, instr.length() - 1);
            return naked;
        }
        return instr;
    }

    public static Properties encProperties(Properties plainProps) throws Exception {
        Properties props = new Properties();
        Enumeration<?> enums = plainProps.propertyNames();
        String name = "";
        while (enums.hasMoreElements()) {
            name = (String)enums.nextElement();
            props.setProperty(name, plainProps.getProperty(name));
        }
        String plainPassword = "";
        for (int ido = 0; ido < passKeys.length; ++ido) {
            if (!props.containsKey(passKeys[ido])) continue;
            plainPassword = props.getProperty(passKeys[ido], "");
            props.setProperty(passKeys[ido], RepraCipherUtil2.encrypt_ascii_pwd(plainPassword));
        }
        return props;
    }

    public static Properties decProperties(Properties encProps) throws Exception {
        Properties props = new Properties();
        Enumeration<?> enums = encProps.propertyNames();
        String name = "";
        while (enums.hasMoreElements()) {
            name = (String)enums.nextElement();
            props.setProperty(name, encProps.getProperty(name));
        }
        String encPassword = "";
        for (int ido = 0; ido < passKeys.length; ++ido) {
            if (!props.containsKey(passKeys[ido])) continue;
            encPassword = props.getProperty(passKeys[ido], "");
            props.setProperty(passKeys[ido], RepraCipherUtil2.decrypt_ascii_pwd(encPassword));
        }
        return props;
    }

    public static String encText(String plainPass) throws Exception {
        String encPassword = RepraCipherUtil2.encrypt_ascii_pwd(plainPass);
        return encPassword;
    }

    public static String decText(String cipherPass) throws Exception {
        String plainPass = RepraCipherUtil2.decrypt_ascii_pwd(cipherPass);
        return plainPass;
    }

    public static void decryptAll() throws Exception {
        RepraControlUtil controlUtil = new RepraControlUtil();
        Vector connNames = controlUtil.getConnectionNames();
        FileInputStream fin = null;
        FileOutputStream fout = null;
        Properties oldProps = null;
        Properties newProps = null;
        String propName = "";
        String confFile = "";
        for (int ido = 0; ido < connNames.size(); ++ido) {
            confFile = RepraPropertyUtil.getConfigPath((String)connNames.elementAt(ido));
            fin = new FileInputStream(confFile);
            oldProps = new Properties();
            oldProps.load(fin);
            fin.close();
            fout = new FileOutputStream(confFile);
            newProps = RepraPropertyUtil.decProperties(oldProps);
            newProps.store(fout, RepraConst.FILE_WARNING);
            fout.close();
        }
        confFile = RepraPropertyUtil.getSecurityDir() + File.separator + "repralogin.key";
        fin = new FileInputStream(confFile);
        oldProps = new Properties();
        oldProps.load(fin);
        fin.close();
        fout = new FileOutputStream(confFile);
        newProps = RepraPropertyUtil.decProperties(oldProps);
        newProps.store(fout, RepraConst.FILE_WARNING);
        fout.close();
    }

    public static void encryptAll() throws Exception {
        RepraControlUtil controlUtil = new RepraControlUtil();
        Vector connNames = controlUtil.getConnectionNames();
        FileInputStream fin = null;
        FileOutputStream fout = null;
        Properties oldProps = null;
        Properties newProps = null;
        String propName = "";
        String confFile = "";
        for (int ido = 0; ido < connNames.size(); ++ido) {
            confFile = RepraPropertyUtil.getConfigPath((String)connNames.elementAt(ido));
            fin = new FileInputStream(confFile);
            oldProps = new Properties();
            oldProps.load(fin);
            fin.close();
            fout = new FileOutputStream(confFile);
            newProps = RepraPropertyUtil.encProperties(oldProps);
            newProps.store(fout, RepraConst.FILE_WARNING);
            fout.close();
        }
        confFile = RepraPropertyUtil.getSecurityDir() + File.separator + "repralogin.key";
        fin = new FileInputStream(confFile);
        oldProps = new Properties();
        oldProps.load(fin);
        fin.close();
        fout = new FileOutputStream(confFile);
        newProps = RepraPropertyUtil.encProperties(oldProps);
        newProps.store(fout, RepraConst.FILE_WARNING);
        fout.close();
    }
}

