/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.util;

import com.sybase.connector.repra.RepraDataTypes;
import com.sybase.connector.repra.util.Cell;
import com.sybase.connector.repra.util.CellGroup;
import com.sybase.connector.repra.util.DBEventParser;
import com.sybase.connector.repra.util.OldValues;
import java.io.ByteArrayInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class XMLParseUtil
implements DBEventParser {
    private static final int DBEVENT_TAG = 0;
    private static final int PROCEXEC_TAG = 1;
    private static final int DBTRANSACTION_TAG = 2;
    private static final String XPATH_ALL_ELEMS = "./*";
    private static final String XPATH_ALL_CELLS = "//cell";
    private static final String XPATH_ALL_DATA_CELLS = "./values/cell | ./inValues/cell";
    private static final String XPATH_ALL_KEY_CELLS = "./oldValues/cell";
    private static final String XPATH_ALL_KEY_CELLGROUPS = "./oldValues/cellgroup";
    private static final String ATTR_ENVIRONMENT = "environment";
    private static final String ELEM_DBEVENT = "dbEvent";
    private static final String ELEM_DBTRANSACTION = "tran";
    private static final String ELEM_PROCEXEC = "exec";
    private static final String ATTR_EVENTID = "eventId";
    private static final String ATTR_SCHEMA = "schema";
    private static final String ATTR_OWNER = "owner";
    private static final String ELEM_DELETE = "delete";
    private static final String ELEM_INSERT = "insert";
    private static final String ELEM_UPDATE = "update";
    private static final String ELEM_VALUES = "values";
    private static final String ELEM_OLDVALUES = "oldValues";
    private static final String ELEM_INVALUES = "inValues";
    private static final String ELEM_CELL = "cell";
    private static final String ATTR_COLNAME = "name";
    private static final String ATTR_COLTYPE = "type";
    private static final String ATTR_CONDITION = "condition";
    private static final String ATTR_OPERATOR = "operator";
    private static final String EXEC_STR = "exec ";
    private static final String INSERT_STR = "insert into ";
    private static final String DELETE_STR = "delete from ";
    private static final String UPDATE_STR = "update ";
    private static final String VALUES_STR = " values ";
    private static final String SET_STR = " set ";
    private static final String LEFT_PAREN_STR = "(";
    private static final String RIGHT_PAREN_STR = ")";
    private static final String EQUAL_STR = "=";
    private static final String WHERE_STR = " where ";
    private static final String AND_STR = " and ";
    private static final String NEWLINE = "\n";
    private static final String AT_CHAR = "@";
    private static final String COMMA = ",";
    private static final String SPACE = " ";
    private static final String DT_PATTERN = "yyyyMMdd HH:mm:ss:SSS";
    private static final String DT_NOMS_PATTERN = "yyyyMMdd HH:mm:ss";
    private static final String ORA_DATETIME_PATTERN = "yyyymmdd HH24:MI:SS";
    private static final String ORA_DATE_PATTERN = "yyyymmdd";
    private static final String ORA_DEFAULT_DATE = "47120101";
    private static final SimpleDateFormat DT_FORMAT = new SimpleDateFormat("yyyyMMdd HH:mm:ss:SSS");
    private static final SimpleDateFormat DT_NOMS_FORMAT = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
    private static final String ORA_TO_DATE_COMMAND = "to_date";
    private String _xmlString;
    private SAXReader _reader = new SAXReader();
    private Document _document = null;
    private Element _docRoot = null;
    private Element _topElem = null;
    private int _topElemType;
    private String _dsName;
    private String _dbName;
    private String _eventId;
    private String _dsiConnName = null;
    private int _count = 0;
    private boolean _validate = false;
    private Logger _log = null;
    private int _databaseType = 0;
    private ResourceBundle _bundle = ResourceBundle.getBundle("com.sybase.connector.repra.RepraBundle");

    XMLParseUtil() {
    }

    XMLParseUtil(Object src) throws Exception {
        this.setSource(src);
    }

    public void setDatabaseType(int databaseType) {
        this._databaseType = databaseType;
    }

    public int getDatabaseType() {
        return this._databaseType;
    }

    public void setLogger(Logger log) {
        this._log = log;
    }

    public void validate(boolean value) {
        this._validate = value;
    }

    public void setSource(Object src) throws Exception {
        if (src instanceof String) {
            this._xmlString = (String)src;
            SAXReader reader = new SAXReader(this._validate);
            byte[] doc = this._xmlString.getBytes();
            ByteArrayInputStream bs = new ByteArrayInputStream(doc);
            InputSource ins = new InputSource(bs);
            Document document = DocumentHelper.parseText((String)this._xmlString);
            this._docRoot = document.getRootElement();
            if (this._docRoot == null) {
                throw new Exception(this._bundle.getString("XMLParseUtil.setSource.noRootElemen"));
            }
            List elems = this._docRoot.elements();
            for (Element elem : elems) {
                if (elem.getQualifiedName().equals(ELEM_DBEVENT)) {
                    this._topElemType = 0;
                } else if (elem.getQualifiedName().equals(ELEM_PROCEXEC)) {
                    this._topElemType = 1;
                } else if (elem.getQualifiedName().equals(ELEM_DBTRANSACTION)) {
                    this._topElemType = 2;
                }
                this._topElem = elem;
            }
        } else {
            throw new Exception(this._bundle.getString("XMLParseUtil.setSource.noSupportedSource"));
        }
    }

    public int size() {
        List tranList;
        int numberOfEvents = 1;
        if (this._topElemType != 1 && (tranList = this.getAllChildren(this._topElem)) != null) {
            numberOfEvents = tranList.size();
        }
        return numberOfEvents;
    }

    public String getDSName() throws Exception {
        int strIndex;
        String dsName = null;
        if (this._dsiConnName == null) {
            this._dsiConnName = this._docRoot.attributeValue(ATTR_ENVIRONMENT);
            if (this._dsiConnName == null) {
                throw new Exception(this._bundle.getString("XMLParseUtil.setSource.noDSName"));
            }
        }
        if ((strIndex = this._dsiConnName.indexOf(".")) != -1) {
            dsName = this._dsiConnName.substring(0, strIndex);
        }
        if (dsName == null) {
            throw new Exception(this._bundle.getString("XMLParseUtil.setSource.noDSName"));
        }
        return dsName;
    }

    public String getDBName() throws Exception {
        int strIndex;
        String dbName = null;
        if (this._dsiConnName == null) {
            this._dsiConnName = this._docRoot.attributeValue(ATTR_ENVIRONMENT);
            if (this._dsiConnName == null) {
                throw new Exception(this._bundle.getString("XMLParseUtil.setSource.noAttribute") + "'" + ATTR_ENVIRONMENT + "'.");
            }
        }
        if ((strIndex = this._dsiConnName.indexOf(".")) != 1) {
            dbName = this._dsiConnName.substring(this._dsiConnName.indexOf(".") + 1, this._dsiConnName.length());
        }
        if (dbName == null) {
            throw new Exception(this._bundle.getString("XMLParseUtil.setSource.noDSName"));
        }
        return dbName;
    }

    public String getEventId() throws Exception {
        this._eventId = this._topElem.attributeValue(ATTR_EVENTID);
        if (this._eventId == null) {
            throw new Exception(this._bundle.getString("XMLParseUtil.setSource.noEventid"));
        }
        return this._eventId;
    }

    public String getStatement() throws Exception {
        StringBuffer stmtBuffer = new StringBuffer();
        if (this._topElemType == 1) {
            stmtBuffer.append(this.getStatement(0));
        } else {
            for (int i = 0; i < this.size(); ++i) {
                stmtBuffer.append(this.getStatement(i));
                if (i >= this.size() - 1) continue;
                stmtBuffer.append(NEWLINE);
            }
        }
        return stmtBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getOperation(int elemAt) throws Exception {
        String opName = null;
        if (this._topElemType == 1) {
            return ELEM_PROCEXEC;
        }
        List elemList = this.getAllChildren(this._topElem);
        if (elemList == null) throw new Exception(this._bundle.getString("XMLParseUtil.setSource.noOperation"));
        if (elemList.size() <= 0) throw new Exception(this._bundle.getString("XMLParseUtil.setSource.noOperation"));
        if (elemAt >= elemList.size()) throw new Exception(this._bundle.getString("XMLParseUtil.setSource.noOperationAtIndex") + String.valueOf(elemAt));
        Element elem = (Element)elemList.get(elemAt);
        if (elem == null) return opName;
        return elem.getQualifiedName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getSchemaName(int elemAt) throws Exception {
        String name = null;
        if (this._topElemType == 1 && elemAt == 0) {
            return this._topElem.attributeValue(ATTR_SCHEMA);
        }
        List elemList = this.getAllChildren(this._topElem);
        if (elemList == null) throw new Exception(this._bundle.getString("XMLParseUtil.setSource.noName"));
        if (elemList.size() <= 0) throw new Exception(this._bundle.getString("XMLParseUtil.setSource.noName"));
        if (elemAt >= elemList.size()) throw new Exception("Unable to obtain name at index " + String.valueOf(elemAt));
        Element elem = (Element)elemList.get(elemAt);
        if (elem == null) return name;
        return elem.attributeValue(ATTR_SCHEMA);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getOwner(int elemAt) throws Exception {
        String owner = null;
        if (this._topElemType == 1 && elemAt == 0) {
            return this._topElem.attributeValue(ATTR_OWNER);
        }
        List elemList = this.getAllChildren(this._topElem);
        if (elemList == null) throw new Exception(this._bundle.getString("XMLParseUtil.setSource.noOwner"));
        if (elemList.size() <= 0) throw new Exception(this._bundle.getString("XMLParseUtil.setSource.noOwner"));
        if (elemAt >= elemList.size()) throw new Exception("Unable to obtain owner at index " + String.valueOf(elemAt));
        Element elem = (Element)elemList.get(elemAt);
        if (elem == null) return owner;
        return elem.attributeValue(ATTR_OWNER);
    }

    public Vector getData(int elemAt) throws Exception {
        Vector data = new Vector();
        int cellElemSize = 0;
        List cellElemList = null;
        Object groupElemList = null;
        if (this._topElemType == 1) {
            cellElemList = this.getAllChildren(this._topElem, XPATH_ALL_CELLS);
            if (cellElemList == null || (cellElemSize = cellElemList.size()) == 0) {
                throw new Exception(this._bundle.getString("XMLParseUtil.setSource.noItems"));
            }
        } else {
            List opElemList = this.getAllChildren(this._topElem);
            if (opElemList != null && opElemList.size() > 0) {
                cellElemList = this.getAllChildren((Element)opElemList.get(elemAt), XPATH_ALL_DATA_CELLS);
            }
        }
        if (cellElemList != null && cellElemList.size() > 0) {
            data = this.storeInTable(cellElemList);
        }
        return data;
    }

    public Vector getKeys(int elemAt) throws Exception {
        List cellElemList;
        List opElemList;
        Vector keys = new Vector();
        if (this._topElemType != 1 && (opElemList = this.getAllChildren(this._topElem)) != null && opElemList.size() > 0 && (cellElemList = this.getAllChildren((Element)opElemList.get(elemAt), XPATH_ALL_KEY_CELLS)) != null && cellElemList.size() > 0) {
            keys = this.storeInTable(cellElemList);
        }
        return keys;
    }

    public List getGroups(int elemAt) throws Exception {
        List cgElemList;
        List opElemList;
        ArrayList<CellGroup> groups = new ArrayList<CellGroup>();
        if (this._topElemType != 1 && (opElemList = this.getAllChildren(this._topElem)) != null && opElemList.size() > 0 && (cgElemList = this.getAllChildren((Element)opElemList.get(elemAt), XPATH_ALL_KEY_CELLGROUPS)) != null && cgElemList.size() > 0) {
            Iterator it = cgElemList.iterator();
            while (it.hasNext()) {
                CellGroup cg = new CellGroup();
                Element cgElem = (Element)it.next();
                cg.setCondition(cgElem.attributeValue(ATTR_CONDITION));
                cg.setOperator(cgElem.attributeValue(ATTR_OPERATOR));
                List cellElems = cgElem.elements();
                Vector cells = this.storeInTable(cellElems);
                cg.setCells(cells);
                groups.add(cg);
            }
        }
        return groups;
    }

    public String getStatement(int elemAt) throws Exception {
        Vector dataV;
        String operation;
        String schemaName;
        StringBuffer stmtBuffer = new StringBuffer();
        String owner = null;
        List cellGroup = new ArrayList();
        OldValues oldValue = new OldValues();
        if (this._topElemType == 1) {
            schemaName = this.getSchemaName(0);
            owner = this.getOwner(0);
            operation = this.getOperation(0);
            dataV = this.getData(0);
            Vector keyV = this.getKeys(0);
        } else {
            schemaName = this.getSchemaName(elemAt);
            owner = this.getOwner(elemAt);
            operation = this.getOperation(elemAt);
            dataV = this.getData(elemAt);
            Vector keyV = this.getKeys(elemAt);
            cellGroup = this.getGroups(elemAt);
            oldValue.setCellGroup(cellGroup);
            oldValue.setCell(keyV);
        }
        if (owner != null && !owner.equals("")) {
            schemaName = owner + "." + schemaName;
        }
        if (operation.equals(ELEM_PROCEXEC)) {
            stmtBuffer.append(EXEC_STR + schemaName + SPACE);
            stmtBuffer.append(this.constructExecData(dataV));
        } else if (operation.equals(ELEM_INSERT)) {
            stmtBuffer.append(INSERT_STR + schemaName + SPACE);
            stmtBuffer.append(this.constructInsertData(dataV));
        } else if (operation.equals(ELEM_UPDATE)) {
            stmtBuffer.append(UPDATE_STR + schemaName + SET_STR);
            stmtBuffer.append(this.constructUpdateData(dataV));
            stmtBuffer.append(this.constructWhereData(oldValue));
        } else if (operation.equals(ELEM_DELETE)) {
            stmtBuffer.append(DELETE_STR + schemaName + SPACE);
            stmtBuffer.append(this.constructWhereData(oldValue));
        }
        return stmtBuffer.toString();
    }

    public String getFieldName(Hashtable field) {
        return (String)field.get("FieldName");
    }

    public int getFieldType(Hashtable field) {
        return (Integer)field.get("FieldType");
    }

    public String getFieldTypeString(Hashtable field) {
        return (String)RepraDataTypes.DATATYPE_STRINGS.get(new Integer(this.getFieldType(field)));
    }

    public Object getFieldValue(Hashtable field) {
        return field.get("FieldValue");
    }

    public String getFieldCondition(Hashtable field) {
        return (String)field.get(ATTR_CONDITION);
    }

    public String getFieldOperator(Hashtable field) {
        return (String)field.get(ATTR_OPERATOR);
    }

    public String toXMLText(String dtdURL) throws Exception {
        return this._xmlString;
    }

    private static int getType(String type) {
        Integer i = (Integer)RepraDataTypes.DATATYPE_INTS.get(type);
        if (i == null) {
            return -1;
        }
        return i;
    }

    private Vector storeInTable(List cellElemList) {
        Vector<Cell> data = new Vector<Cell>();
        for (Element cellElem : cellElemList) {
            Cell field = new Cell();
            String fieldName = cellElem.attributeValue(ATTR_COLNAME);
            String fieldType = cellElem.attributeValue(ATTR_COLTYPE);
            String operator = cellElem.attributeValue(ATTR_OPERATOR);
            String condition = cellElem.attributeValue(ATTR_CONDITION);
            String fieldValue = cellElem.getText();
            int fieldTypeCode = XMLParseUtil.getType(fieldType);
            field.setName(fieldName);
            field.setType(new Integer(fieldTypeCode));
            field.setValue(fieldValue);
            field.setOperator(operator);
            field.setCondition(condition);
            data.add(field);
        }
        return data;
    }

    private Object getObjectFieldValue(int fieldType, String fieldValue) {
        switch (fieldType) {
            case 6: 
            case 7: 
            case 8: {
                return new Integer(fieldValue);
            }
            case 1: 
            case 5: 
            case 19: {
                return new ByteArrayInputStream(new String(fieldValue).getBytes());
            }
            case 9: {
                return new Double(fieldValue);
            }
            case 10: {
                return new Float(fieldValue);
            }
            case 11: {
                return new Boolean(fieldValue);
            }
        }
        return fieldValue;
    }

    private List getAllChildren(Element elem) {
        return elem.selectNodes(XPATH_ALL_ELEMS);
    }

    private List getAllChildren(Element elem, String pattern) {
        return elem.selectNodes(pattern);
    }

    private String constructInsertData(Vector dataV) {
        StringBuffer stmtBufferColName = new StringBuffer();
        StringBuffer stmtBufferColVal = new StringBuffer();
        stmtBufferColName.append(LEFT_PAREN_STR);
        stmtBufferColVal.append(LEFT_PAREN_STR);
        if (dataV != null) {
            for (int ido = 0; ido < dataV.size(); ++ido) {
                Cell dataH = (Cell)dataV.elementAt(ido);
                String fieldName = dataH.getName();
                int fieldType = dataH.getType();
                String fieldValue = dataH.getValue();
                stmtBufferColName.append(fieldName);
                stmtBufferColVal.append(this.massageFieldValue(fieldType, fieldValue.toString()));
                if (ido >= dataV.size() - 1) continue;
                stmtBufferColName.append(COMMA);
                stmtBufferColVal.append(COMMA);
            }
            stmtBufferColName.append(RIGHT_PAREN_STR);
            stmtBufferColVal.append(RIGHT_PAREN_STR);
            return stmtBufferColName.toString() + VALUES_STR + stmtBufferColVal.toString();
        }
        return null;
    }

    private String constructUpdateData(Vector dataV) {
        StringBuffer stmtBuffer = new StringBuffer();
        if (dataV != null) {
            for (int ido = 0; ido < dataV.size(); ++ido) {
                Cell dataH = (Cell)dataV.elementAt(ido);
                String fieldName = dataH.getName();
                int fieldType = dataH.getType();
                String fieldValue = dataH.getValue();
                stmtBuffer.append(fieldName + EQUAL_STR);
                stmtBuffer.append(this.massageFieldValue(fieldType, fieldValue.toString()));
                if (ido >= dataV.size() - 1) continue;
                stmtBuffer.append(COMMA);
            }
        }
        return stmtBuffer.toString();
    }

    private String constructExecData(Vector dataV) {
        boolean isOracle;
        StringBuffer stmtBuffer = new StringBuffer();
        boolean bl = isOracle = this.getDatabaseType() == 1;
        if (dataV != null) {
            if (isOracle) {
                stmtBuffer.append(LEFT_PAREN_STR);
            }
            for (int ido = 0; ido < dataV.size(); ++ido) {
                Cell dataH = (Cell)dataV.elementAt(ido);
                String fieldName = dataH.getName();
                int fieldType = dataH.getType();
                String fieldValue = dataH.getValue();
                if (!isOracle) {
                    stmtBuffer.append(" @" + fieldName + EQUAL_STR);
                }
                stmtBuffer.append(this.massageFieldValue(fieldType, fieldValue.toString()));
                if (ido >= dataV.size() - 1) continue;
                stmtBuffer.append(COMMA);
            }
            if (isOracle) {
                stmtBuffer.append(RIGHT_PAREN_STR);
            }
        }
        return stmtBuffer.toString();
    }

    private String constructWhereData(OldValues value) throws Exception {
        String condition;
        StringBuffer stmtBuffer = new StringBuffer();
        stmtBuffer.append(WHERE_STR);
        List cells = value.getCells();
        if (cells == null || cells.isEmpty()) {
            return "";
        }
        boolean firstCell = true;
        for (Cell cell : cells) {
            condition = cell.getCondition();
            if (firstCell) {
                if (condition != null && !condition.equals("")) {
                    throw new Exception(this._bundle.getString("XMLParseUtil.getStatement.invalidFirstCell") + cell.getString());
                }
                firstCell = false;
            } else if (condition == null || condition.equals("")) {
                cell.setCondition(AND_STR);
            }
            StringBuffer cellBuf = this.genGroupCondition(cell);
            stmtBuffer.append(cellBuf.toString());
        }
        List cellGroups = value.getCellGroups();
        if (cellGroups == null || cellGroups.isEmpty()) {
            return stmtBuffer.toString();
        }
        for (CellGroup cgroup : cellGroups) {
            if (cgroup.getCellsSize() < 1) {
                return stmtBuffer.toString();
            }
            condition = cgroup.getCondition();
            String operator = cgroup.getOperator();
            if (condition != null) {
                stmtBuffer.append(SPACE + condition + SPACE);
            } else {
                stmtBuffer.append("  and  ");
            }
            if (operator != null) {
                stmtBuffer.append(SPACE + operator + SPACE);
            }
            stmtBuffer.append(LEFT_PAREN_STR);
            List innerCells = cgroup.getCells();
            boolean firstCell2 = true;
            for (Cell cell : innerCells) {
                condition = cell.getCondition();
                if (firstCell2) {
                    if (condition != null && !condition.equals("")) {
                        throw new Exception(this._bundle.getString("XMLParseUtil.getStatement.invalidFirstCell") + cell.getString());
                    }
                    firstCell2 = false;
                } else if (condition == null || condition.equals("")) {
                    cell.setCondition(AND_STR);
                }
                StringBuffer buf = this.genGroupCondition(cell);
                stmtBuffer.append(buf.toString());
            }
            stmtBuffer.append(RIGHT_PAREN_STR);
        }
        return stmtBuffer.toString();
    }

    private StringBuffer genGroupCondition(Cell cell) {
        String operator;
        StringBuffer stmtBuffer = new StringBuffer();
        String fieldName = cell.getName();
        int fieldType = cell.getType();
        String fieldValue = cell.getValue();
        String condition = cell.getCondition();
        if (condition != null) {
            stmtBuffer.append(SPACE + condition + SPACE);
        }
        if ((operator = cell.getOperator()) != null) {
            stmtBuffer.append(fieldName + SPACE + operator + SPACE);
        } else {
            stmtBuffer.append(fieldName + EQUAL_STR);
        }
        stmtBuffer.append(this.massageFieldValue(fieldType, fieldValue.toString()));
        return stmtBuffer;
    }

    private String massageFieldValue(int fieldType, String dataValue) {
        if (dataValue.equals("NULL")) {
            return dataValue;
        }
        switch (fieldType) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return dataValue;
            }
            case 14: 
            case 15: {
                return this.massageMoneyFieldValue(dataValue);
            }
            case 12: 
            case 13: 
            case 27: 
            case 28: {
                return this.massageDateTimeFieldValue(fieldType, dataValue);
            }
            case 1: 
            case 5: 
            case 19: 
            case 29: {
                return this.massageBinaryFieldValue(dataValue);
            }
        }
        return "'" + dataValue + "'";
    }

    private String massageMoneyFieldValue(String dataValue) {
        String moneyValue = dataValue;
        if (dataValue.startsWith("$") && this.getDatabaseType() != 0) {
            moneyValue = dataValue.substring(dataValue.indexOf("$") + 1);
        }
        return moneyValue;
    }

    private String massageBinaryFieldValue(String dataValue) {
        if (dataValue.length() == 0) {
            return "'" + dataValue + "'";
        }
        if (dataValue.equals("0x")) {
            return "NULL";
        }
        if (this.getDatabaseType() == 1) {
            String newDataValue = dataValue;
            if (dataValue.startsWith("0x")) {
                newDataValue = dataValue.substring(dataValue.indexOf("0x") + 2);
            }
            return "'" + newDataValue + "'";
        }
        return dataValue;
    }

    private String massageDateTimeFieldValue(int fieldType, String dataValue) {
        if (fieldType == 28) {
            return this.massageTimeFieldValue(dataValue);
        }
        if (fieldType == 27) {
            return this.massageDateFieldValue(dataValue);
        }
        if (this.getDatabaseType() == 1) {
            String newDateValue = null;
            try {
                newDateValue = DT_NOMS_FORMAT.format(DT_FORMAT.parse(dataValue));
            }
            catch (ParseException pe) {
                if (this._log != null) {
                    String msg = this._bundle.getString("XMLParseUtil.massageDateTimeField.e1") + dataValue;
                    this._log.error((Object)msg, (Throwable)pe);
                }
                pe.printStackTrace();
            }
            return "to_date('" + newDateValue + "', '" + ORA_DATETIME_PATTERN + "')";
        }
        return "'" + dataValue + "'";
    }

    private String massageDateFieldValue(String dataValue) {
        if (this.getDatabaseType() == 1) {
            return "to_date('" + dataValue + "', '" + ORA_DATE_PATTERN + "')";
        }
        return "'" + dataValue + "'";
    }

    private String massageTimeFieldValue(String dataValue) {
        if (this.getDatabaseType() == 1) {
            String massageTime = "47120101 " + dataValue;
            String newDateValue = null;
            try {
                newDateValue = DT_NOMS_FORMAT.format(DT_FORMAT.parse(massageTime));
            }
            catch (ParseException pe) {
                if (this._log != null) {
                    String msg = this._bundle.getString("XMLParseUtil.massageDateTimeField.e1") + dataValue;
                    this._log.error((Object)msg, (Throwable)pe);
                }
                pe.printStackTrace();
            }
            return "to_date('" + newDateValue + "', '" + ORA_DATETIME_PATTERN + "')";
        }
        return "'" + dataValue + "'";
    }
}

