/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model.url;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.ui.internal.intro.impl.model.url.IntroURL;
import org.eclipse.ui.internal.intro.impl.util.Log;

public class IntroURLParser {
    private boolean hasProtocol = false;
    private boolean isIntroUrl = false;
    private URL url_inst;

    public IntroURLParser(String url) {
        this.parseUrl(url);
    }

    private void parseUrl(String url) {
        if (url == null) {
            return;
        }
        this.url_inst = null;
        try {
            this.url_inst = new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        if (this.url_inst.getProtocol() != null) {
            this.hasProtocol = true;
            this.isIntroUrl = this.isIntroUrl(this.url_inst);
            return;
        }
    }

    public boolean hasProtocol() {
        return this.hasProtocol;
    }

    public boolean hasIntroUrl() {
        return this.isIntroUrl;
    }

    public String getProtocol() {
        return this.url_inst.getProtocol();
    }

    public String getHost() {
        return this.url_inst.getHost();
    }

    private boolean isIntroUrl(URL url) {
        if (!url.getProtocol().equalsIgnoreCase("http")) {
            return false;
        }
        return url.getHost().equalsIgnoreCase("org.eclipse.ui.intro");
    }

    public IntroURL getIntroURL() {
        IntroURL introURL = null;
        if (this.isIntroUrl) {
            String action = this.getPathAsAction(this.url_inst);
            Properties parameters = this.getQueryParameters(this.url_inst);
            introURL = new IntroURL(action, parameters);
        }
        return introURL;
    }

    private String getPathAsAction(URL url) {
        String action = url.getPath();
        if (action != null) {
            action = action.substring(1);
        }
        return action;
    }

    public Properties getQueryParameters(URL url) {
        Properties properties = new Properties();
        String query = url.getQuery();
        if (query == null) {
            return properties;
        }
        String[] params = query.split("&");
        int i = 0;
        while (i < params.length) {
            String[] keyValuePair = params[i].split("=");
            if (keyValuePair.length != 2) {
                Log.warning("Ignoring the following Intro URL parameter: " + params[i]);
            } else {
                properties.setProperty(keyValuePair[0], keyValuePair[1]);
            }
            ++i;
        }
        return properties;
    }
}

