/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra;

import com.sybase.connector.repra.RepraConnectionFactoryImpl;
import com.sybase.connector.repra.RepraConnectionManager;
import com.sybase.connector.repra.RepraConnectionRequestInfo;
import com.sybase.connector.repra.RepraConnectionSpec;
import com.sybase.connector.repra.RepraConst;
import com.sybase.connector.repra.RepraManagedConnection;
import com.sybase.connector.repra.SecurityUtil;
import com.sybase.connector.repra.Version;
import com.sybase.connector.repra.license.RepraSySamClient;
import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.util.RepraPropertyUtil;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class RepraManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable {
    private static RaLogger _log = null;
    private String _connectionName = "";
    private String _logLevel = "INFO";
    private RepraConnectionSpec _spec;
    private Properties _props = new Properties();
    Hashtable _mcfTable = new Hashtable();

    public String getProductName() {
        return RepraConst.PRODUCT_NAME;
    }

    public void setProductName(String productName) {
    }

    public Properties getConfigProperties() {
        return this._props;
    }

    public void setConfigProperties(Properties props) {
        this._props = props;
        this._connectionName = this.getConnectionName();
        this._logLevel = this.getLogLevel();
    }

    public String getConnectionName() {
        return this._props.getProperty("ConnectionName", "");
    }

    public String getLogLevel() {
        return this._props.getProperty("LogLevel", "INFO");
    }

    public RepraManagedConnectionFactory() {
        if (_log == null) {
            _log = new RaLogger(0);
        }
        String version = "\nVersion:  " + Version.getFullVersion();
        String copyRight = Version.getCopyRight();
        Object[] params = new String[]{version, copyRight};
        _log.info("RepraManagedConnectionFactory.m0", params);
        _log.debug("RepraManagedConnectionFactory.m1");
        _log.debug("RepraManagedConnectionFactory.m12");
        RepraSySamClient sClient = new RepraSySamClient();
        sClient.setLogger(_log);
        sClient.checkOutRepConnector();
    }

    public void setLogger(RaLogger log) {
        if (_log == null) {
            _log = log;
        }
    }

    public Object createConnectionFactory(ConnectionManager cxMgr) throws ResourceException {
        String serverType = RepraPropertyUtil.getServerType();
        Object[] params = new String[]{serverType, this._connectionName, this._logLevel};
        _log.debug("RepraManagedConnectionFactory.m2", params);
        RepraConnectionFactoryImpl connFactory = null;
        connFactory = cxMgr == null ? new RepraConnectionFactoryImpl(this, new RepraConnectionManager()) : new RepraConnectionFactoryImpl(this, cxMgr);
        connFactory.setLogger(_log);
        return connFactory;
    }

    public Object createConnectionFactory() throws ResourceException {
        _log.debug("RepraManagedConnectionFactory.m3");
        RepraConnectionFactoryImpl connFactory = new RepraConnectionFactoryImpl(this, new RepraConnectionManager());
        connFactory.setLogger(_log);
        return connFactory;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connReqInfo) throws ResourceException {
        try {
            PasswordCredential passCredent = null;
            if (connReqInfo != null) {
                ((RepraConnectionRequestInfo)connReqInfo).setLogger(_log);
                this._props = ((RepraConnectionRequestInfo)connReqInfo).getProperties();
                if (subject != null) {
                    passCredent = SecurityUtil.getPasswordCredential(this, subject, connReqInfo);
                }
            }
            String serverType = RepraPropertyUtil.getServerType();
            Object[] params = new String[]{serverType, this._connectionName, this._logLevel};
            _log.debug("RepraManagedConnectionFactory.m5", params);
            RepraManagedConnection managedConn = new RepraManagedConnection(this, passCredent);
            managedConn.setLogger(_log);
            return managedConn;
        }
        catch (Exception ex) {
            EISSystemException re = new EISSystemException(_log.getResourceBundle().getString("RepraManagedConnectionFactory.m9"));
            re.setLinkedException(ex);
            _log.error("RepraManagedConnectionFactory.m9", (Throwable)re);
            throw re;
        }
    }

    public ManagedConnection matchManagedConnections(Set connSet, Subject subject, ConnectionRequestInfo connReqInfo) throws ResourceException {
        PasswordCredential passCredent = SecurityUtil.getPasswordCredential(this, subject, connReqInfo);
        for (Object nextObj : connSet) {
            if (!(nextObj instanceof RepraManagedConnection)) continue;
            RepraManagedConnection rjmConn = (RepraManagedConnection)nextObj;
            rjmConn.setLogger(_log);
            RepraManagedConnectionFactory rjmcFactory = (RepraManagedConnectionFactory)rjmConn.getManagedConnectionFactory();
            if (!this._connectionName.equals(rjmcFactory.getConnectionName())) continue;
            return rjmConn;
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        _log.info("RepraManagedConnectionFactory.m10b");
    }

    public PrintWriter getLogWriter() throws ResourceException {
        ResourceException rex = new ResourceException(_log.getResourceBundle().getString("RepraManagedConnectionFactory.m11"));
        _log.info("RepraManagedConnectionFactory.m11", (Throwable)rex);
        throw rex;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RepraManagedConnectionFactory)) {
            return false;
        }
        RepraManagedConnectionFactory rjmcFactory = (RepraManagedConnectionFactory)object;
        if (rjmcFactory.getConnectionName() == null) {
            return false;
        }
        return this._connectionName.equals(rjmcFactory.getConnectionName());
    }

    public int hashCode() {
        String comb = this._connectionName;
        return comb.hashCode();
    }

    public RepraConnectionSpec getConnectionSpec() {
        if (this._spec == null) {
            this._spec = new RepraConnectionSpec();
        }
        return this._spec;
    }

    public PasswordCredential getPasswordCredential() {
        PasswordCredential passCredent = null;
        try {
            String login = "sa";
            String password = "";
            passCredent = new PasswordCredential(login, password.toCharArray());
            passCredent.setManagedConnectionFactory((ManagedConnectionFactory)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return passCredent;
    }
}

