/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.jaguar;

public class RepraLoader
extends ClassLoader {
    private static ClassLoader _classLoader = RepraLoader.findClassLoader(RepraLoader.class);

    private static ClassLoader findClassLoader(Class theClass) {
        ClassLoader cl = theClass.getClassLoader();
        if (cl == null) {
            cl = RepraLoader.class.getClassLoader();
        }
        return cl;
    }

    private static Object newInstance(String className, ClassLoader classLoader, String interfName) throws Exception {
        try {
            Class<?> cls = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            if (cls != null) {
                if (!RepraLoader.validClass(cls, interfName)) {
                    throw new Exception("Provider " + className + " doesn't implement " + interfName);
                }
                return cls.newInstance();
            }
            throw new Exception("'" + className + "' can not be loaded.");
        }
        catch (ClassNotFoundException cnfe) {
            throw new Exception("Provider '" + className + "' class not found.");
        }
        catch (Exception be) {
            throw be;
        }
        catch (Throwable e) {
            throw new Exception("Provider " + className + " could not be " + " instantiated: ");
        }
    }

    public static Object getInstance(String theClassName, String interfaceClassName) throws Exception {
        if (theClassName == null || theClassName.length() == 0 || interfaceClassName == null || interfaceClassName.length() == 0) {
            throw new Exception("Key or interfaceClassName is not set.");
        }
        ClassLoader theClassLoader = null;
        try {
            Class<?> interfaceClass = Class.forName(interfaceClassName);
            theClassLoader = _classLoader;
        }
        catch (ClassNotFoundException cnfe) {
            throw new Exception("Interface Class '" + interfaceClassName + "' is not found.");
        }
        Object classObj = null;
        classObj = RepraLoader.newInstance(theClassName, theClassLoader, interfaceClassName);
        return classObj;
    }

    private static boolean validClass(Class cls, String interfName) {
        boolean interfEqual = false;
        Class<?>[] theInterfaces = cls.getInterfaces();
        for (int i = 0; i < theInterfaces.length; ++i) {
            String interfaceName = theInterfaces[i].getName();
            if (!interfName.equals(interfaceName)) continue;
            interfEqual = true;
        }
        return interfEqual;
    }
}

