/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.jms;

import com.sybase.connector.repra.ConnectionContainer;
import com.sybase.connector.repra.jdbc.JDBCClient;
import com.sybase.connector.repra.jms.JMSClient;
import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.transform.ErrorGenerator;
import com.sybase.connector.repra.transform.EventFormatter;
import com.sybase.connector.repra.transform.EventFormatterFactory;
import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class JMSAdapterImpl
extends JMSClient {
    private static ConnectionContainer _connectionContainer = null;
    private String _controlCmd = "";
    private JDBCClient _jdbcClient = null;
    private MessageConsumer _jReceiver = null;
    private Message _message = null;
    private String _messageId = "";
    private MessageProducer _errorProducer = null;
    private Queue _errorQueue = null;
    private Topic _errorTopic = null;

    public JMSAdapterImpl(Properties cProps) {
        try {
            this._log = new RaLogger(cProps.getProperty("ConnectionName"), 0, cProps.getProperty("LogLevel", "INFO"));
            this._isAdapter = true;
            this.initProperties(cProps);
            _connectionContainer = ConnectionContainer.getInstance();
        }
        catch (Exception anyex) {
            this._log.error("JMSAdapterImpl.JMSAdapterImpl.e1", (Throwable)anyex);
        }
    }

    private void configureJDBCClient() throws Exception {
        this._jdbcClient = new JDBCClient(this._cProps, this._log);
        this._jdbcClient.configureClient();
    }

    private void configureJMSReceiver() throws Exception {
        this.configureJMSClient();
        String dest = this._cProps.getProperty("Status.Destination", "StatusQueue");
        if (this._cProps.getProperty("JMSType", "queue").equals("queue")) {
            this._jReceiver = ((QueueSession)this._jSession).createReceiver(this._queue);
            this._errorQueue = this._sonicmq ? ((QueueSession)this._jSession).createQueue(dest.trim()) : (Queue)this._ctx.lookup(dest.trim());
            this._errorProducer = ((QueueSession)this._jSession).createSender(this._errorQueue);
        } else {
            this._isQueue = false;
            this._jReceiver = ((TopicSession)this._jSession).createDurableSubscriber(this._topic, this.getConnectionName());
            this._errorTopic = this._sonicmq ? ((TopicSession)this._jSession).createTopic(dest.trim()) : (Topic)this._ctx.lookup(dest.trim());
            this._errorProducer = ((TopicSession)this._jSession).createPublisher(this._errorTopic);
            if (!this._cProps.getProperty("JMS_TopicSubscribers", "").equals("")) {
                StringTokenizer stoken = new StringTokenizer(this._cProps.getProperty("JMS_TopicSubscribers"), ",");
                String sub = "";
                while (stoken.hasMoreTokens()) {
                    sub = stoken.nextToken().trim();
                    TopicSubscriber subscriber = ((TopicSession)this._jSession).createDurableSubscriber(this._errorTopic, sub);
                }
            }
        }
    }

    public void run() {
        this._log.debug("JMSAdapterImpl.run.m1");
        try {
            this.configureJMSReceiver();
            this._log.debug("JMSAdapterImpl.configureJMSReceiver.m1", (Object)this._cProps.getProperty("JMS_LocalQueue"), this._cProps.getProperty("JMS_ProviderURL"));
        }
        catch (Throwable ex) {
            _connectionContainer.setControl(this.getConnectionName(), "STOP");
            this._log.error("JMSAdapterImpl.configureJMSReceiver.e1", (Object)this._cProps.getProperty("JMS_LocalQueue"), (Object)this._cProps.getProperty("JMS_ProviderURL"), ex);
            this.close();
            return;
        }
        try {
            this.configureJDBCClient();
            this._log.info("JMSAdapterImpl.configureJDBCClient.m1", (Object)this._cProps.getProperty("DATABASE_URL"), this._cProps.getProperty("DATABASE_Username"));
        }
        catch (Throwable ex) {
            this._log.error("JMSAdapterImpl.configureJDBCClient.e1", (Object)this._cProps.getProperty("DATABASE_URL"), (Object)this._cProps.getProperty("DATABASE_Username"), ex);
            this.handleException(ex.toString());
            _connectionContainer.setControl(this.getConnectionName(), "STOP");
            this.close();
            return;
        }
        _connectionContainer.setControl(this.getConnectionName(), "RUNNING");
        this._log.debug("JMSAdapterImpl.run.m2");
        try {
            while (true) {
                this._controlCmd = _connectionContainer.getControl(this.getConnectionName());
                if (this._controlCmd != null && !this._controlCmd.equals("") && !this._controlCmd.equals("RepraConst.STATUS_STOP")) {
                    this._message = this._jReceiver.receive(3000L);
                    if (this._message == null) continue;
                    this._log.debug("JMSAdapterImpl.run.m3", this._message.toString());
                    if (!this.handleEvent(this._message)) continue;
                    this._log.debug("JMSAdapterImpl.run.m4");
                    this._message.acknowledge();
                    continue;
                }
                break;
            }
        }
        catch (Throwable ex) {
            this._log.error("JMSAdapterImpl.run.m6", ex);
        }
        this.close();
    }

    public void close() {
        _connectionContainer.setControl(this.getConnectionName(), "STOP");
        this._log.debug("JMSAdapterImpl.close.m1", this.getConnectionName());
        this.cleanup();
    }

    private void cleanup() {
        try {
            if (this._jdbcClient != null) {
                this._jdbcClient.close();
            }
            super.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized boolean handleEvent(Message message) {
        try {
            String msg = null;
            boolean status = true;
            if (message instanceof TextMessage) {
                msg = ((TextMessage)message).getText();
            } else if (this._message instanceof BytesMessage) {
                BytesMessage bmsg = (BytesMessage)this._message;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] tmp = new byte[1024];
                int length = 0;
                msg = "";
                while ((length = bmsg.readBytes(tmp)) != -1) {
                    if (length <= 0) continue;
                    msg = msg + new String(tmp, 0, length, "UTF-8");
                }
                msg = msg.trim();
            } else {
                this.handleException(message.toString());
                return false;
            }
            if (msg.toLowerCase().startsWith("select")) {
                this._messageId = msg;
                this.handleException("WARNING");
                this._log.warn("JMSAdapterImpl.handleEvent.m1", msg);
                return true;
            }
            if (!msg.toLowerCase().startsWith("<")) {
                this._messageId = message.getJMSMessageID();
                status = this._jdbcClient.sendEvent(msg);
            } else {
                EventFormatter formatter = EventFormatterFactory.getFormatter(this._jdbcClient.getDatabaseType());
                List stmts = formatter.format(msg);
                this._messageId = formatter.getEventId(msg);
                status = this._jdbcClient.sendEvent(stmts);
            }
            this._log.debug("JMSAdapterImpl.handleEvent.m2", "Result : " + status + ":" + msg);
            return status;
        }
        catch (Throwable ex) {
            this._log.error("JMSAdapterImpl.handleEvent.e1", ex);
            this.handleException(ex.toString());
            return true;
        }
    }

    private void handleException(String ex) {
        try {
            ErrorGenerator errorGen = new ErrorGenerator();
            String uri = this._cProps.getProperty("DTD_URL");
            errorGen.setLogger(this._log);
            errorGen.setXsdUrl(uri);
            String msg = errorGen.genErrorMessage(this._messageId, ex, "ERROR");
            TextMessage errorMsg = this._jSession.createTextMessage();
            errorMsg.setText(msg);
            if (this._isQueue) {
                ((QueueSender)this._errorProducer).send((Message)errorMsg, 2, 4, 0L);
            } else {
                ((TopicPublisher)this._errorProducer).publish((Message)errorMsg, 2, 4, 0L);
            }
            this._log.debug("JMSAdapterImpl.handleException.m1");
        }
        catch (Throwable tex) {
            this._log.error("JMSAdapterImpl.handleException.e1", tex);
        }
    }

    public void setProperties(Properties props) {
        this._cProps = props;
    }

    public Properties getProperties() {
        return this._cProps;
    }

    public String getConnectionName() {
        return this._cProps.getProperty("ConnectionName");
    }
}

