/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.jms;

import com.sybase.connector.repra.jms.JMSClient;
import com.sybase.connector.repra.logging.RaLogger;
import java.util.Properties;
import javax.jms.Message;
import javax.jms.QueueSender;
import javax.jms.QueueSession;

public class JMSQueueClient
extends JMSClient {
    public void init(Properties cProps, RaLogger log) {
        try {
            this._log = log;
            this.initProperties(cProps);
            this._log.info("JMSQueueClient.init.m1");
        }
        catch (Throwable ex) {
            this._log.error("JMSQueueClient.init.e1", ex);
        }
    }

    public void configureClient() throws Exception {
        this.configureJMSClient();
        try {
            this._jSender = ((QueueSession)this._jSession).createSender(this._queue);
            this._jSender.setDisableMessageID(true);
            this._log.info("JMSQueueClient.configureClient.m1", (Object)this._queue.getQueueName(), this._url);
        }
        catch (Exception ex) {
            this._log.error("JMSQueueClient.configureClient.e1", (Object)this._queue.getQueueName(), (Object)this._url, ex);
            throw ex;
        }
    }

    public boolean sendEvent(Object repMessage, String eventId) throws Exception {
        Message message = null;
        message = this.createMessage(repMessage, eventId);
        try {
            ((QueueSender)this._jSender).send(message, 2, 4, 0L);
            this._log.info("JMSQueueClient.sendEvent.m1", (Object)this._queue.getQueueName(), this._url);
            this._log.debug("JMSQueueClient.sendEvent.m2", repMessage.toString());
            return true;
        }
        catch (Exception ex) {
            this._log.error("JMSQueueClient.sendEvent.e1", (Object)this._queue.getQueueName(), (Object)this._url, ex);
            throw ex;
        }
    }

    public boolean isReady() {
        return this._jSender != null;
    }
}

