/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.mq;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.sybase.connector.repra.ConnectionContainer;
import com.sybase.connector.repra.jdbc.JDBCClient;
import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.mq.MQBase;
import com.sybase.connector.repra.transform.ErrorGenerator;
import com.sybase.connector.repra.transform.EventFormatter;
import com.sybase.connector.repra.transform.EventFormatterFactory;
import java.util.List;
import java.util.Properties;

public class MQAdapterImpl
extends MQBase {
    protected static ConnectionContainer _connectionContainer = null;
    protected String _controlCmd = "";
    protected JDBCClient _jdbcClient = null;
    protected MQQueue _errQueue;
    protected MQMessage _errMessage;
    protected String _messageId = "";

    protected MQAdapterImpl() {
    }

    public MQAdapterImpl(Properties cProps) {
        this.initMQAdapterImpl(cProps);
    }

    protected void initMQAdapterImpl(Properties cProps) {
        try {
            this._cProps = cProps;
            this._log = new RaLogger(this._cProps.getProperty("ConnectionName"), 0, this._cProps.getProperty("LogLevel", "INFO"));
            this.initMQClient(this._cProps, this._log);
            _connectionContainer = ConnectionContainer.getInstance();
            this._log.debug("MQAdapterImpl.initMQAdapterImpl.m1");
        }
        catch (Exception anyex) {
            this._log.error("MQAdapterImpl.initMQAdapterImpl.m2", (Throwable)anyex);
        }
    }

    public void configureJDBCClient() throws Exception {
        this._jdbcClient = new JDBCClient(this._cProps, this._log);
        this._jdbcClient.configureClient();
    }

    public void configureMQReceiver() throws Exception {
        try {
            MQEnvironment.hostname = this._hostname;
            if (this._channel == null || this._channel.equals("\"\"") || this._channel.equals("''")) {
                this._channel = "";
            }
            if (!this._channel.equals("")) {
                MQEnvironment.channel = this._channel;
            }
            if (this._portnumber == null || this._portnumber.equals("\"\"") || this._portnumber.equals("''")) {
                this._portnumber = "";
            }
            if (!this._portnumber.equals("")) {
                MQEnvironment.port = Integer.parseInt(this._portnumber);
            }
            if (this._username != null && this._username.equals("")) {
                MQEnvironment.userID = this._username;
            }
            if (this._password != null && this._password.equals("")) {
                MQEnvironment.password = this._password;
            }
            MQEnvironment.properties.put("transport", "MQSeries");
            this._queueManager = new MQQueueManager(this._qmgr);
            int option = 17;
            int optionI = 1;
            int optionO = 16;
            this._localQueue = this._queueManager.accessQueue(this._lqueue, optionI);
            this._log.debug("MQAdapterImpl.configureMQReceiver.m1", this._lqueue);
            String dest = this._cProps.getProperty("Status.Destination", "StatusQueue");
            this._errQueue = this._queueManager.accessQueue(dest, optionO);
            this._log.debug("MQAdapterImpl.configureMQReceiver.m2", dest);
        }
        catch (Exception ex) {
            this._log.error("MQAdapterImpl.configureMQReceiver.m3", (Throwable)ex);
            throw ex;
        }
    }

    public void run() {
        try {
            this.configureMQReceiver();
        }
        catch (Throwable ex) {
            this.close();
            return;
        }
        try {
            this.configureJDBCClient();
            this._log.info("MQAdapterImpl.configureJDBCClient.m1", (Object)this._cProps.getProperty("DATABASE_URL"), this._cProps.getProperty("DATABASE_Username"));
        }
        catch (Throwable ex) {
            this._log.error("MQAdapterImpl.configureJDBCClient.e1", (Object)this._cProps.getProperty("DATABASE_URL"), (Object)this._cProps.getProperty("DATABASE_Username"), ex);
            _connectionContainer.setControl(this.getConnectionName(), "STOP");
            this.handleException(ex.toString());
            this.close();
            return;
        }
        _connectionContainer.setControl(this.getConnectionName(), "RUNNING");
        this._log.debug("MQAdapterImpl.run.m1");
        try {
            while (true) {
                this._controlCmd = _connectionContainer.getControl(this.getConnectionName());
                if (this._controlCmd.equals("") || this._controlCmd.equals("STOP")) break;
                this._mqMessage = new MQMessage();
                MQGetMessageOptions readOpt = new MQGetMessageOptions();
                readOpt.options |= 1;
                readOpt.waitInterval = 3000;
                try {
                    this._localQueue.get(this._mqMessage, readOpt);
                }
                catch (Exception ex) {
                    continue;
                }
                this._log.debug("MQAdapterImpl.run.m3", this._mqMessage.toString());
                if (!this.handleEvent(this._mqMessage)) continue;
                this._log.debug("MQAdapterImpl.run.m4");
            }
        }
        catch (Exception ex) {
            _connectionContainer.setControl(this.getConnectionName(), "STOP");
            this.cleanup();
        }
        this.close();
    }

    protected synchronized boolean handleEvent(MQMessage message) {
        try {
            String msg = "";
            boolean status = true;
            msg = this._encode.equalsIgnoreCase("utf") ? message.readUTF() : message.readString(message.getTotalMessageLength());
            if (msg.toLowerCase().startsWith("select")) {
                this._messageId = msg;
                this.handleException("WARNING");
                this._log.debug("MQAdapterImpl.handleEvent.m1", msg);
                return true;
            }
            if (!msg.toLowerCase().startsWith("<")) {
                this._messageId = new String(message.messageId);
                status = this._jdbcClient.sendEvent(msg);
            } else {
                EventFormatter formatter = EventFormatterFactory.getFormatter(this._jdbcClient.getDatabaseType());
                List stmts = formatter.format(msg);
                this._messageId = formatter.getEventId(msg);
                status = this._jdbcClient.sendEvent(stmts);
            }
            this._log.debug("MQAdapterImpl.handleEvent.m2", "Result : " + status + ":" + msg);
            return true;
        }
        catch (Exception ex) {
            this.handleException(ex.getMessage());
            return true;
        }
    }

    private void handleException(String errorMsg) {
        try {
            ErrorGenerator errorGen = new ErrorGenerator();
            String uri = this._cProps.getProperty("DTD_URL");
            errorGen.setLogger(this._log);
            errorGen.setXsdUrl(uri);
            String msg = errorGen.genErrorMessage(this._messageId, errorMsg, "ERROR");
            this._errMessage = new MQMessage();
            if (!this._encode.equals("") && this._encode.toLowerCase().startsWith("utf")) {
                this._errMessage.writeUTF(msg);
            } else {
                byte[] bArray = msg.getBytes();
                this._errMessage.write(bArray, 0, bArray.length);
            }
            this._errQueue.put(this._errMessage, new MQPutMessageOptions());
            this._log.debug("MQAdapterImpl.handleException.m1");
        }
        catch (Throwable tex) {
            this._log.error("MQAdapterImpl.handleException.m2", tex);
        }
    }

    public void close() {
        this._log.debug("MQAdapterImpl.close.m1", this.getConnectionName());
        this.cleanup();
    }

    public void cleanup() {
        try {
            _connectionContainer.setControl(this.getConnectionName(), "STOP");
            if (this._jdbcClient != null) {
                this._jdbcClient.close();
            }
            if (this._localQueue != null) {
                this._localQueue.close();
            }
            if (this._queueManager != null) {
                this._queueManager.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

