/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.mq;

import com.sybase.connector.repra.ConnectionContainer;
import com.sybase.connector.repra.jdbc.JDBCClient;
import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.mq.MQJMSBase;
import com.sybase.connector.repra.transform.ErrorGenerator;
import com.sybase.connector.repra.transform.EventFormatter;
import com.sybase.connector.repra.transform.EventFormatterFactory;
import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;

public class MQJMSAdapterImpl
extends MQJMSBase {
    protected static ConnectionContainer _connectionContainer = null;
    protected String _controlCmd = "";
    protected JDBCClient _jdbcClient = null;
    private Queue _queue = null;
    private Topic _topic = null;
    private Queue _errQueue = null;
    private Topic _errTopic = null;
    private MessageProducer _errSender = null;

    public MQJMSAdapterImpl(Properties cProps) {
        this.initMQJMSAdapterImpl(cProps);
    }

    protected void initMQJMSAdapterImpl(Properties cProps) {
        try {
            this._cProps = cProps;
            this._log = new RaLogger(this._cProps.getProperty("ConnectionName"), 0, this._cProps.getProperty("LogLevel", "INFO"));
            this.initMQClient(this._cProps, this._log);
            _connectionContainer = ConnectionContainer.getInstance();
            this._log.debug("MQJMSAdapterImpl.initMQJMSAdapterImpl.m1");
        }
        catch (Exception anyex) {
            this._log.error("MQJMSAdapterImpl.initMQJMSAdapterImpl.m2", (Throwable)anyex);
        }
    }

    public void configureJDBCClient() throws Exception {
        this._jdbcClient = new JDBCClient(this._cProps, this._log);
        this._jdbcClient.configureClient();
    }

    public void configureMQReceiver() throws Exception {
        try {
            String dest = this._cProps.getProperty("Status.Destination", "StatusQueue");
            if (this._isQueue) {
                this._queue = ((QueueSession)this._session).createQueue(this._lqueue);
                this._receiver = ((QueueSession)this._session).createReceiver(this._queue);
                this._errQueue = ((QueueSession)this._session).createQueue(dest);
                this._errSender = ((QueueSession)this._session).createSender(this._errQueue);
            } else {
                this._topic = ((TopicSession)this._session).createTopic(this._lqueue);
                this._receiver = ((TopicSession)this._session).createDurableSubscriber(this._topic, this.getConnectionName());
                this._errTopic = ((TopicSession)this._session).createTopic(dest);
                this._errSender = ((TopicSession)this._session).createPublisher(this._errTopic);
            }
            Object[] info = new String[]{this._hostname, this._portnumber, this._qmgr, this._lqueue, this._username};
            this._log.debug("MQJMSAdapterImpl.configureMQReceiver.m1", info);
        }
        catch (Exception ex) {
            this._log.error("MQJMSAdapterImpl.configureMQReceiver.m2", (Object)this._lqueue, (Throwable)ex);
            throw ex;
        }
    }

    public void run() {
        try {
            this.configureMQJMS();
            this.configureMQReceiver();
        }
        catch (Throwable ex) {
            this.close();
            return;
        }
        try {
            this.configureJDBCClient();
            this._log.info("MQJMSAdapterImpl.configureJDBCClient.m1", (Object)this._cProps.getProperty("DATABASE_URL"), this._cProps.getProperty("DATABASE_Username"));
        }
        catch (Throwable ex) {
            this._log.error("MQJMSAdapterImpl.configureJDBCClient.e1", (Object)this._cProps.getProperty("DATABASE_URL"), (Object)this._cProps.getProperty("DATABASE_Username"), ex);
            this.handleException(ex.toString());
            _connectionContainer.setControl(this.getConnectionName(), "STOP");
            this.close();
            return;
        }
        _connectionContainer.setControl(this.getConnectionName(), "RUNNING");
        this._log.debug("MQJMSAdapterImpl.run.m1");
        try {
            while (true) {
                this._controlCmd = _connectionContainer.getControl(this.getConnectionName());
                if (!this._controlCmd.equals("") && !this._controlCmd.equals("STOP")) {
                    this._message = this._receiver.receive(3000L);
                    if (this._message == null) continue;
                    this._log.debug("MQJMSAdapterImpl.run.m3");
                    if (!this.handleEvent(this._message)) continue;
                    this._log.debug("MQJMSAdapterImpl.run.m4");
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.cleanup();
        this.close();
    }

    public boolean isReady() {
        return this._receiver != null;
    }

    public void cleanup() {
        try {
            _connectionContainer.setControl(this.getConnectionName(), "STOP");
            if (this._jdbcClient != null) {
                this._jdbcClient.close();
            }
            if (this._connection != null) {
                this._connection.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        this.cleanup();
    }

    private synchronized boolean handleEvent(Message message) {
        try {
            String msg = "";
            boolean status = true;
            if (message instanceof TextMessage) {
                msg = ((TextMessage)message).getText();
            } else if (this._message instanceof BytesMessage) {
                BytesMessage bmsg = (BytesMessage)this._message;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] tmp = new byte[1024];
                int length = 0;
                msg = "";
                while ((length = bmsg.readBytes(tmp)) != -1) {
                    if (length <= 0) continue;
                    msg = msg + new String(tmp, 0, length, "UTF-8");
                }
                msg = msg.trim();
            } else {
                this.handleException(message.toString());
                return false;
            }
            if (msg.toLowerCase().startsWith("select")) {
                this._messageId = msg;
                this.handleException("WARNING");
                this._log.debug("MQJMSAdapterImpl.handleEvent.m1", msg);
                return true;
            }
            if (!msg.toLowerCase().startsWith("<")) {
                this._messageId = message.getJMSMessageID();
                status = this._jdbcClient.sendEvent(msg);
            } else {
                EventFormatter formatter = EventFormatterFactory.getFormatter(this._jdbcClient.getDatabaseType());
                List stmts = formatter.format(msg);
                this._messageId = formatter.getEventId(msg);
                status = this._jdbcClient.sendEvent(stmts);
            }
            this._log.debug("MQJMSAdapterImpl.handleEvent.m2", "Result : " + status + ":" + msg);
            return status;
        }
        catch (Exception ex) {
            this.handleException(ex.toString());
            return true;
        }
    }

    private void handleException(String exMsg) {
        try {
            ErrorGenerator errorGen = new ErrorGenerator();
            String uri = this._cProps.getProperty("DTD_URL");
            errorGen.setLogger(this._log);
            errorGen.setXsdUrl(uri);
            String msg = errorGen.genErrorMessage(this._messageId, exMsg, "ERROR");
            TextMessage errorMsg = this._session.createTextMessage();
            errorMsg.setText(msg);
            if (this._isQueue) {
                ((QueueSender)this._errSender).send((Message)errorMsg, 2, 4, 0L);
            } else {
                ((TopicPublisher)this._errSender).publish((Message)errorMsg, 2, 4, 0L);
            }
            this._log.debug("MQJMSAdapterImpl.handleException.m1");
        }
        catch (Throwable tex) {
            this._log.error("MQJMSAdapterImpl.handleException.m2", tex);
        }
    }
}

