/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.mq;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.sybase.connector.repra.RepraJmsClient;
import com.sybase.connector.repra.mq.MQBase;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.QueueConnection;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.TopicConnection;

public abstract class MQJMSBase
extends MQBase
implements RepraJmsClient {
    protected ConnectionFactory _factory = null;
    protected Session _session = null;
    protected Connection _connection = null;
    protected MessageConsumer _receiver = null;
    protected MessageProducer _sender = null;
    protected Message _message = null;
    protected String _messageId = null;
    protected boolean _isQueue = true;
    protected boolean _asAdapter = false;

    public void configureMQJMS() throws Exception {
        try {
            ConfigEnvironment.start();
            if (this._cProps.getProperty("JMSType", "queue").equalsIgnoreCase("topic")) {
                this._isQueue = false;
            }
        }
        catch (Exception ex) {
            String info = this._hostname + ":" + this._channel + ":" + this._portnumber + ":" + this._qmgr + ":" + this._lqueue + ":" + this._username;
            this._log.error("MQJMSBase.configureMQJMS.e1", (Object)info, (Throwable)ex);
            throw ex;
        }
        if (this._isQueue) {
            this.configureQueue();
        } else {
            this.configureTopic();
        }
    }

    protected void configureQueue() throws Exception {
        try {
            this._factory = new MQQueueConnectionFactory();
            if (this._localConnection) {
                ((MQConnectionFactory)this._factory).setTransportType(1);
            }
            ((MQConnectionFactory)this._factory).setQueueManager(this._qmgr);
            ((MQConnectionFactory)this._factory).setHostName(this._hostname);
            if (this._portnumber == null || this._portnumber.equals("\"\"") || this._portnumber.equals("''")) {
                this._portnumber = "";
            }
            if (!this._portnumber.equals("")) {
                ((MQConnectionFactory)this._factory).setPort(Integer.parseInt(this._portnumber));
            }
            if (this._channel == null || this._channel.equals("\"\"") || this._channel.equals("''")) {
                this._channel = "";
            }
            if (!this._channel.equals("")) {
                ((MQConnectionFactory)this._factory).setChannel(this._channel);
            }
            this._connection = this._username == null || this._username.trim().equals("") ? ((MQQueueConnectionFactory)this._factory).createQueueConnection() : ((MQQueueConnectionFactory)this._factory).createQueueConnection(this._username, this._password);
            this._connection.start();
            this._session = ((QueueConnection)this._connection).createQueueSession(false, 1);
        }
        catch (Exception ee) {
            String info = this._hostname + ":" + this._channel + ":" + this._portnumber + ":" + this._qmgr + ":" + this._username;
            this._log.error("MQJMSBase.configureQueue.e1", (Object)this._lqueue, (Object)info, ee);
            throw ee;
        }
    }

    protected void configureTopic() throws Exception {
        try {
            this._factory = new MQTopicConnectionFactory();
            ((MQConnectionFactory)this._factory).setQueueManager(this._qmgr);
            ((MQConnectionFactory)this._factory).setHostName(this._hostname);
            if (this._portnumber == null || this._portnumber.equals("\"\"") || this._portnumber.equals("''")) {
                this._portnumber = "";
            }
            if (!this._portnumber.equals("")) {
                ((MQConnectionFactory)this._factory).setPort(Integer.parseInt(this._portnumber));
            }
            if (this._channel == null || this._channel.equals("\"\"") || this._channel.equals("''")) {
                this._channel = "";
            }
            if (!this._channel.equals("")) {
                ((MQConnectionFactory)this._factory).setChannel(this._channel);
            }
            this._connection = ((MQTopicConnectionFactory)this._factory).createTopicConnection();
            this._connection.start();
            this._session = ((TopicConnection)this._connection).createTopicSession(false, 1);
        }
        catch (Exception ee) {
            String info = this._hostname + ":" + this._channel + ":" + this._portnumber + ":" + this._qmgr + ":" + this._username;
            this._log.error("MQJMSBase.configureTopic.e1", (Object)this._lqueue, (Object)info, ee);
            throw ee;
        }
    }

    protected Message createMessage(Object repMessage, String eventId) throws Exception {
        TextMessage message = null;
        try {
            if (repMessage instanceof String) {
                message = this._session.createTextMessage();
                message.setText((String)repMessage);
            } else if (repMessage instanceof ByteArrayOutputStream) {
                byte[] bmsg = ((ByteArrayOutputStream)repMessage).toByteArray();
                message = this._session.createBytesMessage();
                ((BytesMessage)message).writeBytes(bmsg);
            } else {
                message = this._session.createObjectMessage();
                ((ObjectMessage)message).setObject((Serializable)repMessage);
            }
            if (eventId == null || eventId.equals("")) {
                eventId = Long.toString(System.currentTimeMillis());
            }
            message.setJMSMessageID(eventId);
            message.setStringProperty("eventId", eventId);
            return message;
        }
        catch (Throwable ex) {
            String info = this._hostname + ":" + this._channel + ":" + this._portnumber + ":" + this._qmgr + ":" + this._username;
            if (this._isQueue) {
                this._log.error("MQJMSBase.createMessage.e1", (Object)this._lqueue, (Object)info, ex);
            } else {
                this._log.error("MQJMSBase.createMessage.e2", (Object)this._lqueue, (Object)info, ex);
            }
            throw new Exception(ex.toString());
        }
    }

    public void run() {
    }

    public boolean isReady() {
        return this._sender != null;
    }

    public void close() {
        try {
            if (this._connection != null) {
                this._connection.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

