/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.mq;

import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.mq.MQJMSBase;
import java.util.Properties;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.QueueSession;

public class MQJMSQueueClient
extends MQJMSBase {
    private Queue _queue = null;

    public MQJMSQueueClient() {
    }

    public MQJMSQueueClient(Properties cProps, RaLogger log) {
        this.initMQClient(cProps, log);
        this._log.info("MQJMSQueueClient.init.m1");
    }

    public void configureClient() throws Exception {
        this.configureMQJMS();
        try {
            this._queue = ((QueueSession)this._session).createQueue(this._lqueue);
            this._sender = ((QueueSession)this._session).createSender(this._queue);
            this._sender.setDisableMessageID(true);
            this._log.info("MQJMSQueueClient.configureClient.m1", this._queue.getQueueName());
        }
        catch (Exception ex) {
            String info = this._hostname + ":" + this._portnumber + ":" + this._qmgr + ":" + this._username;
            this._log.error("MQJMSQueueClient.configureClient.e1", (Object)this._lqueue, (Object)info, ex);
            throw ex;
        }
    }

    public boolean sendEvent(Object repMessage, String eventId) throws Exception {
        try {
            this._message = this.createMessage(repMessage, eventId);
            ((QueueSender)this._sender).send(this._message, 2, 4, 0L);
            this._log.info("MQJMSQueueClient.sendEvent.m1", this._lqueue);
            if (repMessage instanceof String) {
                this._log.debug("MQJMSQueueClient.sendEvent.m2", (String)repMessage);
            } else {
                this._log.debug("MQJMSQueueClient.sendEvent.m2", repMessage.toString());
            }
            return true;
        }
        catch (Exception ex) {
            String info = this._hostname + ":" + this._portnumber + ":" + this._qmgr + ":" + this._username;
            this._log.error("MQJMSQueueClient.sendEvent.e1", (Object)this._lqueue, (Object)info, ex);
            throw ex;
        }
    }
}

