/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.ratool;

import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.ratool.BaseRTContext;
import com.sybase.connector.repra.ratool.Command;
import com.sybase.connector.repra.ratool.RTConstants;
import com.sybase.connector.repra.ratool.RTContext;
import com.sybase.connector.repra.ratool.RTResourceManager;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;

public abstract class BaseCommand
implements Command,
RTConstants {
    public static RaLogger _log;
    protected Vector _args = new Vector();
    private static RTResourceManager _baseResources;
    public BaseRTContext _context = null;
    protected int _commandStatus = 0;

    public abstract String getName();

    public abstract String getDescription();

    public abstract String getUsage();

    public abstract boolean isHidden();

    public void setLogger(RaLogger log) {
        _log = log;
    }

    public void setContext(RTContext context) {
        this._context = context;
    }

    public RTContext getContext() {
        return (RTContext)this._context;
    }

    public BaseRTContext getBaseRTContext() {
        return this._context;
    }

    public void setContext(BaseRTContext context) {
        this._context = context;
    }

    public void setArgs(Vector args) throws Exception {
        this._args = args;
    }

    public abstract void run() throws Exception;

    public int getCommandStatus() {
        return this._commandStatus;
    }

    public void writeToFile(String filename, String connName, Object obj) throws Exception {
        try {
            if (obj instanceof Properties) {
                FileOutputStream fout = new FileOutputStream(filename);
                ((Properties)obj).store(fout, "# Connection property file for connection " + connName);
                fout.close();
            } else if (obj instanceof StringBuffer) {
                BufferedWriter bwriter = new BufferedWriter(new FileWriter(filename));
                bwriter.write(((StringBuffer)obj).toString());
                bwriter.flush();
                bwriter.close();
            }
        }
        catch (FileNotFoundException fnfe) {
            _log.error(_baseResources.getString("getProperty.filenotfound") + fnfe.toString());
            throw fnfe;
        }
        catch (IOException ioe) {
            _log.error(_baseResources.getString("getProperty.ioexception") + ioe.toString());
            throw ioe;
        }
    }

    public Properties getConfigProp(String filename) throws Exception {
        try {
            Properties props = new Properties();
            FileInputStream fin = new FileInputStream(filename);
            props.load(fin);
            fin.close();
            return props;
        }
        catch (FileNotFoundException fne) {
            throw new Exception(_baseResources.getString("file.not.found"));
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    public boolean isValidConnProp(Properties props) {
        boolean isValid = true;
        String connName = props.getProperty("ConnectionName");
        String inType = props.getProperty("InboundType");
        String outType = props.getProperty("OutboundType");
        if (connName == null || connName.equals("") || inType == null || inType.equals("") || outType == null || outType.equals("")) {
            return false;
        }
        return !inType.equals(outType);
    }

    static {
        _baseResources = new RTResourceManager(BaseCommand.class);
    }
}

