/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.ratool;

import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.ratool.Command;
import com.sybase.connector.repra.ratool.RTException;
import com.sybase.connector.repra.ratool.RTResourceManager;
import com.sybase.connector.repra.ratool.RaTool;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class CommandFactory {
    private static RaLogger _log;
    private static CommandFactory _instance;
    private static RTResourceManager _resources;
    private Hashtable _commands = new Hashtable();
    private Properties _commandProps = new Properties();

    private CommandFactory() {
    }

    public static CommandFactory instance() {
        if (_instance == null) {
            _instance = new CommandFactory();
        }
        return _instance;
    }

    public void setLogger(RaLogger logger) {
        _log = logger;
    }

    public void initialize(String commandsFile) throws Exception {
        InputStream istr = null;
        if (this.getClass().getClassLoader() == null) {
            this.getClass().getClassLoader();
            istr = ClassLoader.getSystemResourceAsStream(commandsFile);
        } else {
            istr = this.getClass().getClassLoader().getResourceAsStream(commandsFile);
        }
        if (istr == null) {
            _log.error(_resources.getString("cannotFindCommandsFileMsg", new String[]{commandsFile}));
            throw new RTException(_resources.getString("cannotFindCommandsFileMsg", new String[]{commandsFile}), RaTool.instance());
        }
        Properties commandProps = new Properties();
        try {
            commandProps.load(istr);
        }
        catch (IOException ioex) {
            _log.error(_resources.getString("cannotLoadCommandsFileMsg", new String[]{commandsFile}));
            throw new RTException(_resources.getString("cannotLoadCommandsFileMsg", new String[]{commandsFile}), RaTool.instance(), ioex);
        }
        this._commandProps = commandProps;
        Enumeration<?> names = this._commandProps.propertyNames();
        while (names.hasMoreElements()) {
            String commandName = (String)names.nextElement();
            String className = this._commandProps.getProperty(commandName);
            if (commandName.indexOf(".") != -1) continue;
            if (className == null) {
                _log.error(_resources.getString("noClassSpecifiedForCommandMsg", new Object[]{commandName}));
                continue;
            }
            this._commands.put(commandName, className);
        }
    }

    public Vector getCommandNames() {
        Vector<String> names = new Vector<String>();
        Enumeration enums = this._commands.keys();
        while (enums.hasMoreElements()) {
            String name = (String)enums.nextElement();
            names.addElement(name);
        }
        return names;
    }

    public String getCommandProp(String name, String defaultValue) {
        return this._commandProps.getProperty(name, defaultValue);
    }

    public boolean hasCommand(String name) {
        Object obj = this._commands.get(name);
        return obj != null;
    }

    public Command createCommand(String name) throws RTException {
        this.loadCommand(name);
        Class clas = (Class)this._commands.get(name);
        Command command = null;
        if (clas != null) {
            try {
                command = (Command)clas.newInstance();
            }
            catch (InstantiationException iex) {
                _log.error(iex.toString());
            }
            catch (IllegalAccessException iaex) {
                _log.error(iaex.toString());
            }
        }
        return command;
    }

    protected void loadCommand(String commandName) throws RTException {
        Object obj = this._commands.get(commandName);
        if (obj instanceof Class) {
            return;
        }
        String className = (String)obj;
        Class<?> clas = null;
        try {
            clas = Class.forName(className);
        }
        catch (ClassNotFoundException cnfex) {
            _log.error(_resources.getString("cannotLoadCommandClassMsg", new Object[]{className, commandName}));
            throw new RTException(_resources.getString("cannotLoadCommandClassMsg", new Object[]{className, commandName}), RaTool.instance(), cnfex);
        }
        if (clas != null) {
            try {
                Command command = null;
                command = (Command)clas.newInstance();
                this._commands.put(commandName, command.getClass());
            }
            catch (Exception ex) {
                _log.error(_resources.getString("cannotRegisterCommandClassMsg", new Object[]{className, commandName}));
                throw new RTException(_resources.getString("cannotRegisterCommandClassMsg", new Object[]{className, commandName}), RaTool.instance(), ex);
            }
        }
    }

    static {
        _resources = new RTResourceManager(CommandFactory.class);
    }
}

