/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.ratool;

import com.sybase.connector.repra.logging.RaLogger;
import com.sybase.connector.repra.ratool.BaseCommand;
import com.sybase.connector.repra.ratool.BaseRTContext;
import com.sybase.connector.repra.ratool.Command;
import com.sybase.connector.repra.ratool.CommandFactory;
import com.sybase.connector.repra.ratool.RTContext;
import com.sybase.connector.repra.ratool.RTResourceManager;
import com.sybase.connector.repra.ratool.UsageException;
import com.sybase.connector.repra.ratool.Utils;
import java.util.Vector;

public class RaTool
extends BaseCommand {
    private static RaLogger _log;
    public static final String ARGS_PROP = "args";
    private static RTResourceManager _resources;
    private static RaTool _instance;
    private String[] _args;
    private static String _logfile;
    private static String _loglevel;

    public void setArgs(Vector args) throws Exception {
    }

    public static void main(String[] args) {
        int exitStatus = 0;
        _instance = new RaTool();
        try {
            _instance.setArgs(args);
            _instance.run();
            exitStatus = _instance.getCommandStatus();
        }
        catch (UsageException uex) {
            _log = new RaLogger(1, "INFO");
            exitStatus = 2;
            Command command = uex.getCommand();
            if (uex.getMessage() != null) {
                _log.error(Utils.formatCommandMsg(command.getName(), uex.getMessage()));
            }
            String usage = Utils.formatUsage(command.getName(), command.getUsage());
            _log.info(usage);
            if (command == _instance) {
                _log.info(_resources.getString("ratoolHelpHint", new String[]{BaseRTContext.getToolName()}));
            }
        }
        catch (Exception ex) {
            exitStatus = 2;
            _log.error("RaCommand[ERROR]:  " + _resources.getString("exception.encountered"), (Throwable)ex);
        }
        System.exit(exitStatus);
    }

    public static RaTool instance() {
        return _instance;
    }

    public String getName() {
        return BaseRTContext.getToolName();
    }

    public String getDescription() {
        return _resources.getString("ratoolDesc", new String[]{_resources.getString("PRODUCT_NAME")});
    }

    public String getUsage() {
        String jaghostnamevar = System.getProperty("JAGUAR_HOST_NAME", "");
        if (jaghostnamevar.length() == 0) {
            jaghostnamevar = "localhost";
        }
        return _resources.getString("ratoolUsage", new String[]{_resources.getString("PRODUCT_NAME"), jaghostnamevar});
    }

    public boolean isHidden() {
        return false;
    }

    public void setArgs(String[] args) throws Exception {
        this._args = args;
    }

    public void run() throws Exception {
        Vector argv = Utils.arrayToVector(this._args);
        if (argv.size() == 0) {
            throw new UsageException(this);
        }
        boolean done = false;
        boolean displayUsage = false;
        this.setContext(new RTContext());
        while (!done && argv.size() > 0) {
            String arg = (String)argv.elementAt(0);
            if (arg.equals("-host") || arg.equals("-h")) {
                if (argv.size() > 1) {
                    this.getBaseRTContext().setHostName((String)argv.elementAt(1));
                    argv.removeElementAt(0);
                    argv.removeElementAt(0);
                    continue;
                }
                throw new UsageException(this);
            }
            if (arg.equals("-port") || arg.equals("-n")) {
                if (argv.size() > 1) {
                    this.getBaseRTContext().setPort((String)argv.elementAt(1));
                    argv.removeElementAt(0);
                    argv.removeElementAt(0);
                    continue;
                }
                throw new UsageException(this);
            }
            if (arg.equals("-user") || arg.equals("-u")) {
                if (argv.size() > 1) {
                    this.getBaseRTContext().setUserName((String)argv.elementAt(1));
                    argv.removeElementAt(0);
                    argv.removeElementAt(0);
                    continue;
                }
                throw new UsageException(this);
            }
            if (arg.equals("-password") || arg.equals("-p")) {
                if (argv.size() > 1) {
                    this.getBaseRTContext().setPassword((String)argv.elementAt(1));
                    argv.removeElementAt(0);
                    argv.removeElementAt(0);
                    continue;
                }
                throw new UsageException(this);
            }
            if (arg.equals("-logfile") || arg.equals("-f")) {
                _logfile = (String)argv.elementAt(1);
                argv.removeElementAt(0);
                argv.removeElementAt(0);
                continue;
            }
            if (arg.equals("-loglevel") || arg.equals("-l")) {
                _loglevel = (String)argv.elementAt(1);
                argv.removeElementAt(0);
                argv.removeElementAt(0);
                if (this.isValidLogLevel(_loglevel)) continue;
                System.out.println("RaCommand[WARN]:  Loglevel '" + _loglevel + "' is not a valid log level. Defaulting to level '" + "INFO" + "'");
                _loglevel = "INFO";
                continue;
            }
            if (arg.equals("-help") || arg.equals("-?")) {
                displayUsage = true;
                done = true;
                argv.removeElementAt(0);
                continue;
            }
            done = true;
        }
        if (displayUsage) {
            throw new UsageException(this);
        }
        _log = _logfile.equals("") ? new RaLogger(1, _loglevel) : new RaLogger(1, _loglevel, _logfile);
        CommandFactory factory = CommandFactory.instance();
        factory.setLogger(_log);
        factory.initialize(BaseRTContext.getCommandFile());
        if (argv.size() == 0) {
            throw new UsageException(this);
        }
        String name = (String)argv.elementAt(0);
        if (name.startsWith("-")) {
            name = name.substring(1).trim();
        }
        argv.removeElementAt(0);
        if (!factory.hasCommand(name)) {
            throw new UsageException(this);
        }
        Command command = factory.createCommand(name);
        command.setArgs(argv);
        command.setContext((RTContext)this._context);
        command.setLogger(_log);
        command.run();
        this._commandStatus = command.getCommandStatus();
    }

    private boolean isValidLogLevel(String loglevel) {
        boolean isValid = false;
        for (int i = 0; i < LOGLEVEL_LIST.length; ++i) {
            if (!loglevel.equals(LOGLEVEL_LIST[i])) continue;
            isValid = true;
            break;
        }
        return isValid;
    }

    static {
        _resources = new RTResourceManager(RaTool.class);
        _logfile = "";
        _loglevel = "INFO";
    }
}

