/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.ratool;

import com.sybase.connector.repra.RepraConst;
import com.sybase.jaguar.management.JConnector;
import com.sybase.jaguar.management.JManagedConnectionFactory;
import com.sybase.jaguar.management.JRepository;
import com.sybase.jaguar.management.j2ee.EnvironmentProperty;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Upgrade20 {
    private static final String CONNECTOR_TYPE = "Connector";
    private static final String REPRA_CONNECTOR = "Repra";
    private static final String REPRA_CONNECTOR20 = "Repra20";
    private static final String TARGET_DIR = System.getProperty("JAGUAR") + "/repra/conf/";
    private static final String JAGUAR = System.getProperty("JAGUAR");
    private static final Hashtable _nameMap = new Hashtable();

    public Result[] upgrade(String userName, String password, String host, String port) throws Exception {
        JRepository rep = new JRepository(userName, password, host, port);
        JConnector jc = rep.getConnector(REPRA_CONNECTOR20);
        Vector<Result> results = new Vector<Result>();
        if (jc == null) {
            throw new Exception("Repra20 connector is not found");
        }
        Enumeration factories = jc.getManagedConnectionFactories();
        if (factories == null || !factories.hasMoreElements()) {
            throw new Exception("No factories found for connector Repra20");
        }
        while (factories.hasMoreElements()) {
            String factoryName;
            JManagedConnectionFactory jmcf = (JManagedConnectionFactory)factories.nextElement();
            Result result = new Result();
            result.connectorName = factoryName = jmcf.getName();
            if (factoryName.equals("RepAdapter_templete") || factoryName.equals("RepAdapter_template")) continue;
            try {
                String fileName = TARGET_DIR + factoryName + ".props";
                if (new File(fileName).exists()) {
                    throw new Exception("failed to create file: " + fileName + ". File exists.");
                }
                PrintWriter pw = this.getPrintWriter(fileName);
                this.printline(pw, "InboundType", "REPLICATION");
                this.printline(pw, "RSSDLogin", jmcf.getUserName());
                this.printline(pw, "RSSDPassword", jmcf.getPassword());
                this.printline(pw, "RSSDLogin", jmcf.getUserName());
                this.printline(pw, "RSSDPassword", jmcf.getPassword());
                Vector envProps = jmcf.getConfigProperties();
                for (int i = 0; i < envProps.size(); ++i) {
                    String outType;
                    EnvironmentProperty envProp = (EnvironmentProperty)envProps.elementAt(i);
                    String value = envProp.getValue();
                    String name = envProp.getName();
                    if (value != null && !value.equals("")) {
                        if (name.equals("Client_Protocol")) {
                            if (value.equals("MQ") || value.equals("MQJMS")) {
                                _nameMap.put("Client_Username", "MQ_Username");
                                _nameMap.put("Client_Password", "MQ_Password");
                                _nameMap.put("OutboundType", "IBMMQ");
                                _nameMap.put("MQType", value);
                            } else if (value.equals("RV") || value.equals("RVCM") || value.equals("TIBAECM")) {
                                _nameMap.put("OutboundType", "TIBCO");
                                if (!value.equalsIgnoreCase("TIBAECM")) {
                                    _nameMap.put("TIBType", value);
                                } else {
                                    _nameMap.put("TIBType", "AECM");
                                }
                            } else {
                                _nameMap.put("OutboundType", "JMS");
                            }
                        }
                        this.printline(pw, (String)_nameMap.get(name), value);
                    }
                    if ((outType = (String)_nameMap.get("OUTBOUND_TYPE")) == null || !outType.equals("IBMMQ")) continue;
                    String mqurl = (String)_nameMap.get("JMS_ProviderURL");
                    String mqhost = "localhost";
                    String mqport = "1414";
                    if (mqurl.indexOf(":") >= 0) {
                        mqhost = mqurl.substring(0, mqurl.indexOf(":")).trim();
                        mqport = mqurl.substring(mqurl.indexOf(":") + 1, mqurl.length()).trim();
                    } else {
                        mqhost = mqurl;
                        mqport = "1414";
                    }
                    _nameMap.put("MQ_Hostname", mqhost);
                    _nameMap.put("MQ_Channel", mqport);
                }
                pw.close();
                result.code = 1;
                result.message = "created file: " + new File(fileName).getCanonicalPath();
            }
            catch (Throwable t) {
                result.code = 0;
                result.message = t.toString();
            }
            results.add(result);
        }
        Object[] r = new Result[results.size()];
        results.copyInto(r);
        return r;
    }

    public void renameRepraToRepra20(String userName, String password, String host, String port) throws Exception {
        JRepository rep = new JRepository(userName, password, host, port);
        JConnector jc = rep.getConnector(REPRA_CONNECTOR);
        rep.removeConnector(jc);
        rep.move(CONNECTOR_TYPE, REPRA_CONNECTOR, REPRA_CONNECTOR20);
        rep.save();
        String oldclass = JAGUAR + "/java/classes/com/sybase/connector";
        try {
            File file = new File(oldclass);
            if (file.exists()) {
                file.renameTo(new File(oldclass + ".20"));
            }
        }
        catch (Throwable ex) {
            System.out.println(ex.toString());
        }
    }

    private void printline(PrintWriter pw, String key, String value) {
        String prop = key + "=" + value;
        System.out.println("writing prop: " + prop);
        pw.println(prop);
    }

    private PrintWriter getPrintWriter(String filename) throws IOException {
        File file = new File(filename);
        File parent = new File(file.getParent());
        parent.mkdirs();
        return new PrintWriter(new FileWriter(file));
    }

    public void printResult(Result[] results) {
        System.out.println("=========================================");
        System.out.println("====print result==========================");
        System.out.println("=========================================");
        if (results == null || results.length == 0) {
            System.out.println("no managed connection faoctries upgraded");
            return;
        }
        for (int i = 0; i < results.length; ++i) {
            Result result = results[i];
            if (result.code == 0) {
                System.out.println("Upgrade managed connector factory " + result.connectorName + " failed.");
                System.out.println("\tReason: " + result.message);
                continue;
            }
            System.out.println("Upgrade managed connector factory " + result.connectorName + " successed.");
            System.out.println("\tUpgrade status: " + result.message);
        }
    }

    public void upgradeTo25(String userName, String password, String host, String port) throws Exception {
        JRepository rep = new JRepository(userName, password, host, port);
        JConnector jc = rep.getConnector(REPRA_CONNECTOR);
        if (jc == null) {
            throw new Exception("Repra connector is not found");
        }
        Enumeration factories = jc.getManagedConnectionFactories();
        if (factories == null || !factories.hasMoreElements()) {
            throw new Exception("No factories found for connector Repra");
        }
        Properties props = null;
        while (factories.hasMoreElements()) {
            String rssdPass;
            JManagedConnectionFactory jmcf = (JManagedConnectionFactory)factories.nextElement();
            String factoryName = jmcf.getName();
            System.out.println("get MCF : " + factoryName);
            String rssdUser = jmcf.getUserName();
            if (rssdUser == null) {
                rssdUser = "";
            }
            if ((rssdPass = jmcf.getPassword()) == null) {
                rssdPass = "";
            }
            try {
                String fileName = TARGET_DIR + factoryName + ".props";
                System.out.println("got target fielName: " + fileName);
                if (new File(fileName).exists()) {
                    throw new Exception("failed to create file: " + fileName + ". File exists.");
                }
                File fptr = new File(TARGET_DIR);
                if (!fptr.exists()) {
                    fptr.mkdir();
                }
                props = new Properties();
                Vector envProps = jmcf.getConfigProperties();
                for (int i = 0; i < envProps.size(); ++i) {
                    EnvironmentProperty envProp = (EnvironmentProperty)envProps.elementAt(i);
                    String value = envProp.getValue();
                    String name = envProp.getName();
                    props.setProperty(name, value);
                }
                props.setProperty("ConnectionName", factoryName);
                props.setProperty("InboundType", "REPLICATION");
                props.setProperty("RSSDLogin", rssdUser);
                props.setProperty("RSSDPassword", rssdPass);
                props.setProperty("RepAdapterLogin", rssdUser);
                props.setProperty("RepAdapterPassword", rssdPass);
                props.setProperty("FormatterFlag", "false");
                String dtdURL = props.getProperty("DTD_URL", "http://localhost:8000/RepraWebApp/dtds/dbeventstream.xsd");
                if (dtdURL.indexOf("/repra/dtds/dbeventstream.dtd") >= 0) {
                    dtdURL = dtdURL.substring(0, dtdURL.indexOf("/repra/dtds/dbeventstream.dtd"));
                    dtdURL = dtdURL + "/RepraWebApp/dtds/dbeventstream.xsd";
                }
                props.setProperty("DTD_URL", dtdURL);
                String propValue = props.getProperty("Client_Protocol", "JMS");
                if (propValue.equals("JMS")) {
                    props.setProperty("OutboundType", "JMS");
                    props.setProperty("JMSType", "queue");
                    props.setProperty("JMS_Username", props.getProperty("Client_Username", "jagadmin"));
                    props.setProperty("JMS_Password", props.getProperty("Client_Password", "jagadmin"));
                } else if (propValue.equals("RV") || propValue.equals("RVCM") || propValue.equals("TIBAECM")) {
                    props.setProperty("OutboundType", "TIBCO");
                    if (propValue.equals("RVCM")) {
                        props.setProperty("TIBType", "RVCM");
                    } else if (propValue.equals("TIBAECM")) {
                        props.setProperty("TIBType", "AECM");
                    } else {
                        props.setProperty("TIBType", "RV");
                    }
                } else if (propValue.equals("MQ") || propValue.equals("MQJMS")) {
                    props.setProperty("OutboundType", "IBMMQ");
                    props.setProperty("MQ_Username", props.getProperty("Client_Username", "jagadmin"));
                    props.setProperty("MQ_Password", props.getProperty("Client_Password", "jagadmin"));
                    if (propValue.equals("MQ")) {
                        props.setProperty("MQType", "MQ");
                    } else {
                        props.setProperty("MQType", "MQJMS");
                        props.setProperty("JMSType", "queue");
                    }
                    String mqurl = props.getProperty("JMS_ProviderURL", "iiop://localhost:9000");
                    String mqhost = "localhost";
                    String mqport = "1414";
                    if (mqurl.indexOf(":") >= 0) {
                        mqhost = mqurl.substring(0, mqurl.indexOf(":")).trim();
                        mqport = mqurl.substring(mqurl.indexOf(":") + 1, mqurl.length()).trim();
                    } else {
                        mqhost = mqurl;
                        mqport = "1414";
                    }
                    props.setProperty("MQ_Hostname", mqhost);
                    props.setProperty("MQ_PortNumber", mqport);
                    props.setProperty("MQ_Channel", "");
                    props.setProperty("MQ_Encoding", props.getProperty("MQJMS_Encode", "utf"));
                }
                FileOutputStream fout = new FileOutputStream(fileName);
                props.store(fout, RepraConst.FILE_WARNING);
                fout.close();
            }
            catch (Exception ex) {
                throw new Exception("Failed to upgrade the MCF configuration.");
            }
        }
    }

    public static void main(String[] args) {
        block11: {
            if (JAGUAR == null || JAGUAR.equals("")) {
                System.out.println("JAGUAR is not set.");
                System.exit(-1);
            }
            String type = "upgrade";
            String host = "localhost";
            String port = "9000";
            String userName = "jagadmin";
            String password = "";
            if (args.length >= 1) {
                type = args[0];
            }
            if (args.length >= 2) {
                host = args[1];
            }
            if (args.length >= 3) {
                port = args[2];
            }
            if (args.length >= 4) {
                userName = args[3];
            }
            if (args.length >= 5) {
                password = args[4];
            }
            try {
                Upgrade20 upg = new Upgrade20();
                if (type.equals("renameRepra")) {
                    upg.renameRepraToRepra20(userName, password, host, port);
                    break block11;
                }
                if (type.equals("upgrade")) {
                    Result[] results = upg.upgrade(userName, password, host, port);
                    upg.printResult(results);
                    break block11;
                }
                if (type.equals("upgradeTo25")) {
                    upg.upgradeTo25(userName, password, host, port);
                    break block11;
                }
                throw new Exception("invalid type: " + type + ".  \nUsage: repra.Upgrade renameRepra [type] [hostName] [portNumber].  \n\t\ttype: renameRepra | upgrade.  Default to upgrade.  \n\t\thostName: default to localhost.  \n\t\tportNumber: default to 9000");
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.exit(-1);
            }
        }
    }

    static {
        _nameMap.put("JMS_LocalQueue", "JMS_LocalQueue");
        _nameMap.put("AutoStart", "AutoStart");
        _nameMap.put("DSIName", "DSIName");
        _nameMap.put("DSIPort", "DSIPort");
        _nameMap.put("RSSDURL", "RSSDURL");
        _nameMap.put("SQLINITSTR", "SQLINITSTR");
        _nameMap.put("RequiredGroup", "RequiredGroup");
        _nameMap.put("LogLevel", "LogLevel");
        _nameMap.put("Client_Protocol", "ClientProtocol");
        _nameMap.put("Client_Username", "JMS_Username");
        _nameMap.put("Client_Password", "JMS_Password");
        _nameMap.put("JMS_ProviderURL", "JMS_ProviderURL");
        _nameMap.put("JMS_InitialContext", "JMS_InitialContext");
        _nameMap.put("JMS_QCF", "JMS_QCF");
        _nameMap.put("MQJMS_Encode", "MQ_Encoding");
        _nameMap.put("MQLocal_Client", "MQ_LocalClient");
        _nameMap.put("RV_Service", "RV_Service");
        _nameMap.put("RV_Network", "RV_Network");
        _nameMap.put("RV_Daemon", "RV_Daemon");
        _nameMap.put("RV_Subject", "RV_Subject");
        _nameMap.put("RV_CMName", "RV_CMName");
        _nameMap.put("RV_CMDuration", "RV_CMDuration");
        _nameMap.put("DTD_URL", "DTD_URL");
        _nameMap.put("AppConfig", "AppConfig");
        _nameMap.put("MsgGenerator", "MsgGenerator");
    }

    private static class Result {
        static final int FAILURE = 0;
        static final int SUCCESS = 1;
        String connectorName;
        int code;
        String message;

        private Result() {
        }
    }
}

