/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.ratool.commands;

import com.sybase.connector.repra.ratool.BaseCommand;
import com.sybase.connector.repra.ratool.RTContext;
import com.sybase.connector.repra.ratool.RTResourceManager;
import com.sybase.connector.repra.ratool.commands.StartCommand;
import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaException;
import com.sybase.connector.repra.util.RaStatus;

public class CopyCommand
extends BaseCommand {
    private static RTResourceManager _resources = new RTResourceManager(StartCommand.class);

    public String getName() {
        return _resources.getString("copy.Name");
    }

    public String getDescription() {
        return _resources.getString("copy.Desc");
    }

    public String getUsage() {
        return _resources.getString("copy.Usage");
    }

    public boolean isHidden() {
        return false;
    }

    public void run() throws Exception {
        if (this._args.size() < 2) {
            _log.error("RaCommand[ERROR]:  " + _resources.getString("wrong.argument"));
            return;
        }
        String connName = (String)this._args.elementAt(0);
        String newName = (String)this._args.elementAt(1);
        _log.debug("RaCommand[DEBUG]:  copy.verbose.1'" + connName + "'");
        _log.debug("RaCommand[DEBUG]:  copy.verbose.2'" + newName + "'");
        try {
            RTContext context = (RTContext)this.getBaseRTContext();
            RaClientUtil raClient = context.getRaClient();
            RaStatus returnObj = raClient.copyConnection(connName, newName);
            if (returnObj == null || !(returnObj instanceof RaStatus)) {
                _log.error("RaCommand[ERROR]:  status.unknown");
                return;
            }
            RaStatus raS = returnObj;
            if (raS.getCode() == 0) {
                _log.info("RaCommand[INFO]:  Connection '" + connName + "'" + _resources.getString("copy.status.success"));
            } else if (raS.getCode() == 2) {
                _log.info("RaCommand[WARN]:  " + raS.getMessage());
            } else if (raS.getCode() == 4) {
                _log.error("RaCommand[ERROR]:  " + raS.getMessage());
            }
        }
        catch (RaException rae) {
            _log.error("RaCommand[ERROR]:  " + _resources.getString("copy.status.fail") + rae.toString());
        }
    }
}

