/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.ratool.commands;

import com.sybase.connector.repra.ratool.BaseCommand;
import com.sybase.connector.repra.ratool.RTContext;
import com.sybase.connector.repra.ratool.RTResourceManager;
import com.sybase.connector.repra.ratool.commands.StartCommand;
import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaException;
import com.sybase.connector.repra.util.RaStatus;

public class DeleteCommand
extends BaseCommand {
    private static RTResourceManager _resources = new RTResourceManager(StartCommand.class);

    public String getName() {
        return _resources.getString("delete.Name");
    }

    public String getDescription() {
        return _resources.getString("delete.Desc");
    }

    public String getUsage() {
        return _resources.getString("delete.Usage");
    }

    public boolean isHidden() {
        return false;
    }

    public void run() throws Exception {
        if (this._args.size() == 0) {
            _log.error("RaCommand[ERROR]:  " + _resources.getString("wrong.argument"));
            return;
        }
        String connName = (String)this._args.elementAt(0);
        try {
            RTContext context = (RTContext)this.getBaseRTContext();
            RaClientUtil raClient = context.getRaClient();
            RaStatus returnObj = raClient.deleteConnection(connName);
            if (returnObj == null) {
                _log.error("RaCommand[ERROR]:  " + _resources.getString("status.unknown"));
                return;
            }
            if (!(returnObj instanceof RaStatus)) {
                _log.error("RaCommand[ERROR]:  " + _resources.getString("status.unknown"));
            } else {
                RaStatus raS = returnObj;
                _log.debug("RaCommand[DEBUG]:  raStatus Object = " + raS.toString());
                if (raS.getCode() == 0) {
                    _log.info("RaCommand[INFO]:  Connection '" + connName + "'" + _resources.getString("delete.status.success"));
                } else if (raS.getCode() == 2) {
                    _log.warn("RaCommand[WARN]:  " + raS.getMessage());
                } else if (raS.getCode() == 4) {
                    _log.error("RaCommand[ERROR]:  " + raS.getMessage());
                }
            }
        }
        catch (RaException rae) {
            _log.error("RaCommand[ERROR]:  " + _resources.getString("delete.status.fail") + rae.toString());
        }
    }
}

