/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.ratool.commands;

import com.sybase.connector.repra.ratool.BaseCommand;
import com.sybase.connector.repra.ratool.RTContext;
import com.sybase.connector.repra.ratool.RTResourceManager;
import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaException;
import com.sybase.connector.repra.util.RaStatus;

public class GetLogInfoCommand
extends BaseCommand {
    private static RTResourceManager _resources = new RTResourceManager(GetLogInfoCommand.class);

    public String getName() {
        return _resources.getString("getLogInfo.Name");
    }

    public String getDescription() {
        return _resources.getString("getLogInfo.Desc");
    }

    public String getUsage() {
        return _resources.getString("getLogInfo.Usage");
    }

    public boolean isHidden() {
        return false;
    }

    public void run() throws Exception {
        _log.debug("RaCommand[DEBUG]:  At run() in getLogInfoCommand: " + this._args.toString().toString());
        if (this._args.size() == 0) {
            _log.error("RaCommand[ERROR]:  " + _resources.getString("wrong.argument"));
            return;
        }
        String connName = (String)this._args.elementAt(0);
        _log.debug("RaCommand[DEBUG]:  getLogInfo.verbose.1'" + connName + "'");
        String logFileName = null;
        boolean writeToFile = false;
        if (this._args.size() > 1 && ((String)this._args.elementAt(1)).equals("-file")) {
            writeToFile = true;
            logFileName = this._args.size() > 2 ? (String)this._args.elementAt(2) : connName + ".log";
        }
        try {
            RTContext context = (RTContext)this.getBaseRTContext();
            RaClientUtil raClient = context.getRaClient();
            RaStatus returnObj = raClient.getLogInfo(connName);
            if (returnObj == null || !(returnObj instanceof RaStatus)) {
                _log.error("RaCommand[ERROR]:  " + _resources.getString("status.unknown"));
                return;
            }
            RaStatus raS = returnObj;
            _log.debug("RaCommand[DEBUG]:  raStatus Object = " + raS.toString());
            if (raS.getCode() == 0) {
                Object retObj = raS.getReturnObject();
                if (retObj == null || !(retObj instanceof StringBuffer)) {
                    _log.error("RaCommand[ERROR]:  " + _resources.getString("status.unknown"));
                    return;
                }
                StringBuffer loginfo = (StringBuffer)retObj;
                if (writeToFile) {
                    _log.info("RaCommand[INFO]:  " + _resources.getString("getLogInfo.writeTo", new String[]{connName, logFileName}));
                    this.writeToFile(logFileName, connName, loginfo);
                } else {
                    _log.info(_resources.getString("getLogInfo.loginfo", new String[]{connName}));
                    _log.info(loginfo.toString());
                }
            } else if (raS.getCode() == 2) {
                _log.info("RaCommand[WARN]:  " + raS.getMessage());
            } else if (raS.getCode() == 4) {
                _log.error("RaCommand[ERROR]:  " + raS.getMessage());
            }
        }
        catch (RaException rae) {
            _log.error("RaCommand[ERROR]:  " + _resources.getString("getloginfo.status.fail") + rae.toString());
        }
    }
}

