/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.ratool.commands;

import com.sybase.connector.repra.ratool.BaseCommand;
import com.sybase.connector.repra.ratool.RTContext;
import com.sybase.connector.repra.ratool.RTResourceManager;
import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaException;
import com.sybase.connector.repra.util.RaStatus;
import com.sybase.connector.repra.util.RepraPropertyUtil;
import java.util.Properties;

public class ImportCommand
extends BaseCommand {
    private static RTResourceManager _resources = new RTResourceManager(ImportCommand.class);

    public String getName() {
        return _resources.getString("import.Name");
    }

    public String getDescription() {
        return _resources.getString("import.Desc");
    }

    public String getUsage() {
        return _resources.getString("import.Usage");
    }

    public boolean isHidden() {
        return false;
    }

    public void run() throws Exception {
        String override_arg;
        _log.debug("RaCommand[DEBUG]:  Arguments to ImportComamnd: " + this._args.toString());
        if (this._args.size() < 2) {
            _log.error("RaCommand[ERROR]:  " + _resources.getString("wrong.argument"));
            return;
        }
        String connName = (String)this._args.elementAt(0);
        String propFileName = (String)this._args.elementAt(1);
        Properties props = new Properties();
        try {
            props = this.getConfigProp(propFileName);
            if (!this.isValidConnProp(props)) {
                _log.error("RaCommand[ERROR]:  " + _resources.getString("import.status.fail.2"));
                return;
            }
        }
        catch (Exception ee) {
            _log.error("RaCommand[ERROR]:  " + _resources.getString("import.loadprop.fail") + ee.toString());
            return;
        }
        boolean override = false;
        if (this._args.size() > 2 && (override_arg = (String)this._args.elementAt(2)).equalsIgnoreCase("-override")) {
            override = true;
        }
        _log.debug("RaCommand[DEBUG]:  " + _resources.getString("import.verbose.1", new String[]{connName, props.toString(), String.valueOf(override)}));
        try {
            RTContext context = (RTContext)this.getBaseRTContext();
            RaClientUtil raClient = context.getRaClient();
            RaStatus returnObj = raClient.createConnection(connName, RepraPropertyUtil.decProperties(props), override);
            if (returnObj == null || !(returnObj instanceof RaStatus)) {
                _log.error("RaCommand[ERROR]:  " + _resources.getString("status.unknown"));
                return;
            }
            _log.debug("RaCommand[DEBUG]:  " + _resources.getString("import.returnObj") + ((Object)returnObj).toString());
            RaStatus raS = returnObj;
            _log.debug("RaCommand[DEBUG]:  " + _resources.getString("import.returnCode") + String.valueOf(raS.getCode()));
            if (raS.getCode() == 0) {
                _log.info("RaCommand[INFO]:  Connection '" + connName + "'" + _resources.getString("import.status.success"));
            } else if (raS.getCode() == 2) {
                _log.info("RaCommand[WARN]:  " + raS.getMessage());
            } else if (raS.getCode() == 4) {
                _log.error("RaCommand[ERROR]:  " + raS.getMessage());
            }
        }
        catch (RaException rae) {
            _log.error("RaCommand[ERROR]:  " + _resources.getString("import.status.fail") + rae.toString());
        }
    }
}

