/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.ratool.commands;

import com.sybase.connector.repra.ratool.BaseCommand;
import com.sybase.connector.repra.ratool.RTContext;
import com.sybase.connector.repra.ratool.RTResourceManager;
import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaException;
import com.sybase.connector.repra.util.RaStatus;
import java.util.Vector;

public class ListCommand
extends BaseCommand {
    private static RTResourceManager _resources = new RTResourceManager(ListCommand.class);

    public String getName() {
        return _resources.getString("list.Name");
    }

    public String getDescription() {
        return _resources.getString("list.Desc");
    }

    public String getUsage() {
        return _resources.getString("list.Usage");
    }

    public boolean isHidden() {
        return false;
    }

    public void run() throws Exception {
        try {
            RTContext context = (RTContext)this.getBaseRTContext();
            RaClientUtil raClient = context.getRaClient();
            RaStatus returnObj = raClient.getConnections();
            if (returnObj == null || !(returnObj instanceof RaStatus)) {
                _log.error(_resources.getString("status.unknown"));
                return;
            }
            if (returnObj instanceof RaStatus) {
                RaStatus raS = returnObj;
                if (raS.getCode() == 0) {
                    Object retObj = raS.getReturnObject();
                    if (retObj != null && retObj instanceof Vector) {
                        Vector retV = (Vector)retObj;
                        if (retV.size() == 0) {
                            _log.info("RaCommand[INFO]:  " + _resources.getString("no.connections"));
                            return;
                        }
                        _log.info(_resources.getString("list.connections"));
                        for (int i = 0; i < retV.size(); ++i) {
                            _log.info("\t" + (String)retV.elementAt(i));
                        }
                    } else {
                        _log.error(_resources.getString("status.unknown"));
                    }
                } else if (raS.getCode() == 2) {
                    _log.warn("RaCommand[WARN]:  " + raS.getMessage());
                } else if (raS.getCode() == 4) {
                    _log.error("RaCommand[ERROR]:  " + raS.getMessage());
                }
            }
        }
        catch (RaException rae) {
            _log.error("RaCommand[ERROR]:  " + _resources.getString("list.status.fail") + rae.getMessage());
        }
    }
}

