/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.ratool.commands;

import com.sybase.connector.repra.ratool.BaseCommand;
import com.sybase.connector.repra.ratool.RTContext;
import com.sybase.connector.repra.ratool.RTResourceManager;
import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaException;
import com.sybase.connector.repra.util.RaStatus;
import java.util.Vector;

public class StartAllCommand
extends BaseCommand {
    private static RTResourceManager _resources = new RTResourceManager(StartAllCommand.class);

    public String getName() {
        return _resources.getString("startall.Name");
    }

    public String getDescription() {
        return _resources.getString("startall.Desc");
    }

    public String getUsage() {
        return _resources.getString("startall.Usage");
    }

    public boolean isHidden() {
        return false;
    }

    public void run() throws Exception {
        try {
            RTContext context = (RTContext)this.getBaseRTContext();
            RaClientUtil raClient = context.getRaClient();
            Vector returnObj = raClient.startConnection();
            if (returnObj == null || !(returnObj instanceof Vector)) {
                _log.error("RaCommand[ERROR]:  " + _resources.getString("status.unknown"));
                return;
            }
            Vector raV = returnObj;
            if (raV.size() == 0) {
                _log.info("RaCommand[INFO]:  " + _resources.getString("startall.no.connections"));
                return;
            }
            _log.info(_resources.getString("startall.result"));
            _log.info(_resources.getString("startall.status"));
            _log.info("---------------------\t------");
            _log.info("");
            for (int i = 0; i < raV.size(); ++i) {
                RaStatus raS = (RaStatus)raV.elementAt(i);
                if (raS.getCode() == 0) {
                    _log.info(raS.getConnectionName() + "\t\t" + _resources.getString("startall.status.success"));
                    continue;
                }
                if (raS.getCode() != 2 && raS.getCode() != 4) continue;
                _log.error(raS.getConnectionName() + "\t\t" + raS.getMessage());
            }
        }
        catch (RaException rae) {
            _log.error("RaCommand[ERROR]:  " + _resources.getString("startall.status.fail") + rae.getMessage());
        }
    }
}

