/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.repra.ratool.commands;

import com.sybase.connector.repra.ratool.BaseCommand;
import com.sybase.connector.repra.ratool.RTContext;
import com.sybase.connector.repra.ratool.RTResourceManager;
import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaException;
import com.sybase.connector.repra.util.RaStatus;

public class StopCommand
extends BaseCommand {
    private static RTResourceManager _resources = new RTResourceManager(StopCommand.class);

    public String getName() {
        return _resources.getString("stop.Name");
    }

    public String getDescription() {
        return _resources.getString("stop.Desc");
    }

    public String getUsage() {
        return _resources.getString("stop.Usage");
    }

    public boolean isHidden() {
        return false;
    }

    public void run() throws Exception {
        if (this._args.size() == 0) {
            _log.error("RaCommand[ERROR]:  " + _resources.getString("status.unknown"));
            return;
        }
        String connName = (String)this._args.elementAt(0);
        try {
            RTContext context = (RTContext)this.getBaseRTContext();
            RaClientUtil raClient = context.getRaClient();
            RaStatus returnObj = raClient.stopConnection(connName);
            if (returnObj == null || !(returnObj instanceof RaStatus)) {
                _log.error("RaCommand[ERROR]:  " + _resources.getString("status.unknown"));
                return;
            }
            RaStatus raS = returnObj;
            _log.debug("RaCommand[DEBUG]:  raStatus Object = " + raS.toString());
            if (raS.getCode() == 0) {
                _log.info("RaCommand[INFO]:  Connection '" + connName + "'" + _resources.getString("stop.status.success"));
            } else if (raS.getCode() == 2) {
                _log.info("RaCommand[WARN]:  " + raS.getMessage());
            } else if (raS.getCode() == 4) {
                _log.error("RaCommand[ERROR]:  " + raS.getMessage());
            }
        }
        catch (RaException rae) {
            _log.error("RaCommand[ERROR]:  " + _resources.getString("stop.status.fail") + rae.getMessage());
        }
    }
}

